/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.view;

import org.eclipse.swt.widgets.Display;

import com.clustercontrol.etc.action.BackGroundAction;
import com.clustercontrol.etc.action.UpdateViewTask;

/**
 * ưǽݥӥ塼饹
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public abstract class AutoUpdateView extends CommonViewPart {

    //	 ----- instance ե ----- //

    /** ưѥ */
    private BackGroundAction reloadAction = null;

    /** ưե饰 */
    private boolean autoReloaded = false;

    /** ưֳ() */
    private int interval = 0;

    //	 ----- instance ᥽å ----- //

    /**
     * ưǤ뤫֤ޤ
     * 
     * @return ưǤ硢true
     */
    public boolean isAutoReloaded() {
        return this.autoReloaded;
    }

    /**
     * ưǤ뤫ꤷޤ
     * 
     * @param autoReloaded
     *            ưǤ硢true
     */
    protected void setAutoReloaded(boolean autoReloaded) {
        this.autoReloaded = autoReloaded;
    }

    /**
     * ưֳ()֤ޤ
     * 
     * @return ưֳ()
     */
    public int getInterval() {
        return this.interval;
    }

    /**
     * ưֳ()ꤷޤ
     * 
     * @param interval
     *            ưֳ()
     */
    public void setInterval(int interval) {
        this.interval = interval;
    }

    /**
     * ꤵ줿ֳ֤Ǽư¹Ԥޤ
     * <p>
     * 
     * ưǤ˼¹ξ硢߸˺Ƴޤ <br>
     * ưֳ֤0ʲξ硢ϼ¹Ԥޤ
     */
    public void startAutoReload() {
        this.stopAutoReload();

        int interval = this.getInterval();
        if (interval > 0) {
            UpdateViewTask task = new UpdateViewTask(this);

            Display display = this.getViewSite().getShell().getDisplay();
            this.reloadAction = new BackGroundAction(display, task,
                    interval * 1000 * 60);

            this.reloadAction.start();
            this.setAutoReloaded(true);
        }
    }

    /**
     * ưߤޤ
     */
    public void stopAutoReload() {
        if (this.reloadAction != null) {
            this.reloadAction.stop();
        }

        this.reloadAction = null;
        this.setAutoReloaded(false);
    }

    /**
     * ưλޤ
     */
    public void dispose() {
        super.dispose();
        this.stopAutoReload();
    }

    /**
     * ӥ塼ιԤޤ
     */
    public abstract void update();
}