/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.collectiverun.bean;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * ĥ꡼¤뤿Υ饹
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class TreeItem implements Serializable, Cloneable {
	private static final long serialVersionUID = -8195124905953255470L;

	/**  */
	protected TreeItem parent = null;

    /** 󥪥֥ */
    protected ItemInfo info = null;

    /** ҤγǼꥹ */
    protected List<TreeItem> children = null;

    /**
     * ξݻ󥹥󥹤֤ޤ
     * 
     * @param parent
     *            ƤΥ֥
     * @param data
     *            ׾󥪥֥
     */
    public TreeItem(TreeItem parent, ItemInfo info) {

        this.setParent(parent);
        this.setInfo(info);

        if (parent != null) {
            parent.addChildren(this);
        }

        this.children = new ArrayList<TreeItem>();
    }

    // ----- instance ե ----- //

    /**
     * Ƥ֤ޤ
     * 
     * @return 
     */
    public TreeItem getParent() {
        return this.parent;
    }

    /**
     * Ƥꤷޤ
     * <p>
     * 
     * 󥹥󥹲κݤ˿ƤشطդƤ뤿ᡢҤ᥽åɤ ˲Ļ()礷Ʋ <br>
     * ޤƤؤδطդԤ褦˼Ʋ
     * 
     * @return 
     */
    public void setParent(TreeItem parent) {
        this.parent = parent;
    }

    /**
     * ֤ޤ
     * 
     * @return 
     */
    public ItemInfo getInfo() {
        return this.info;
    }

    /**
     * ꤷޤ
     * 
     * @param data 
     */
    public void setInfo(ItemInfo info) {
        this.info = info;
    }

    /**
     * Ҥɲäޤ
     * <p>
     * 
     * κݡchildeοƤϤΥ֥ȤȤꤵޤ
     * 
     * @param child 
     */
    public void addChildren(TreeItem child) {
        child.setParent(this);
        children.add(child);
    }
    
    /**
     * Ҥޤ
     * 
     * @param child
     */
    public void removeChildren(TreeItem child) {
        for (int i = 0; i < children.size(); i++) {
            if (child.equals(children.get(i))) {
                children.remove(i);
                break;
            }
        }
    }

    /**
     * Ҥο֤ޤ
     * 
     * @return Ҥο
     */
    public int size() {
        return children.size();
    }

    /**
     * ƤλҤ֤ޤ
     * <p>
     * 
     * ¤ӽϡɲä줿ȤʤäƤޤ
     * 
     * @return Ƥλҡ
     */
    public TreeItem[] getChildren() {
        TreeItem[] result = new TreeItem[this.size()];
        return (TreeItem[]) children.toArray(result);
    }
    
    /* (non-Javadoc)
     * @see java.lang.Object#clone()
     */
    public Object clone() {
        ItemInfo cloneInfo = (ItemInfo)this.getInfo().clone();
        if(cloneInfo == null)
        	return null;
        
        TreeItem clone = new TreeItem(null, cloneInfo);
        
        return clone;
    }
}