/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.collectiverun.util;

import java.util.ArrayList;
import java.util.List;

import com.clustercontrol.collectiverun.bean.CommandInfo;
import com.clustercontrol.collectiverun.bean.CommandParameterInfo;
import com.clustercontrol.collectiverun.bean.ItemConstant;
import com.clustercontrol.collectiverun.bean.ItemInfo;
import com.clustercontrol.collectiverun.bean.ParameterInfo;
import com.clustercontrol.collectiverun.bean.TreeItem;
import com.clustercontrol.collectiverun.bean.TypeInfo;

/**
 * 泬إĥ꡼桼ƥƥ饹
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class TreeItemUtil {

    /**
     * TreeItem饹򥳥ԡ
     * 
     * @param original
     * @return ԡTreeItem饹
     * @since 2.1.0
     */
    public static TreeItem copy(TreeItem original) {
        TreeItem clone = null;
        if(original != null){
            clone = (TreeItem)original.clone();
        }
        
        return clone;
    }
    
    /**
     * TreeItem饹򥳥ԡ
     * 
     * @param original
     * @return ԡTreeItem饹
     * @since 2.1.0
     */
    public static TreeItem copy(TreeItem original, TreeItem top) {
        TreeItem clone = copy(original);
        
        return clone;
    }
    
    /**
     * 泬إĥ꡼ѥ᡼ID
     * 
     * @param top
     * @return
     * @since 2.1.0
     */
    public static List<String> getParameterIdList(TreeItem top) {
    	ArrayList<String> list = new ArrayList<String>();
    	
    	TreeItem children[] = top.getChildren();
    	TreeItem parametaer[] = children[1].getChildren();
    	
    	for(int i = 0; i < parametaer.length; i++){
    		ParameterInfo info = (ParameterInfo)parametaer[i].getInfo();
    		list.add(info.getId());
    	}

        return list;
    }
    
    /**
     * 泬إĥ꡼ѥ᡼IDˤѥ᡼̾
     * 
     * @param paramId
     * @param top
     * @return
     * @since 2.1.0
     */
    public static String getParameterName(String paramId, TreeItem top) {
    	TreeItem children[] = top.getChildren();
    	TreeItem parametaer[] = children[1].getChildren();
    	
    	for(int i = 0; i < parametaer.length; i++){
    		ParameterInfo info = (ParameterInfo)parametaer[i].getInfo();
    		if(info.getId().equals(paramId))
    			return info.getName();
    	}

        return null;
    }
    
    /**
     * TreeItem饹κǾ̤Υ󥹥󥹤
     * 
     * @param item
     * @return Ǿ̤Υ󥹥
     * @since 2.1.0
     */
    public static TreeItem getTopTreeItem(TreeItem item) {
        if(item == null)
            return null;
        
        while (item.getParent() != null) {
            item = item.getParent();
        }
        
        return item;
    }
    
    /**
     * TreeItem饹Ʊ̤Υ󥹥󥹤orderNo
     * 
     * @param item
     * @return 
     * @since 2.1.0
     */
    public static int getMaxOrderNo(TreeItem parent) {
        if(parent == null)
            return -1;
        
        TreeItem children[] = parent.getChildren();
        
        int max = -1;
    	for(int i = 0; i < children.length; i++){
    		ItemInfo info = (ItemInfo)children[i].getInfo();
    		if(info.getOrderNo() > max){
    			max = info.getOrderNo();
    		}
    	}
    	
        return max;
    }
    
    /**
     * TreeItem饹Υ󥹥󥹤ξ岼ưоݥ󥹥󥹤
     * 
     * @param item
     * @param up
     * @return
     * @since 2.1.0
     */
    public static TreeItem getUpDownTargetItem(TreeItem item, Boolean up) {
        if(item == null)
            return null;
        
        TreeItem target = null;
        TreeItem parent = item.getParent();
        TreeItem children[] = parent.getChildren();
        ItemInfo info = item.getInfo();
        
        if(up){
            int max = Integer.MIN_VALUE;
        	for(int i = 0; i < children.length; i++){
        		ItemInfo childInfo = (ItemInfo)children[i].getInfo();
        		if(childInfo.getOrderNo() > max && 
        				childInfo.getOrderNo() < info.getOrderNo()){
        			max = childInfo.getOrderNo();
        			target = children[i];
        		}
        	}
        }
        else{
            int min = Integer.MAX_VALUE;
        	for(int i = 0; i < children.length; i++){
        		ItemInfo childInfo = (ItemInfo)children[i].getInfo();
        		if(childInfo.getOrderNo() < min && 
        				childInfo.getOrderNo() > info.getOrderNo()){
        			min = childInfo.getOrderNo();
        			target = children[i];
        		}
        	}
        }
    	
        return target;
    }
    
    /**
     * ̾򸡺
     * 
     * @param typeName
     * @param item
     * @return
     * @since 2.1.0
     */
    public static boolean findTypeName(String typeName, TreeItem item) {
        boolean find = false;
        
        //̾å
        String name = item.getInfo().getName();
        if(name != null && name.length() > 0){
            if(name.compareTo(typeName) == 0){
                find = true;
                return find;
            }
        }
        
        //TreeItem
        TreeItem[] children = item.getChildren();
        for(int i = 0; i < children.length; i++){
            find = findTypeName(typeName, children[i]);
            if(find){
                break;
            }
        }
        
        return find;
    }
    
    /**
     * TreeItem饹Ʊ̤Υ󥹥󥹤פID򸡺
     * 
     * @param id
     * @param parent
     * @return
     */
    public static boolean findId(String id, TreeItem parent) {
    	if(parent == null)
            return false;
        
        TreeItem children[] = parent.getChildren();
        
    	for(int i = 0; i < children.length; i++){
    		ItemInfo info = (ItemInfo)children[i].getInfo();
    		
    		if(info.getType() == ItemConstant.TYPE_TYPE){
    			if(id.equals(((TypeInfo)info).getId())){
                    return true;
    			}
    		}
    		else if(info.getType() == ItemConstant.TYPE_COMMAND){
    			if(id.equals(((CommandInfo)info).getId())){
                    return true;
    			}
    		}
    		else if(info.getType() == ItemConstant.TYPE_COMMAND_PARAMETER){
    			if(id.equals(((CommandParameterInfo)info).getId())){
                    return true;
    			}
    		}
    		else if(info.getType() == ItemConstant.TYPE_PARAMETER){
    			if(id.equals(((ParameterInfo)info).getId())){
                    return true;
    			}
    		}
    	}
    	
        return false;
    }
}