/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.collectiverun.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;

import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.collectiverun.bean.ItemInfo;
import com.clustercontrol.collectiverun.ejb.session.CollectiveRunController;
import com.clustercontrol.collectiverun.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;

/**
 * ޥ饹
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class DeleteMaster {
	
	/**
	 * ޥ
	 * 
	 * @param info
	 * @return
	 */
	public boolean delete(ItemInfo info, ItemInfo parentInfo) {
        CollectiveRunController collectiveRun = 
        	EjbConnectionManager.getConnectionManager().getCollectiveRunController();

		try {
		    collectiveRun.deleteMaster(info, parentInfo);
		    return true;
		} catch (RemoteException e) {
			if(e instanceof AccessException){
				// ʤξ硢顼ɽ
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
        } catch (NamingException e) {
		} catch (FinderException e) {
		} catch (RemoveException e) {
		}
        return false;
	}
}
