/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.collectiverun.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.util.Locale;

import com.clustercontrol.bean.Property;
import com.clustercontrol.collectiverun.ejb.session.CollectiveRunController;
import com.clustercontrol.collectiverun.util.EjbConnectionManager;

/**
 * [ѥ᡼]饹
 * 
 * Ф[ѥ᡼]ޤ
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class GetParameterProperty {

    /**
     * [ѥ᡼]
     * 
     * @param sessionId
     * @return ץѥƥ
     * @throws AccessException 
     */
    public Property getPropertyBySessionId(String sessionId) throws AccessException {
        CollectiveRunController collectiveRun = EjbConnectionManager
                .getConnectionManager().getCollectiveRunController();

        Property property = null;
        try {
            property = collectiveRun.getParameterPropertyBySessionId(sessionId, Locale
                    .getDefault());
        } catch (RemoteException e) {
			if(e instanceof AccessException){
				// ʤξ
				throw (AccessException) e;
			}
        }
        return property;
    }

    /**
     * [ѥ᡼]
     * 
     * @param typeId
     * @return ץѥƥ
     * @throws AccessException 
     */
    public Property getProperty(String typeId) throws AccessException {
        CollectiveRunController collectiveRun = EjbConnectionManager
                .getConnectionManager().getCollectiveRunController();

        Property property = null;
        try {
            property = collectiveRun.getParameterProperty(typeId, Locale
                    .getDefault());
        } catch (RemoteException e) {
			if(e instanceof AccessException){
				// ʤξ
				throw (AccessException) e;
			}
        }
        return property;
    }

    /**
     * [ѥ᡼]ID
     * 
     * @param sessionId
     * @return
     * @throws AccessException 
     */
    public String getTypeId(String sessionId) throws AccessException {
        CollectiveRunController collectiveRun = EjbConnectionManager
                .getConnectionManager().getCollectiveRunController();

        try {
            return collectiveRun.getParameterTypeId(sessionId);
        } catch (RemoteException e) {
			if(e instanceof AccessException){
				// ʤξ
				throw (AccessException) e;
			}
        }
        return null;
    }
}