/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.collectiverun.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import com.clustercontrol.collectiverun.ejb.session.CollectiveRunController;
import com.clustercontrol.collectiverun.util.EjbConnectionManager;

/**
 * ̾饹
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class GetType {
	
	/**
	 * ̾(HashMap)
	 * 
	 * @return 
	 * @throws AccessException 
	 */
	@SuppressWarnings("unchecked")
	public HashMap<String, String> getTypeHashMap() throws AccessException {
        CollectiveRunController collectiveRun = 
        	EjbConnectionManager.getConnectionManager().getCollectiveRunController();

        HashMap<String, String> map = null;
		try {
			map = collectiveRun.getTypeHashMap(Locale.getDefault());
		} catch (RemoteException e) {
			if(e instanceof AccessException){
				// ʤξ
				throw (AccessException) e;
			}
		} catch (FinderException e) {
        } catch (NamingException e) {
        }
		return map;
	}
	
	/**
	 * ̾(List)
	 * 
	 * @return
	 * @throws AccessException 
	 */
	@SuppressWarnings("unchecked")
	public List<String> getTypeStringList() throws AccessException {
        CollectiveRunController collectiveRun = 
        	EjbConnectionManager.getConnectionManager().getCollectiveRunController();

        List<String> list = null;
		try {
			list = collectiveRun.getTypeStringList(Locale.getDefault());
		} catch (RemoteException e) {
			if(e instanceof AccessException){
				// ʤξ
				throw (AccessException) e;
			}
		} catch (FinderException e) {
        } catch (NamingException e) {
        }
		return list;
	}
}
