/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.collectiverun.factory;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * ޥɼ¹ԥåɥ饹
 *
 * @version $Revision: 1.8 $
 * @since 1.0.0
 */
public class CommandExecutor {

    protected String m_resultMsg = "";
    protected String m_errMsg = "";
    protected int m_exitValue;
    
    //
	static private Log log = LogFactory.getLog(CommandExecutor.class);

	
	/**
	 * ǥХåѥᥤ
	 * 
	 * @param args
	 */
	public static void main(String[] args) {

		new CommandExecutor();
		
	}
	
	/**
	 * 󥹥ȥ饯
	 */
	public CommandExecutor() {
		super();
	}
	
	
    
	/**
	 * ޥɼ¹
	 * 
	 * @param cmd	ޥ
	 * @return	/
	 */
	public boolean exec(String[] cmd, String inputData, String endValueStr){
		Runtime runtime = Runtime.getRuntime();

		//ޥɵư
		Process process;
		try {
			if(log.isDebugEnabled()){
				for (int i = 0; i < cmd.length; i++) {
					log.info("Command Execute:" + cmd[i]);
				}
			}
			process = runtime.exec(cmd);
		} catch (IOException e) {
			log.error(e);
			m_errMsg = e.getMessage();
			return false;
		}
		
		try {
			//ɸϥ꡼
		    BufferedReader inbr = new BufferedReader(new InputStreamReader(process.getInputStream()));
			//顼ϥ꡼
			BufferedReader erbr = new BufferedReader(new InputStreamReader(process.getErrorStream()));
			//ɸϥ饤
			BufferedWriter outbw = new BufferedWriter(new OutputStreamWriter(process.getOutputStream()));
			
			//ɸѥХåե
		    StringBuffer inbuff = new StringBuffer();
			//顼ѥХåե
		    StringBuffer errbuff = new StringBuffer();
		    
		    //ɸϤؽ
		    if( inputData != null ){
			    try {
	                outbw.write(inputData);
	                outbw.flush();
	            } catch (IOException e1) {
	
	            }
            }
		    
            //¹ԴλԤӡɸɤ߹ߡ顼ɤ߹
		    while(true){

		        try{
		            m_exitValue = process.exitValue();
			        break;
		        }catch (IllegalThreadStateException e) {
		            try {
                        Thread.sleep(100);
                    } catch (InterruptedException e2) {
                    	break;
                    }
		        }

		        readBuff(inbr, inbuff);
		        readBuff(erbr, errbuff); 

		        int idx = inbuff.lastIndexOf(endValueStr);
                if (idx != -1) {
    			    try {
    	                outbw.write("\n");
    	                outbw.flush();
    	            } catch (IOException e1) {
    	
    	            }
                }

		    }

            readBuff(inbr, inbuff);
            readBuff(erbr, errbuff); 
		    
	        m_resultMsg = inbuff.toString();
	        m_errMsg = errbuff.toString();

		    return true;
		
		}
		finally{
			process.destroy();
		}
	}
	/**
	 * 
	 * Хåեʸɤ߽Ф
	 * 
	 * @param brɤ߽ФоݤΥХåե
	 * @param resultɤ߽ФʸγǼХåե
	 * @since
	 */
	public void readBuff(BufferedReader br, StringBuffer result) {

	    char[] buff = new char[256];
	    while(true){
	        try {
	            if(!br.ready()){
	                break;
	            }
                //ɤ߹
                int length  = br.read(buff);
                if(length == -1)
                    break;

                result.append(buff,0,length);
                log.debug(new String(buff,0,length));
                
	        } catch (IOException e) {
	            log.error(e);
	            break;
	        }
	    }
	    return ;


	}
    /**
     * @return errMsg ᤷޤ
     */
    public String getErrMsg() {
        return m_errMsg;
    }
    /**
     * @return exitValue ᤷޤ
     */
    public int getExitValue() {
        return m_exitValue;
    }
    /**
     * @return resultMsg ᤷޤ
     */
    public String getResultMsg() {
        return m_resultMsg;
    }
}

