/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.collectiverun.factory;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;

import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.CollectiveRunStatusConstant;
import com.clustercontrol.bean.EndStatusConstant;
import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.bean.Property;
import com.clustercontrol.collectiverun.bean.CommandTypeConstant;
import com.clustercontrol.collectiverun.bean.ParameterTypeConstant;
import com.clustercontrol.collectiverun.bean.QueueConstant;
import com.clustercontrol.collectiverun.ejb.entity.CRunCmdMstLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunCmdMstUtil;
import com.clustercontrol.collectiverun.ejb.entity.CRunCmdParamMstLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunEndMstLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunEndMstPK;
import com.clustercontrol.collectiverun.ejb.entity.CRunEndMstUtil;
import com.clustercontrol.collectiverun.ejb.entity.CRunParamSelectMstLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunParamSelectMstUtil;
import com.clustercontrol.collectiverun.ejb.entity.CRunSessionDetailLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunSessionDetailPK;
import com.clustercontrol.collectiverun.ejb.entity.CRunSessionDetailUtil;
import com.clustercontrol.collectiverun.ejb.entity.CRunSessionLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunSessionParamLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunSessionParamPK;
import com.clustercontrol.collectiverun.ejb.entity.CRunSessionParamUtil;
import com.clustercontrol.collectiverun.ejb.entity.CRunSessionUtil;
import com.clustercontrol.collectiverun.message.CollectiveRunInstructionInfo;
import com.clustercontrol.collectiverun.util.SendQueue;
import com.clustercontrol.jobmanagement.bean.RunStatusConstant;
import com.clustercontrol.jobmanagement.message.RunResultInfo;
import com.clustercontrol.repository.bean.FacilityAttributeConstant;
import com.clustercontrol.repository.ejb.session.RepositoryControllerBean;
import com.clustercontrol.repository.ejb.session.RepositoryControllerLocal;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;
import com.clustercontrol.util.apllog.AplLogger;

/**
 * 饹
 *
 * @version 1.0.0
 * @since 1.0.0
 */
public class OperationRun {
    protected static Log m_log = LogFactory.getLog( OperationRun.class );
    protected static String SHELL_COMMAND = "sh";

    /**
     * ޥɼ¹
     * 
     * @param sessionId
     * @param property
     * @param locale
     * @throws CreateException
     * @throws FinderException
     * @throws NamingException
     * @throws IOException
     */
    public void run(String sessionId) throws CreateException, FinderException, NamingException, IOException {
        m_log.debug("run() : sessionId=" + sessionId);
        
		//åID饻å(¹)
		CRunSessionLocal session = 
		    CRunSessionUtil.getLocalHome().findByPrimaryKey(sessionId);
		
		//¹ԥޥɼ
        String command = getCommand(session);
        
        //ơԵξ
        if(session.getStatus().intValue() == CollectiveRunStatusConstant.TYPE_WAITING){
            //ơ¹ˤ
            session.setStatus(new Integer(CollectiveRunStatusConstant.TYPE_RUNNING));
            //
            session.setStart_date(new Date());
        }
        
		//Ρɤؼ¹
		startNode(session, command);
    }
    
    /**
     * Ρɤؤμ¹Խ
     * 
     * @param sessionId
     * @param facilityId
     * @param command
     * @return
     * @throws FinderException
     * @throws NamingException
     */
    protected void startNode(CRunSessionLocal session, String command) throws FinderException, NamingException {
        m_log.debug("startNode() start: sessionId=" + session.getSession_id());
        
        //åID
        String sessionId = session.getSession_id();
        
        //ޥID饳ޥɥޥ
        CRunCmdMstLocal cmd = CRunCmdMstUtil.getLocalHome().findByPrimaryKey(session.getCommand_id());
        //ޥɥޥ饳ޥɥפ
        int commandType = cmd.getCommand_type().intValue();

        String password = null;
        try {
			CRunSessionParamLocal param = CRunSessionParamUtil.getLocalHome().findByPrimaryKey(
					new CRunSessionParamPK(sessionId, "PASSWORD"));
			password = param.getParam_value();
		} catch (Exception e1) {
		}

        //åǥơ(¹ܺ)
        Collection collection = session.getSessionDetail();
        if(collection != null && collection.size() > 0){
            //Queue饹
            SendQueue send = null;
            try {
                send = new SendQueue(QueueConstant.QUEUE_NAME_EXECUTE);
            } catch (Exception e) {
                m_log.debug("startNode() : ¹Իؼ顼 : " + e.getMessage());
            }
            
            Iterator itr = collection.iterator();
            while(itr.hasNext()){
                CRunSessionDetailLocal sessionDetail = (CRunSessionDetailLocal)itr.next();
                
                //¹Ծ
                CollectiveRunInstructionInfo info = new CollectiveRunInstructionInfo();
                info.setSessionId(sessionId);
                info.setFacilityId(sessionDetail.getFacility_id());
                if(commandType == CommandTypeConstant.TYPE_SHELL){
                    info.setCommand(SHELL_COMMAND);
                    info.setInputFile(command);
                }
                else{
                    info.setCommand(command);
                }
                info.setCommandType(com.clustercontrol.jobmanagement.bean.CommandTypeConstant.NORMAL);
                
                info.setPassword(password);
                
                try {
                    //Queue
                    send.put(info);
                } catch (Exception e) {
                    AplLogger apllog = new AplLogger("CR","cr");
                    String[] args = {info.getSessionId(), info.getFacilityId()};
                    apllog.put("SYS","003", args);
                    m_log.debug("startNode() : ¹Իؼ顼 : " + e.getMessage());
                }
            }
            
            //Queue饹
            try {
                send.close();
            } catch (Exception e) {
                m_log.debug("startNode() : ¹Իؼ顼 : " + e.getMessage());
            }
        }
        
        m_log.debug("startNode() end: sessionId=" + session.getSession_id());
    }
    
    /**
     * Ρɽλ
     * 
     * @param info
     * @throws FinderException
     * @throws NamingException
     */
    public void endNode(RunResultInfo info) throws FinderException, NamingException {
        m_log.debug("endNode() start: sessionId=" + info.getSessionId() + ", facilityId=" + info.getFacilityId());
        
        //åID饻å(¹)
        CRunSessionLocal session = 
            CRunSessionUtil.getLocalHome().findByPrimaryKey(info.getSessionId());
        
        //ޥɥץå
        if(info.getCommandType() == com.clustercontrol.jobmanagement.bean.CommandTypeConstant.NORMAL){
            //ޥɥפ̾ξ
            
            //åǥơ(¹ܺ)
            CRunSessionDetailLocal sessionDetail = 
                CRunSessionDetailUtil.getLocalHome().findByPrimaryKey(
                        new CRunSessionDetailPK(info.getSessionId(), info.getFacilityId()));
            
            //ơʬ
            if(info.getStatus() == RunStatusConstant.START){
                //Ϥξ
                
                if(sessionDetail.getStart_date() == null){
                    //ơ¹ˤ
                    sessionDetail.setStatus(new Integer(CollectiveRunStatusConstant.TYPE_RUNNING));
                    
                    //
                    sessionDetail.setStart_date(info.getTime());
                    
                    //¹Ρɿ򥤥
                    session.setRunning_cnt(new Integer(session.getRunning_cnt().intValue() + 1));
                    //ԵΡɿǥ
                    session.setWait_cnt(new Integer(session.getWait_cnt().intValue() - 1));
                }
                else{
                    AplLogger apllog = new AplLogger("CR","cr");
                    String[] args = {info.getSessionId(), info.getFacilityId()};
                    apllog.put("SYS","004", args);
                    m_log.debug("endNode() : Ѥߤμ¹Գϥåޤ å˴ޤ" + 
                            " SessionId=" + info.getSessionId() + 
                            ", FacilityId=" + info.getFacilityId());
                }
                sessionDetail = null;
            }
            else{
                //¹Ρɿǥ
                session.setRunning_cnt(new Integer(session.getRunning_cnt().intValue() - 1));

	            if(info.getStatus() == RunStatusConstant.END){
	                //λξ
	                
	                //ơ¹ξ
	                if(sessionDetail.getStatus().intValue() == CollectiveRunStatusConstant.TYPE_RUNNING){
	                    //ơ˽λ
	                    sessionDetail.setStatus(new Integer(CollectiveRunStatusConstant.TYPE_END));
	                    //λ
	                    sessionDetail.setEnd_date(info.getTime());
	                    //λͤ
	                    sessionDetail.setEnd_value(new Integer(info.getEndValue()));
	                    //å
	                    sessionDetail.setMessage(info.getMessage());
	                    //顼å
	                    sessionDetail.setError_message(info.getErrorMessage());
	                    
	                    //λ֤
	                    setEndStatus(session, sessionDetail);
	                }
	            }
	            else if(info.getStatus() == RunStatusConstant.ERROR){
	                //Ԥξ
	                
	                //ơ¹ξ
	                if(sessionDetail.getStatus().intValue() == CollectiveRunStatusConstant.TYPE_RUNNING){
	                    //ơ˽λ
	                    sessionDetail.setStatus(new Integer(CollectiveRunStatusConstant.TYPE_ERROR));
	                    //å
	                    sessionDetail.setMessage(info.getMessage());
	                    //顼å
	                    sessionDetail.setError_message(info.getErrorMessage());
	                    
	                    //ԥΡɿ򥤥
	                    session.setEnd_abnomal_cnt(new Integer(session.getEnd_abnomal_cnt().intValue() + 1));
	                }
	            }
	            sessionDetail = null;
	            
	            
	            //λå
	            if(checkAllNodeEnd(session)){
	                //Ρɽλξ
	                
	                //ơ¹ξ
	                if(session.getStatus().intValue() == CollectiveRunStatusConstant.TYPE_RUNNING){
	                    //ơ˽λ
	                    session.setStatus(new Integer(CollectiveRunStatusConstant.TYPE_END));
	                    //λ
	                    session.setEnd_date(info.getTime());
	                }
	            }
            }
        }
        
        m_log.debug("endNode() end: sessionId=" + info.getSessionId() + ", facilityId=" + info.getFacilityId());
    }
    
    /**
     * Ρɿ
     * 
     * @param sessionId
     * @param facilityId
     * @throws FinderException
     * @throws NamingException
     */
    protected void setNodeCount(CRunSessionLocal session) throws FinderException, NamingException{
        m_log.debug("setNodeCount() : sessionId=" + session.getSession_id());

        int normal = 0;
        int warning = 0;
        int abnormal = 0;
        int running = 0;
        int waiting = 0;
        
    	//åǥơ(¹ܺ)
    	Collection collection = session.getSessionDetail();
    	if(collection != null && collection.size() > 0){
    		Iterator itr = collection.iterator();
    		while(itr.hasNext()){
    			CRunSessionDetailLocal sessionDetail = (CRunSessionDetailLocal)itr.next();
    			
    			//ơå
    			if(sessionDetail.getStatus().intValue() == CollectiveRunStatusConstant.TYPE_RUNNING){
					//¹
    				running++;
				}
				else if(sessionDetail.getStatus().intValue() == CollectiveRunStatusConstant.TYPE_WAITING){
					//Ե
					waiting++;
				}
				else if(sessionDetail.getStatus().intValue() == CollectiveRunStatusConstant.TYPE_ERROR){
					//¹Լ
					abnormal++;
				}
    			
    			//λ֤å
    			if(sessionDetail.getEnd_status() != null){
	    			if(sessionDetail.getEnd_status().intValue() == EndStatusConstant.TYPE_NORMAL){
						//¹
	    				normal++;
					}
					else if(sessionDetail.getEnd_status().intValue() == EndStatusConstant.TYPE_WARNING){
						//Ե
						warning++;
					}
					else if(sessionDetail.getEnd_status().intValue() == EndStatusConstant.TYPE_ABNORMAL){
						//¹Լ
						abnormal++;
					}
    			}
    		}
    	}

        //¹ο
        session.setRunning_cnt(new Integer(running));
        //Եο
        session.setWait_cnt(new Integer(waiting));
        //ο
        session.setEnd_nomal_cnt(new Integer(normal));
        //ٹο
        session.setEnd_warning_cnt(new Integer(warning));
        //۾ο
        session.setEnd_abnomal_cnt(new Integer(abnormal));
    }
    
    /**
     * λ
     * 
     * @param sessionId
     * @param facilityId
     * @throws FinderException
     * @throws NamingException
     */
    protected void setEndStatus(CRunSessionLocal session, CRunSessionDetailLocal sessionDetail) throws FinderException, NamingException{
        m_log.debug("setEndStatus() : sessionId=" + session.getSession_id() + ", facilityId=" + sessionDetail.getFacility_id());
        
        //λ֡ˤ
        CRunEndMstLocal endInfoNormal = null;
        try {
            endInfoNormal = CRunEndMstUtil.getLocalHome().findByPrimaryKey(
                    new CRunEndMstPK(session.getCommand_id(), new Integer(EndStatusConstant.TYPE_NORMAL)));
        } catch (FinderException e) {
            m_log.debug("setEndStatus() : EndMst normal find error" + e.getMessage());
        }
        //λ֡ʷٹˤ
        CRunEndMstLocal endInfoWarning = null;
        try {
            endInfoWarning = CRunEndMstUtil.getLocalHome().findByPrimaryKey(
                    new CRunEndMstPK(session.getCommand_id(), new Integer(EndStatusConstant.TYPE_WARNING)));
        } catch (FinderException e) {
            m_log.debug("setEndStatus() : EndMst warning find error" + e.getMessage());
        }
        
        Integer endValue = sessionDetail.getEnd_value();
        if(endValue instanceof Integer){
            if(endInfoNormal != null && 
                    endValue.compareTo(endInfoNormal.getEnd_value_from()) >= 0 && 
                    endValue.compareTo(endInfoNormal.getEnd_value_to()) <= 0){
                //λ֡ˤϰʤСȤ
                sessionDetail.setEnd_status(new Integer(EndStatusConstant.TYPE_NORMAL));
                //Ρɿ򥤥
                session.setEnd_nomal_cnt(new Integer(session.getEnd_nomal_cnt().intValue() + 1));
           }
            else if(endInfoWarning != null && 
                    endValue.compareTo(endInfoWarning.getEnd_value_from()) >= 0 && 
                    endValue.compareTo(endInfoWarning.getEnd_value_to()) <= 0){
                //λ֡ʷٹˤϰʤСٹȤ
                sessionDetail.setEnd_status(new Integer(EndStatusConstant.TYPE_WARNING));
                //ٹΡɿ򥤥
                session.setEnd_warning_cnt(new Integer(session.getEnd_warning_cnt().intValue() + 1));
            }
            else{
                //λ֡ʰ۾ˤϰʤС۾Ȥ
                sessionDetail.setEnd_status(new Integer(EndStatusConstant.TYPE_ABNORMAL));
                //ԥΡɿ򥤥
                session.setEnd_abnomal_cnt(new Integer(session.getEnd_abnomal_cnt().intValue() + 1));
            }
        }
    }
    
    /**
     * Ρɽλå
     * 
     * @param session
     * @return
     * @throws FinderException
     * @throws NamingException
     */
    protected boolean checkAllNodeEnd(CRunSessionLocal session) throws FinderException, NamingException{
        m_log.debug("checkAllNodeEnd() start: sessionId=" + session.getSession_id());

        //λե饰falseˤ
        boolean end = false;
        
        //ơ¹ޤԵ椬¸ߤ뤫å
        boolean runNode = false;
        if(session.getRunning_cnt().intValue() > 0 || session.getWait_cnt().intValue() > 0){
            runNode = true;
        }
        
        //Ρɽλξ
        if(!runNode){
            //λե饰trueˤ
            end = true;
        }
        
        m_log.debug("checkAllNodeEnd() end: sessionId=" + session.getSession_id());
        return end;
    }
    
    /**
     * ޥɼ
     * 
     * @param sessionId
     * @return
     * @throws FinderException
     * @throws NamingException
     * @throws IOException
     */
    public String getCommand(CRunSessionLocal session) throws FinderException, NamingException, IOException {
        m_log.debug("getCommand() : sessionId=" + session.getSession_id());
        
        String command = null;
		
        //ޥID饳ޥɥޥ
        CRunCmdMstLocal cmd = CRunCmdMstUtil.getLocalHome().findByPrimaryKey(session.getCommand_id());
        
        //------------------------------
        //ޥɤΰ
        //------------------------------
        StringBuffer argument = new StringBuffer();
        //ޥɥޥ饳ޥɥѥ᡼
        Collection cmdPramList = cmd.getCmdParamMst();
        if(cmdPramList != null && cmdPramList.size() > 0){
            Iterator itr = cmdPramList.iterator();
            while(itr.hasNext()){
                //ޥɥѥ᡼
                CRunCmdParamMstLocal cmdParam = (CRunCmdParamMstLocal)itr.next();
                //åѥ᡼(¹ѥ᡼)
                CRunSessionParamLocal sessionParam = 
                    CRunSessionParamUtil.getLocalHome().findByPrimaryKey(
                            new CRunSessionParamPK(session.getSession_id(), cmdParam.getParam_id()));
                
                if(sessionParam.getParam_value() != null && 
                        sessionParam.getParam_value().length() > 0){
                    if(cmdParam.getParam_prefix() != null && 
                            cmdParam.getParam_prefix().length() > 0){
                        //Prefixnullޤ϶ʸξ硢Prefixդʤ
                        argument.append(cmdParam.getParam_prefix());
                		argument.append(" ");
                    }
                    //ѥ᡼ͤnullޤ϶ʸξ硢ѥ᡼ͤϤĤʤ
                	argument.append(sessionParam.getParam_value());
                	argument.append(" ");
                }
            }
        }
        
        if(cmd.getCommand_type().intValue() == CommandTypeConstant.TYPE_SHELL){
            //ޥɥפξ硢եƤ'set - 'Ȱɲä
            command = "set - " + argument.toString() + "\n" + readShellFile(cmd.getCommand());
        }
        else{
            //ޥɥפξ硢ޥɤθ˰ɲä
            command = cmd.getCommand() + " " + argument.toString();
        }
        
        m_log.debug("getCommand() : command=" + command);
        return command;
    }
    
    /**
     * եɤ߹߽
     * 
     * @param fileName
     * @return եʸ
     * @throws IOException
     */
    public String readShellFile(String fileName) throws IOException {
        m_log.debug("readShellFile() : fileName=" + fileName);
        
        StringBuffer filePath = new StringBuffer();
        filePath.append(fileName);
        
        FileInputStream fileInputStream = null;
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader=null;
        String lineData;
        StringBuffer fileData = new StringBuffer();
        try {
            fileInputStream = new FileInputStream(filePath.toString());
            inputStreamReader = new InputStreamReader(fileInputStream);
            bufferedReader = new BufferedReader(inputStreamReader);
            //Ԥɤ߹ޤǷ֤
            while ((lineData = bufferedReader.readLine())!=null){
                fileData.append(lineData);
                //ԥɤɲ
                fileData.append("\n");
            }
        } catch (FileNotFoundException e) {
            AplLogger apllog = new AplLogger("CR","cr");
            String[] args = {fileName};
            apllog.put("SYS","005", args);
            m_log.debug("readShellFile() : 륹ץȥե뤬Ĥޤ : " + e.getMessage());
            throw e;
        } catch (IOException e) {
            AplLogger apllog = new AplLogger("CR","cr");
            String[] args = {fileName};
            apllog.put("SYS","006", args);
            m_log.debug("readShellFile() : 륹ץȥեɤ߹ߥ顼 : " + e.getMessage());
            throw e;
        } finally {
            try{
                if(bufferedReader!=null){
                    bufferedReader.close();
                }
                if(inputStreamReader!=null){
                    inputStreamReader.close();
                }
                if(fileInputStream!=null){
                    fileInputStream.close();
                }
            }catch(IOException e){
            }
        }
        
        return fileData.toString();
    }
    
    /**
     * ¹ǡ
     * 
     * @param job
     * @param parentJob
     * @param sessionId
     * @throws CreateException
     * @throws FinderException
     * @throws NamingException
     */
    @SuppressWarnings("unchecked")
	public String createSession(String typeId, Property property, Locale locale) throws CreateException, FinderException, NamingException {
        m_log.debug("createSession() : typeId=" + typeId);
        
        //ݥȥꥻåBean
        RepositoryControllerLocal repository = RepositoryControllerUtil.getLocalHome().create();
        
        ArrayList values = null;
        //եƥIDʥס˼
        values = PropertyUtil.getPropertyValue(property, ParameterProperty.SCOPE);
        String facilityId = null;
        if(values.get(0) instanceof FacilityTreeItem){
            facilityId = ((FacilityTreeItem)values.get(0)).getData().getFacilityId();
        }
        else if(values.get(0) instanceof String && ((String)values.get(0)).length() > 0){
            facilityId = (String)values.get(0);
        }
        //̾
        values = PropertyUtil.getPropertyValue(property, ParameterProperty.NAME);
        String commandId = null;
        if(values.get(0) instanceof String && ((String)values.get(0)).length() > 0){
            String nameString = (String)values.get(0);
            //̾饳ޥID
            commandId = getCommandId(typeId, nameString, locale);
        }
        
        //ޥID饳ޥɥޥ
        CRunCmdMstLocal cmd = CRunCmdMstUtil.getLocalHome().findByPrimaryKey(commandId);
        
        //å
        boolean createFlg = false;
        String sessionId = null;
        Date createTime = new Date();
        CRunSessionLocal session = null;
        for(int i = 0; !createFlg; i++){
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
                sessionId = dateFormat.format(createTime);
                
        		DecimalFormat format = new DecimalFormat("-000");
        		sessionId = sessionId + format.format(i);
        			
                //å(¹)
                session = 
                    CRunSessionUtil.getLocalHome().create(
                            sessionId, 
                            null, 
                            null, 
                            cmd.getType_id(), 
                            cmd.getCommand_id(), 
                            facilityId, 
                            repository.getFacilityPath(facilityId, null), 
                            new Integer(0), 
                            new Integer(0), 
                            new Integer(0), 
                            new Integer(0), 
                            new Integer(0), 
                            new Integer(0), 
                            new Integer(CollectiveRunStatusConstant.TYPE_WAITING));
                
                createFlg = true;
            } catch (DuplicateKeyException e) {
                //ץ饤ޥ꡼ʣ
                //٥å(¹)κԤ
            }
        }

        //оݥեƥID饻åǥơ(¹ܺ)
        ArrayList nodeIdList = null;
        if(repository.isNode(session.getFacility_id())){
            nodeIdList = new ArrayList();
            nodeIdList.add(session.getFacility_id());
        }
        else{
            nodeIdList = repository.getNodeFacilityIdList(session.getFacility_id(), RepositoryControllerBean.ALL);
        }
        if(nodeIdList instanceof ArrayList){
            for(int i = 0; i < nodeIdList.size(); i++){
                ArrayList Attribute = new ArrayList();
                Attribute.add(FacilityAttributeConstant.CN);
                HashMap map = repository.getNodeDetail((String)nodeIdList.get(i), Attribute);
                
                //åǥơ(¹ܺ)
                CRunSessionDetailUtil.getLocalHome().create(
                        sessionId, 
                        (String)nodeIdList.get(i), 
                        null, 
                        null, 
                        (String)map.get(FacilityAttributeConstant.CN), 
                        null, 
                        null, 
                        new Integer(CollectiveRunStatusConstant.TYPE_WAITING), 
                        null, 
                        null);
            }
            
            //Ρɿ
            session.setNode_cnt(new Integer(nodeIdList.size()));
            //ԵΡɿ
            session.setWait_cnt(new Integer(nodeIdList.size()));
        }
        
        //ޥɥޥ饳ޥɥѥ᡼
        Collection cmdPramList = cmd.getCmdParamMst();
        if(cmdPramList != null && cmdPramList.size() > 0){
            Iterator itr = cmdPramList.iterator();
            while(itr.hasNext()){
                //ޥɥѥ᡼
                CRunCmdParamMstLocal cmdParam = (CRunCmdParamMstLocal)itr.next();
                int paramType = cmdParam.getParamMst().getParam_type().intValue();
                
                //ѥ᡼ͼ
                values = PropertyUtil.getPropertyValue(property, cmdParam.getParam_id());
                String value = null;
                if(values.get(0) instanceof String && ((String)values.get(0)).length() > 0){
                    value = (String)values.get(0);
                }
                
                //ѥ᡼פξ硢ɽʸ󤫤ѥ᡼ͤ
                if(paramType == ParameterTypeConstant.TYPE_SELECT){
                    value = getParamSelectValue(cmdParam.getParam_id(), value, locale);
                }
                
                //åѥ᡼(¹ѥ᡼)
                CRunSessionParamUtil.getLocalHome().create(
                        sessionId, 
                        cmdParam.getParam_id(), 
                        value);
            }
        }
        
        return sessionId;
    }
    
    /**
     * ޥID
     * 
     * ɽʸ󤫤饳ޥID
     * 
     * @param typeId ID
     * @param name ɽʸ
     * @param locale 
     * @return ޥID
     * @throws FinderException
     * @throws NamingException
     */
    protected String getCommandId(String typeId, String name, Locale locale) throws FinderException, NamingException {
        m_log.debug("getCommandId() : typeId=" + typeId + ", name=" + name);
        
        String commandId = null;
        
        //ID饳ޥɥޥ
        Collection cmdList = CRunCmdMstUtil.getLocalHome().findByTypeId(typeId);
        
        if(cmdList != null && cmdList.size() > 0){
            Iterator itr = cmdList.iterator();
            while(itr.hasNext()){
                //ޥɥޥ
                CRunCmdMstLocal cmd = (CRunCmdMstLocal)itr.next();
                //ɽID꥽
                String nameValue = Messages.getString(cmd.getName_id(), locale);
                //꥽פ饳ޥID֤
                if(nameValue.equals(name)){
                    commandId = cmd.getCommand_id();
                    break;
                }
            }
        }
        
        return commandId;
    }
    
    /**
     * ѥ᡼ͼ
     * 
     * ɽʸ󤫤ѥ᡼ͤ
     * 
     * @param paramId ѥ᡼ID
     * @param name ɽʸ
     * @param locale 
     * @return ѥ᡼
     * @throws FinderException
     * @throws NamingException
     */
    protected String getParamSelectValue(String paramId, String name, Locale locale) throws FinderException, NamingException {
        m_log.debug("getParamSelectValue() : paramId=" + paramId + ", name=" + name);
        
        String value = null;
        
        //ѥ᡼IDѥ᡼ޥ
        Collection paramSelectList = CRunParamSelectMstUtil.getLocalHome().findByParamId(paramId);
        
        if(paramSelectList != null && paramSelectList.size() > 0){
            Iterator itr = paramSelectList.iterator();
            while(itr.hasNext()){
                //ѥ᡼ޥ
                CRunParamSelectMstLocal paramSelect = (CRunParamSelectMstLocal)itr.next();
                //ɽID꥽
                String nameValue = Messages.getString(paramSelect.getName_id(), locale);
                //꥽פ饳ޥID֤
                if(nameValue.equals(name)){
                    value = paramSelect.getParam_value();
                    break;
                }
            }
        }
        
        return value;
    }
    
    /**
     * ѥ᡼ͼ
     * 
     * ɽʸ󤫤ѥ᡼ͤ
     * 
     * @param paramId ѥ᡼ID
     * @param name ɽʸ
     * @param locale 
     * @return ѥ᡼
     * @throws FinderException
     * @throws NamingException
     */
    public void checkEndSession() throws FinderException, NamingException {
    	m_log.debug("checkEndSession()");
    	
    	//¹Υå
    	Collection collection = 
    		CRunSessionUtil.getLocalHome().findByStatus(new Integer(CollectiveRunStatusConstant.TYPE_RUNNING));
    	
    	if(collection != null && collection.size() > 0){
    		Iterator itr = collection.iterator();
    		while(itr.hasNext()){
    			CRunSessionLocal session = (CRunSessionLocal)itr.next();
    			
    			//Ρɿ
    			setNodeCount(session);
    			
    			//λå
    			if(checkAllNodeEnd(session)){
    				//Ρɽλξ
    				
    				//ơ¹ξ
    				if(session.getStatus().intValue() == CollectiveRunStatusConstant.TYPE_RUNNING){
    					//ơ˽λ
    					session.setStatus(new Integer(CollectiveRunStatusConstant.TYPE_END));
    					//λ
    					session.setEnd_date(new Date());
    				}
    			}
    		}
    	}
    }
}
