/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.collectiverun.factory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.FacilityInfo;
import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyConstant;
import com.clustercontrol.collectiverun.bean.ParameterTypeConstant;
import com.clustercontrol.collectiverun.ejb.entity.CRunCmdMstLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunCmdMstUtil;
import com.clustercontrol.collectiverun.ejb.entity.CRunCmdParamMstLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunCmdParamMstUtil;
import com.clustercontrol.collectiverun.ejb.entity.CRunParamMstLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunParamMstUtil;
import com.clustercontrol.collectiverun.ejb.entity.CRunParamSelectMstLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunParamSelectMstUtil;
import com.clustercontrol.collectiverun.ejb.entity.CRunSessionLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunSessionParamLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunSessionUtil;
import com.clustercontrol.collectiverun.ejb.entity.CRunTypeMstLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunTypeMstUtil;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;

/**
 * ѥ᡼ѥץѥƥ饹
 *
 * @version 2.1.0
 * @since 1.0.0
 */
public class ParameterProperty {
    protected static Log m_log = LogFactory.getLog( ParameterProperty.class );
    
    /**  */
    public static final String SCOPE = "scope";
    /** ̾ */
    public static final String NAME = "name";
    
	/**
	 * ID
	 * 
	 * åIDID
	 * 
	 * @param sessionId
	 * @return
	 */
	public String getTypeId(String sessionId) {
		try {
            //åID饻å(¹)
            CRunSessionLocal session = 
                CRunSessionUtil.getLocalHome().findByPrimaryKey(sessionId);
            
            //ޥID饳ޥɥޥ
            CRunCmdMstLocal cmd = 
                CRunCmdMstUtil.getLocalHome().findByPrimaryKey(session.getCommand_id());
            
            return cmd.getType_id();
        } catch (Exception e) {
            m_log.debug("getType() : åID̤ǤޤǤ : " + e.getMessage());
        }

	    return null;
	}
	
	/**
	 * ץѥƥ֤ޤ
	 * 
	 * @param local
	 * @return ץѥƥ
	 */
	public Property getPropertyBySessionId(String sessionId, Locale locale) {
	    Property property = null;
	    
		try {
            //åID饻å(¹)
            CRunSessionLocal session = 
                CRunSessionUtil.getLocalHome().findByPrimaryKey(sessionId);
            
            //ޥID饳ޥɥޥ
            CRunCmdMstLocal cmd = 
                CRunCmdMstUtil.getLocalHome().findByPrimaryKey(session.getCommand_id());
            
            //IDץѥƥ
            property = getParameterProperty(cmd.getType_id(), locale);
            if(property instanceof Property){
                
                //̾ץѥƥλҥץѥƥڤؤ
                selectNameProperty(property, 
                        Messages.getString(cmd.getName_id(), locale), locale);
                
                //ѥ᡼ץѥƥͤꤹ
                setPropertyValue(property, session, locale);
            }
            else{
                
            }
        } catch (Exception e) {
            m_log.debug("getProperty() : ץѥƥǤޤǤ sessionId=" + sessionId + " : " + e.getMessage());
        }

	    return property;
	}
	
	/**
	 * ץѥƥ֤ޤ
	 * 
	 * @param local
	 * @return ץѥƥ
	 */
	public Property getProperty(String typeId, Locale locale) {
	    try {
		    return getParameterProperty(typeId, locale);
        } catch (Exception e) {
            
            m_log.debug("getProperty() : ץѥƥǤޤǤ typeId=" + typeId + " : " + e.getMessage());
        }
	    return null;
	}

	/**
	 * ޥɥѥ᡼ѥץѥƥ
	 * 
	 * @param cmdParam
	 * @return ޥɥѥ᡼ѥץѥƥ
	 * @throws FinderException
	 * @throws NamingException
	 */
	public Property getCommandParameterProperty(CRunCmdParamMstLocal cmdParam, Locale locale) throws FinderException, NamingException {
	    Property parameter = null;
	    
	    if(cmdParam != null){
		    //ޥɤɳŤޥɥѥ᡼
		    CRunParamMstLocal param = cmdParam.getParamMst();
		    int paramType = param.getParam_type().intValue();
		    
		    //ѥ᡼ѥץѥƥ
		    parameter = 
		        new Property(param.getParam_id(), Messages.getString(param.getName_id(), locale), ParameterTypeConstant.paramTypeToEditor(paramType));
		    parameter.setModify(PropertyConstant.MODIFY_OK);
		    
		    //ͤν
		    parameter.setValue("");
		    if(paramType == ParameterTypeConstant.TYPE_SELECT){
		        Collection paramSelectList = param.getParamSelectMst();
		        
			    if(paramSelectList != null && paramSelectList.size() > 0){
					//ͤ
			        Object selectValues[][] = {new Object[paramSelectList.size()], new Object[paramSelectList.size()]};
					
				    Iterator itr = paramSelectList.iterator();
					while(itr.hasNext()){
					    CRunParamSelectMstLocal paramSelect = (CRunParamSelectMstLocal)itr.next();
					    int index = paramSelect.getOrder_no().intValue();
					
					    selectValues[PropertyConstant.SELECT_VALUE][index] = Messages.getString(paramSelect.getName_id(), locale);
					    selectValues[PropertyConstant.SELECT_DISP_TEXT][index] = Messages.getString(paramSelect.getName_id(), locale);
					}
					
					parameter.setSelectValues(selectValues);
					parameter.setValue(selectValues[PropertyConstant.SELECT_DISP_TEXT][0]);
			    }
		    }
	    }

	    return parameter;
	}
	
	/**
	 * ѥ᡼ѥץѥƥ֤ޤ
	 * 
	 * @param typeId
	 * @param locale
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	@SuppressWarnings("unchecked")
	public Property getParameterProperty(String typeId, Locale locale) throws FinderException, NamingException {
	    //
		Property scope =
			new Property(SCOPE, Messages.getString("scope", locale), PropertyConstant.EDITOR_FACILITY);
		scope.setModify(PropertyConstant.MODIFY_OK);
		//̾
		Property name =
			new Property(NAME, Messages.getString("name", locale), PropertyConstant.EDITOR_SELECT);
		name.setModify(PropertyConstant.MODIFY_OK);
		
	    //̤
	    CRunTypeMstLocal type = 
	        CRunTypeMstUtil.getLocalHome().findByPrimaryKey(typeId);
	    
	    //ޥɥѥ᡼ѤΥץѥƥǼHashMap
	    HashMap propertyMap = new HashMap();
	    
	    //̤ɳŤޥɥޥ
	    Collection cmdList = type.getCmdMst();
	    if(cmdList != null && cmdList.size() > 0){
			//ͤ
			Object nameValues[][] = {new Object[cmdList.size()], new Object[cmdList.size()]};
		    Iterator itr = cmdList.iterator();
			while(itr.hasNext()){
			    
			    //ޥɥޥ
			    CRunCmdMstLocal cmd = (CRunCmdMstLocal)itr.next();
			    int index = cmd.getOrder_no().intValue();

			    ArrayList list = new ArrayList();
			    //ޥɤɳŤޥɥѥ᡼
			    Collection cmdParamList = 
			        CRunCmdParamMstUtil.getLocalHome().findByCommandId(cmd.getCommand_id());
			    if(cmdParamList != null && cmdParamList.size() > 0){
			        Iterator itr2 = cmdParamList.iterator();
					while(itr2.hasNext()){
					    //ޥɥѥ᡼
					    CRunCmdParamMstLocal cmdParam = (CRunCmdParamMstLocal)itr2.next();
					    //ޥɥѥ᡼ѥץѥƥ
					    Property parameter = getCommandParameterProperty(cmdParam, locale);
					    
					    //˥ޥɥѥ᡼ѥץѥƥǼѤߤå
					    if(propertyMap.get(cmdParam.getParam_id()) == null){
					        //̤Ǽξ
					        list.add(parameter);
					        propertyMap.put(cmdParam.getParam_id(), parameter);
					    }
					    else{
					        //ǼѤ
					        list.add(propertyMap.get(cmdParam.getParam_id()));
					    }
					}
			    }
			    
			    nameValues[PropertyConstant.SELECT_DISP_TEXT][index] = Messages.getString(cmd.getName_id(), locale);
			    HashMap map = new HashMap();
			    map.put(PropertyConstant.MAP_VALUE, Messages.getString(cmd.getName_id(), locale));
			    map.put(PropertyConstant.MAP_PROPERTY, list);
			    nameValues[PropertyConstant.SELECT_VALUE][index] = map;
			}
			
			name.setSelectValues(nameValues);
			name.setValue(nameValues[PropertyConstant.SELECT_VALUE][0]);
	    }

		Property property = new Property(null, null, "");
		
		// ɽĥ꡼
		property.removeChildren();
		property.addChildren(scope);
		property.addChildren(name);
		
		//̾ץѥƥλҥץѥƥ
		Object nameValues[][] = name.getSelectValues();
		selectNameProperty(property, 
		        (String)nameValues[PropertyConstant.SELECT_DISP_TEXT][0], 
		        locale);
		
		return property;
	}
	
	/**
	 * ̾ѥ᡼ؽ
	 * 
	 * ɽʸˤ̾ѥ᡼λҥץѥƥؤ롣
	 * 
	 * @param property
	 * @param dispText
	 * @param locale
	 */
	public void selectNameProperty(Property property, String dispText, Locale locale) {
	    int index = 0;
	    
	    //̾ץѥƥ
		Property name = null;
		ArrayList properties = null;
		properties = PropertyUtil.getProperty(property, NAME);
		if(properties instanceof ArrayList){
		    name = (Property)properties.get(0);
		}
		
		if(name instanceof Property){
		    Object nameValues[][] = name.getSelectValues();
		    
		    if(dispText != null){
	            for(int i = 0; i < nameValues[PropertyConstant.SELECT_DISP_TEXT].length; i++){
	                if(dispText.compareTo((String)nameValues[PropertyConstant.SELECT_DISP_TEXT][i]) == 0){
	                    index = i;
	                    break;
	                }
	            }
		    }
            
    	    if(nameValues[PropertyConstant.SELECT_VALUE][index] instanceof HashMap){
    			HashMap map = (HashMap)nameValues[PropertyConstant.SELECT_VALUE][index];
    			name.setValue(map.get(PropertyConstant.MAP_VALUE));
    			
    			ArrayList propertyList = (ArrayList)map.get(PropertyConstant.MAP_PROPERTY);
    			if(propertyList instanceof ArrayList){
    			    name.removeChildren();
    				for(int i = 0; i < propertyList.size(); i++){
    				    name.addChildren((Property)propertyList.get(i));
    				}
    			}
    	    }
    		else{
    		    name.removeChildren();
    		    Object select = nameValues[PropertyConstant.SELECT_VALUE][index];
    		    name.setValue(select);
    		}
		}
	}
	
	/**
	 * ץѥƥ
	 * 
	 * @param property
	 * @param sessionId
	 * @param locale
	 */
	public void setPropertyValue(Property property, CRunSessionLocal session, Locale locale) {
	    //ѥ᡼IDץѥƥ
	    ArrayList properties = 
	        PropertyUtil.getProperty(property, SCOPE);
	    ((Property)properties.get(0)).setValue("");
	    
	    //פ
        try {
            FacilityTreeItem item = null;
            FacilityInfo info = new FacilityInfo();
            info.setFacilityId(session.getFacility_id());
            info.setFacilityName(session.getScope_text());
            item = new FacilityTreeItem(null, info);

    		((Property)properties.get(0)).setValue(item);
    		
        } catch (Exception e) {
            m_log.debug("setPropertyValue() : եƥ顼 FacilityId=" + session.getFacility_id() + " : " + e.getMessage());
        }

	    //å(¹)饻åѥ᡼(¹ѥ᡼)
	    Collection collection = session.getSessionParam();
	    
	    if(collection != null && collection.size() > 0){
			Iterator itr = collection.iterator();
			while(itr.hasNext()){
			    //åѥ᡼(¹ѥ᡼)
			    CRunSessionParamLocal sessionParam = (CRunSessionParamLocal)itr.next();
			    
			    //ѥ᡼IDץѥƥ
			    properties = 
			        PropertyUtil.getProperty(property, sessionParam.getParam_id());
			    
			    ((Property)properties.get(0)).setValue("");
			    
			    try {
                    CRunParamMstLocal param = 
                        CRunParamMstUtil.getLocalHome().findByPrimaryKey(sessionParam.getParam_id());
                    
    			    if(sessionParam.getParam_value() != null){
    			        if(param.getParam_type().intValue() == ParameterTypeConstant.TYPE_SELECT){
    			            ((Property)properties.get(0)).setValue(
    			                    getParamValue(sessionParam.getParam_id(), sessionParam.getParam_value(), locale));
    			        }
    			        else{
    			            ((Property)properties.get(0)).setValue(sessionParam.getParam_value());
    			        }
    			    }
                } catch (Exception e) {
                    m_log.debug("setPropertyValue() : ѥ᡼顼 ParamId=" + sessionParam.getParam_id() + " : " + e.getMessage());
                }
			}
	    }
	}
	
	/**
	 * FacilityTreeItemμ
	 * 
	 * @param item
	 * @param facilityId
	 * @return
	 */
	public static ArrayList getFacilityTreeItem(FacilityTreeItem item, String facilityId) {
		ArrayList list = new ArrayList();
		
		getFacilityTreeItem(item, facilityId, list);
		
		return list;
	}
	
	/**
	 * FacilityTreeItemμʺƵƤӽФ
	 * 
	 * @param item
	 * @param facilityId
	 * @param list
	 */
	@SuppressWarnings("unchecked")
	public static void getFacilityTreeItem(FacilityTreeItem item, String facilityId, ArrayList list) {
		
		//եƥIDפFacilityTreeItemꥹȤɲ
		if(facilityId != null && item.getData().getFacilityId() != null){
			if(facilityId.compareTo(item.getData().getFacilityId()) == 0){
				list.add(item);
			}
		}

		//FacilityTreeItem
		Object[] childrens = item.getChildren();
		
		for(int i = 0; i < childrens.length; i++){
		    FacilityTreeItem children1 = (FacilityTreeItem)childrens[i];
			getFacilityTreeItem(children1, facilityId, list);
		}
	}
	
    /**
     * ѥ᡼ɽʸ
     * 
     * @param paramId ѥ᡼ID
     * @param value ѥ᡼
     * @param locale 
     * @return ɽʸ
     * @throws FinderException
     * @throws NamingException
     */
    protected String getParamValue(String paramId, String value, Locale locale) throws FinderException, NamingException {
        m_log.debug("getParamValue() : paramId=" + paramId + ", value=" + value);
        
        String name = null;
        
        //ѥ᡼IDѥ᡼ޥ
        Collection paramSelectList = CRunParamSelectMstUtil.getLocalHome().findByParamId(paramId);
        
        if(paramSelectList != null && paramSelectList.size() > 0){
            Iterator itr = paramSelectList.iterator();
            while(itr.hasNext()){
                //ѥ᡼ޥ
                CRunParamSelectMstLocal paramSelect = (CRunParamSelectMstLocal)itr.next();
                
                //ͤפɽʸ֤
                if(paramSelect.getParam_value().equals(value)){
                    name = Messages.getString(paramSelect.getName_id(), locale);
                    break;
                }
            }
        }
        
        return name;
    }
}
