/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.collectiverun.factory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;

import javax.ejb.FinderException;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.StatusConstant;
import com.clustercontrol.collectiverun.bean.HistoryFilterPropertyConstant;
import com.clustercontrol.collectiverun.ejb.entity.CRunCmdMstLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunCmdMstUtil;
import com.clustercontrol.collectiverun.ejb.entity.CRunSessionDetailLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunSessionDetailUtil;
import com.clustercontrol.collectiverun.ejb.entity.CRunSessionLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunSessionUtil;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;

/**
 * 򸡺饹
 *
 * @version 1.0.0
 * @since 1.0.0
 */
public class SelectSession {
    protected static Log m_log = LogFactory.getLog( SelectSession.class );

	private int m_historyMaxDisplayNumber = -1;
	
	public SelectSession(){
		try
		{
			InitialContext initialContext = new InitialContext();
			if(initialContext.lookup("java:comp/env/CRunHistoryDisplayNumber") instanceof Integer){
			    m_historyMaxDisplayNumber = ((Integer)initialContext.lookup("java:comp/env/CRunHistoryDisplayNumber")).intValue();
			}
		}
		catch(NamingException e){
			m_log.error("SelectSession():" + e.getMessage());
		}
	}
	
	/**
	 * 
	 * 
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	@SuppressWarnings("unchecked")
	public ArrayList getHistoryList(Locale locale) throws FinderException, NamingException {
	    ArrayList history = new ArrayList();
	    
	    //å
	    Collection sessionList = CRunSessionUtil.getLocalHome().findAll();
	    if(sessionList != null){
	        
			// 򤬺ɽ礭硢顼ȯ
			if(m_historyMaxDisplayNumber != -1 && sessionList.size() > m_historyMaxDisplayNumber){
				throw new java.lang.IndexOutOfBoundsException();
			}
			
	        Iterator itr = sessionList.iterator();
			while(itr.hasNext()){
			    //å
			    CRunSessionLocal session = (CRunSessionLocal)itr.next();
			    CRunCmdMstLocal cmd = null;
                try {
                    cmd = CRunCmdMstUtil.getLocalHome().findByPrimaryKey(session.getCommand_id());
                } catch (FinderException e) {
                    
                }
                
                //ΣԤ
			    ArrayList info = new ArrayList();
			    info.add(session.getStatus());
			    info.add(session.getSession_id());
			    info.add(session.getStart_date());
			    info.add(session.getEnd_date());
			    
			    String name = SelectMaster.typeIdToString(session.getType_id(), locale);
			    if(name != null){
			        info.add(name);
			    }
			    else{
			        info.add("");
			    }

			    if(cmd != null){
			        info.add(Messages.getString(cmd.getName_id(), locale));
			    }
			    else{
			        info.add("");
			    }
			    info.add(session.getFacility_id());
			    info.add(session.getScope_text());
			    info.add(session.getNode_cnt());
			    info.add(session.getEnd_nomal_cnt());
			    info.add(session.getEnd_warning_cnt());
			    info.add(session.getEnd_abnomal_cnt());
			    info.add(session.getWait_cnt());
			    info.add(session.getRunning_cnt());
			    history.add(info);
			}
	    }
	    return history;
	}
	
	/**
	 * 
	 * 
	 * @param property
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	@SuppressWarnings("unchecked")
	public ArrayList getHistoryList(Property property, Locale locale) throws FinderException, NamingException {
	    
		ArrayList values = null;
		//ϡƼ¹ʼ˼
		values = PropertyUtil.getPropertyValue(property, HistoryFilterPropertyConstant.START_FROM_DATE);
		Date startFromDate = null;
		if(values.get(0) != null && values.get(0) instanceof Date){
		    startFromDate = (Date)values.get(0);
		}
		//ϡƼ¹ʻ˼
		values = PropertyUtil.getPropertyValue(property, HistoryFilterPropertyConstant.START_TO_DATE);
		Date startToDate = null;
		if(values.get(0) != null && values.get(0) instanceof Date){
		    startToDate = (Date)values.get(0);
		}
		//λʼ˼
		values = PropertyUtil.getPropertyValue(property, HistoryFilterPropertyConstant.END_FROM_DATE);
		Date endFromDate = null;
		if(values.get(0) != null && values.get(0) instanceof Date){
		    endFromDate = (Date)values.get(0);
		}
		//λʻ˼
		values = PropertyUtil.getPropertyValue(property, HistoryFilterPropertyConstant.END_TO_DATE);
		Date endToDate = null;
		if(values.get(0) != null && values.get(0) instanceof Date){
		    endToDate = (Date)values.get(0);
		}

		//̼
		values = PropertyUtil.getPropertyValue(property, HistoryFilterPropertyConstant.TYPE);
		String type = null;
		if(values.get(0) instanceof String && ((String)values.get(0)).length() > 0){
		    String typeString = (String)values.get(0);
		    type = SelectMaster.stringToTypeId(typeString, locale);
		}
		//ּ
		values = PropertyUtil.getPropertyValue(property, HistoryFilterPropertyConstant.STATUS);
		Integer status = null;
		if(values.get(0) instanceof String){
		    String statusString = (String)values.get(0);
		    status = new Integer(StatusConstant.stringToType(statusString));
		}
		
	    ArrayList history = new ArrayList();
	    
	    //˳륻å
	    Collection sessionList = 
	        CRunSessionUtil.getLocalHome().selectHistoryFilter(
	                startFromDate, 
	                startToDate, 
	                endFromDate, 
	                endToDate, 
	                type, 
	                status);
	    
	    if(sessionList != null){
	        
			// 򤬺ɽ礭硢顼ȯ
			if(m_historyMaxDisplayNumber != -1 && sessionList.size() > m_historyMaxDisplayNumber){
				throw new java.lang.IndexOutOfBoundsException();
			}
			
	        Iterator itr = sessionList.iterator();
			while(itr.hasNext()){
			    //å
			    CRunSessionLocal session = (CRunSessionLocal)itr.next();
			    CRunCmdMstLocal cmd = null;
                try {
                    cmd = CRunCmdMstUtil.getLocalHome().findByPrimaryKey(session.getCommand_id());
                } catch (FinderException e) {
                    
                }
                
			    //ΣԤ
			    ArrayList info = new ArrayList();
			    info.add(session.getStatus());
			    info.add(session.getSession_id());
			    info.add(session.getStart_date());
			    info.add(session.getEnd_date());
			    
			    String name = SelectMaster.typeIdToString(session.getType_id(), locale);
			    if(name != null){
			        info.add(name);
			    }
			    else{
			        info.add("");
			    }
			    
			    if(cmd != null){
			        info.add(Messages.getString(cmd.getName_id(), locale));
			    }
			    else{
			        info.add("");
			    }
			    info.add(session.getFacility_id());
			    info.add(session.getScope_text());
			    info.add(session.getNode_cnt());
			    info.add(session.getEnd_nomal_cnt());
			    info.add(session.getEnd_warning_cnt());
			    info.add(session.getEnd_abnomal_cnt());
			    info.add(session.getWait_cnt());
			    info.add(session.getRunning_cnt());
			    history.add(info);
			}
	    }
	    return history;
	}
	
	/**
	 * ٰܺ
	 * 
	 * @param sessionId
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	@SuppressWarnings("unchecked")
	public ArrayList getDetailList(String sessionId, Locale locale) throws FinderException, NamingException {
	    ArrayList list = new ArrayList();
	    
	    //åǥơ򥻥åIDǸ
	    Collection detailList = CRunSessionDetailUtil.getLocalHome().findBySessionId(sessionId);
	    if(detailList != null){
	        Iterator itr = detailList.iterator();
			while(itr.hasNext()){
			    //åǥơ
			    CRunSessionDetailLocal detail = (CRunSessionDetailLocal)itr.next();
			    
			    //ΣԤ
			    ArrayList info = new ArrayList();
			    info.add(detail.getStatus());
			    info.add(detail.getEnd_status());
			    info.add(detail.getEnd_value());
			    info.add(detail.getFacility_id());
			    info.add(detail.getFacility_name());
			    info.add(detail.getStart_date());
			    info.add(detail.getEnd_date());
			    StringBuffer message = new StringBuffer();
			    if(detail.getMessage() != null){ 
			        message.append(detail.getMessage());
			    }
			    if(detail.getError_message() != null){ 
			        message.append(detail.getError_message());
			    }
			    
			    info.add(message.toString());
			    list.add(info);
			}
	    }
	    return list;
	}
}
