/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.collectiverun.composite;

import java.util.ArrayList;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;

import com.clustercontrol.bean.EndStatusColorConstant;
import com.clustercontrol.bean.EndStatusConstant;
import com.clustercontrol.collectiverun.action.ModifyMaster;
import com.clustercontrol.collectiverun.bean.CommandInfo;
import com.clustercontrol.collectiverun.bean.CommandTypeConstant;
import com.clustercontrol.collectiverun.bean.EndStatusInfo;
import com.clustercontrol.collectiverun.bean.ItemInfo;
import com.clustercontrol.collectiverun.bean.TreeItem;
import com.clustercontrol.collectiverun.composite.action.MasterInfoModifyListener;
import com.clustercontrol.collectiverun.util.TreeItemUtil;
import com.clustercontrol.composite.NumberVerifyListener;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.util.Messages;

/**
 * 泬إĥ꡼ݥå
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class CommandComposite extends Composite {
    private Text id = null;

    private Text name = null;
    
    private Button typeCommand = null;
    
    private Button typeScript = null;
    
    private Text command = null;
    
    private Text normalFrom = null;
    
    private Text normalTo = null;
    
    private Text warningFrom = null;
    
    private Text warningTo = null;

    private TreeItem selectItem = null;

    private TreeComposite composite = null;

    public CommandComposite(Composite parent, int style, TreeComposite composite) {
        super(parent, style);
        this.composite = composite;
        this.selectItem = composite.getSelectItem();
        initialize();
    }

    private void initialize() {
        GridLayout layout = new GridLayout(10, true);
        this.setLayout(layout);
        layout.marginHeight = 5;
        layout.marginWidth = 5;

        GridData gridData = null;
        Label label = null;
        
        Group group = new Group(this, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 10;
        group.setLayoutData(gridData);
        group.setText(Messages.getString("command"));
        
        layout = new GridLayout(10, true);
        group.setLayout(layout);
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.verticalSpacing = 10;
        
        // ޥID
        label = new Label(group, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 3;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("command.id") + " : ");
        
        this.id = new Text(group, SWT.BORDER);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 7;
        this.id.setLayoutData(gridData);
        this.id.addModifyListener(new MasterInfoModifyListener(this.composite));

        // ̾
        label = new Label(group, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 3;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("name") + " : ");
        
        this.name = new Text(group, SWT.BORDER);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 7;
        this.name.setLayoutData(gridData);
        this.name.addModifyListener(new MasterInfoModifyListener(this.composite));

        // 
        label = new Label(group, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 3;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("type") + " : ");
        
        this.typeCommand = new Button(group, SWT.RADIO);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 3;
        this.typeCommand.setLayoutData(gridData);
        this.typeCommand.setText(Messages.getString("command"));
        
        this.typeScript = new Button(group, SWT.RADIO);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 3;
        this.typeScript.setLayoutData(gridData);
        this.typeScript.setText(Messages.getString("script"));
        
        label = new Label(group, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        label.setLayoutData(gridData);
        
        // ޥ
        label = new Label(group, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 3;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("command") + " : ");
        
        this.command = new Text(group, SWT.BORDER);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 7;
        this.command.setLayoutData(gridData);
        this.command.addModifyListener(new MasterInfoModifyListener(this.composite));
        
        //λ
        Group endStatusGroup = new Group(group, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 10;
        endStatusGroup.setLayoutData(gridData);
        endStatusGroup.setText(Messages.getString("end.status"));
        
        layout = new GridLayout(10, true);
        endStatusGroup.setLayout(layout);
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.verticalSpacing = 10;
        
        // ޥ
        label = new Label(endStatusGroup, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 3;
        label.setLayoutData(gridData);
        
        label = new Label(endStatusGroup, SWT.NONE | SWT.CENTER);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 7;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("range.end.value"));
        
        // 
        label = new Label(endStatusGroup, SWT.NONE | SWT.CENTER);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        label.setLayoutData(gridData);
        label.setText(EndStatusConstant.STRING_NORMAL + " : ");
        label.setBackground(EndStatusColorConstant.COLOR_NORMAL);
        
        label = new Label(endStatusGroup, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        label.setLayoutData(gridData);
        
        this.normalFrom = new Text(endStatusGroup, SWT.BORDER);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 3;
        this.normalFrom.setLayoutData(gridData);
        this.normalFrom.addVerifyListener(new NumberVerifyListener());
        this.normalFrom.addModifyListener(new MasterInfoModifyListener(this.composite));
        
        label = new Label(endStatusGroup, SWT.NONE | SWT.CENTER);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        label.setText("");
        label.setLayoutData(gridData);
        
        this.normalTo = new Text(endStatusGroup, SWT.BORDER);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 3;
        this.normalTo.setLayoutData(gridData);
        this.normalTo.addVerifyListener(new NumberVerifyListener());
        this.normalTo.addModifyListener(new MasterInfoModifyListener(this.composite));
        
        // ٹ
        label = new Label(endStatusGroup, SWT.NONE | SWT.CENTER);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        label.setLayoutData(gridData);
        label.setText(EndStatusConstant.STRING_WARNING + " : ");
        label.setBackground(EndStatusColorConstant.COLOR_WARNING);
        
        label = new Label(endStatusGroup, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        label.setLayoutData(gridData);
        
        this.warningFrom = new Text(endStatusGroup, SWT.BORDER);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 3;
        this.warningFrom.setLayoutData(gridData);
        this.warningFrom.addVerifyListener(new NumberVerifyListener());
        this.warningFrom.addModifyListener(new MasterInfoModifyListener(this.composite));
        
        label = new Label(endStatusGroup, SWT.NONE | SWT.CENTER);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        label.setText("");
        label.setLayoutData(gridData);
        
        this.warningTo = new Text(endStatusGroup, SWT.BORDER);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 3;
        this.warningTo.setLayoutData(gridData);
        this.warningTo.addVerifyListener(new NumberVerifyListener());
        this.warningTo.addModifyListener(new MasterInfoModifyListener(this.composite));
        
        // ۾
        label = new Label(endStatusGroup, SWT.NONE | SWT.CENTER);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        label.setLayoutData(gridData);
        label.setText(EndStatusConstant.STRING_ABNORMAL + " : ");
        label.setBackground(EndStatusColorConstant.COLOR_ABNORMAL);

        label = new Label(endStatusGroup, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        label.setLayoutData(gridData);
        
        label = new Label(endStatusGroup, SWT.NONE | SWT.CENTER);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 7;
        label.setText(Messages.getString("other"));
        label.setLayoutData(gridData);
        
        // Ŭѥܥ
        label = new Label(this, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 8;
        label.setLayoutData(gridData);
        
        Button buttonCreate = new Button(this, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        buttonCreate.setLayoutData(gridData);
        buttonCreate.setText(Messages.getString("apply"));
        buttonCreate.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent e) {
                ValidateResult result = validate();

                if (result != null) {
                    displayError(result);
                }
            }
        });
        
        setEnabled();
        
        update();
    }
    
    /**
     * ȥλѲ/ԲĤ
     * 
     */
    public void setEnabled() {
        if(this.composite.getCreateItem() == null){
        	this.id.setEnabled(false);
        }
        else{
        	this.id.setEnabled(true);
        }
    }

    /**
     * 
     * 
     */
    public void update() {
    	if(selectItem instanceof TreeItem){
    		if(selectItem.getInfo() instanceof CommandInfo){
    			CommandInfo info = (CommandInfo)selectItem.getInfo();
    			
    			//ޥID
    			if(info.getId() != null){
    				this.id.setText(info.getId());
    			}
    			
    			//̾
    			if(info.getName() != null){
    				this.name.setText(info.getName());
    			}
    			
    			//ޥɼ̤
    			if(info.getCommandType() == CommandTypeConstant.TYPE_COMMAND){
    				this.typeCommand.setSelection(true);
    			}
    			else{
    				this.typeScript.setSelection(true);
    			}
    			
    			//ޥɤ
    			if(info.getCommand() != null){
    				this.command.setText(info.getCommand());
    			}
    			
    			//λ֤
    			if(info.getEndStatus() != null){
    				if(info.getEndStatus() instanceof ArrayList){
    					for(int i = 0; i < info.getEndStatus().size(); i++){
    						EndStatusInfo endstatus = info.getEndStatus().get(i);
    						if(endstatus != null){
    							if(endstatus.getEndStatus() == EndStatusConstant.TYPE_NORMAL){
    								//νλϰϤ
    								this.normalFrom.setText(
    										String.valueOf(endstatus.getStartRangeValue()));
    								this.normalTo.setText(
    										String.valueOf(endstatus.getEndRangeValue()));
    							}
    							else if(endstatus.getEndStatus() == EndStatusConstant.TYPE_WARNING){
    								//ٹνλϰϤ
    								this.warningFrom.setText(
    										String.valueOf(endstatus.getStartRangeValue()));
    								this.warningTo.setText(
    										String.valueOf(endstatus.getEndRangeValue()));
    							}
    						}
    					}
    				}
    			}
    		}
    	}
    	this.composite.setUpdateItem(null);
    }
    
	/**
	 * ޥɾ
	 * 
	 * @return
	 */
	public ValidateResult createCommandInfo() {
		ValidateResult result = null;
		
    	if(selectItem instanceof TreeItem){
    		if(selectItem.getInfo() instanceof CommandInfo){
    			CommandInfo info = (CommandInfo)selectItem.getInfo();
    			CommandInfo cloneInfo = (CommandInfo)info.clone();
    			
    			ItemInfo parentInfo = selectItem.getParent().getInfo();
    			
		        //ޥID
		        if (this.id.getText().length() > 0) {
		        	cloneInfo.setId(this.id.getText());
		        } else {
		            result = new ValidateResult();
		            result.setValid(false);
		            result.setID(Messages.getString("message.hinemos.1"));
		            result.setMessage(Messages.getString("message.collective.run.4"));
		            return result;
		        }
		        
		        //ޥIDʣå
		        if (this.id.isEnabled() && 
		        		TreeItemUtil.findId(cloneInfo.getId(), selectItem.getParent())) {
		            result = new ValidateResult();
		            result.setValid(false);
		            result.setID(Messages.getString("message.hinemos.1"));
		            String args[] = { Messages.getString("command.id"), cloneInfo.getId() };
		            result.setMessage(Messages.getString("message.collective.run.16", args));
		            return result;
		        }
		        
		        //̾
		        if (this.name.getText().length() > 0) {
		        	cloneInfo.setName(this.name.getText());
		        } else {
		            result = new ValidateResult();
		            result.setValid(false);
		            result.setID(Messages.getString("message.hinemos.1"));
		            result.setMessage(Messages.getString("message.collective.run.3"));
		            return result;
		        }
		        
		        //ޥɼ
		        if (this.command.getText().length() > 0) {
		        	cloneInfo.setCommand(this.command.getText());
		        } else {
		            result = new ValidateResult();
		            result.setValid(false);
		            result.setID(Messages.getString("message.hinemos.1"));
		            result.setMessage(Messages.getString("message.collective.run.5"));
		            return result;
		        }

		        //ޥɼ̼
		        if (this.typeCommand.getSelection()) {
		        	cloneInfo.setCommandType(CommandTypeConstant.TYPE_COMMAND);
		        }
		        else{
		        	cloneInfo.setCommandType(CommandTypeConstant.TYPE_SHELL);
		        }
		        
		        ArrayList<EndStatusInfo> list = new ArrayList<EndStatusInfo>();
		        
		        //λ()
	        	EndStatusInfo endstatus = new EndStatusInfo();
	        	endstatus.setEndStatus(EndStatusConstant.TYPE_NORMAL);

		        try {
		            //νλϰϤγͼ
		        	endstatus.setStartRangeValue(
		        			Integer.parseInt(this.normalFrom.getText()));
		        } catch (NumberFormatException e) {
		            result = new ValidateResult();
		            result.setValid(false);
		            result.setID(Messages.getString("message.hinemos.1"));
		            result.setMessage(Messages.getString("message.job.8"));
		            return result;
		        }
		        
		        try {
		            //νλϰϤνλͼ
		        	endstatus.setEndRangeValue(
		        			Integer.parseInt(this.normalTo.getText()));
		        } catch (NumberFormatException e) {
		            result = new ValidateResult();
		            result.setValid(false);
		            result.setID(Messages.getString("message.hinemos.1"));
		            result.setMessage(Messages.getString("message.job.9"));
		            return result;
		        }

		        //νλϰϥå
		        if (endstatus.getStartRangeValue() > endstatus.getEndRangeValue()) {
		            result = new ValidateResult();
		            result.setValid(false);
		            result.setID(Messages.getString("message.hinemos.1"));
		            result.setMessage(Messages.getString("message.job.14"));
		            return result;
		        }
		        list.add(endstatus);


		        //λ(ٹ)
		        if(this.warningFrom.getText().length() > 0 && 
		        		this.warningTo.getText().length() > 0){
		        	
			        endstatus = new EndStatusInfo();
		        	endstatus.setEndStatus(EndStatusConstant.TYPE_WARNING);
	
			        try {
			            //ٹνλϰϤγͼ
			        	endstatus.setStartRangeValue(
			            		Integer.parseInt(this.warningFrom.getText()));
			        } catch (NumberFormatException e) {
			            result = new ValidateResult();
			            result.setValid(false);
			            result.setID(Messages.getString("message.hinemos.1"));
			            result.setMessage(Messages.getString("message.job.11"));
			            return result;
			        }
			        try {
			            //ٹνλϰϤνλͼ
			        	endstatus.setEndRangeValue(
			        			Integer.parseInt(this.warningTo.getText()));
			        } catch (NumberFormatException e) {
			            result = new ValidateResult();
			            result.setValid(false);
			            result.setID(Messages.getString("message.hinemos.1"));
			            result.setMessage(Messages.getString("message.job.12"));
			            return result;
			        }
			        
			        //ٹνλϰϥå
			        if (endstatus.getStartRangeValue() > endstatus.getEndRangeValue()) {
			            result = new ValidateResult();
			            result.setValid(false);
			            result.setID(Messages.getString("message.hinemos.1"));
			            result.setMessage(Messages.getString("message.job.15"));
			            return result;
			        }
			        list.add(endstatus);
		        }
		        
		        //λ֤
		        cloneInfo.setEndStatus(list);
		        
    			
		        ModifyMaster modify = new ModifyMaster();
                if(modify.update(cloneInfo, parentInfo)){
                	
                	selectItem.setInfo(cloneInfo);
                	
                	this.composite.setCreateItem(null);
                	this.composite.setUpdateItem(null);
                	this.composite.getTreeViewer().refresh(selectItem);
                }
                else{
                	//顼顼ɽ
                	Object[] args = { cloneInfo.getName() };
    				MessageDialog.openError(null, 
    						Messages.getString("message"), 
    						Messages.getString("message.collective.run.12", args));	
                }
    		}
    	}
		
		return null;
	}
	
    /**
     * ͥåԤޤ
     * 
     * ɬפ˱ơͥåƲ
     * 
     * @return ValidateResult֥
     */
    protected ValidateResult validate() {
        ValidateResult result = null;

        result = createCommandInfo();
        if (result != null) {
            return result;
        }
        
        return null;
    }
	
    /**
     * 顼ƤΤޤ
     * <p>
     * 
     * ٹåܥåˤơ饤ȤΤޤ
     * 
     * @param result
     *            ValidateResult֥
     */
    protected void displayError(ValidateResult result) {
        MessageBox messageBox = new MessageBox(this.getShell(), SWT.OK
                | SWT.ICON_WARNING);

        messageBox.setText(result.getID());
        messageBox.setMessage(result.getMessage());

        messageBox.open();
    }
    
	/**
	 * @return
	 */
	public TreeItem getSelectItem() {
		return selectItem;
	}

	/**
	 * @param selectItem
	 */
	public void setSelectItem(TreeItem selectItem) {
		this.selectItem = selectItem;
	}
}