/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.collectiverun.composite;

import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

import com.clustercontrol.collectiverun.bean.ItemImageConstant;
import com.clustercontrol.collectiverun.bean.ItemInfo;
import com.clustercontrol.collectiverun.bean.TreeItem;

/**
 * ĥ꡼LabelProvider饹
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
class TreeLabelProvider extends LabelProvider {

	
    public String getText(Object element) {
        ItemInfo info = ((TreeItem) element).getInfo();

        if(info.getName() != null)
        	return info.getName();
        else
        	return "";
    }

    public Image getImage(Object element) {
        int type = ((TreeItem) element).getInfo().getType();
        
        return ItemImageConstant.typeToImage(type);
    }
}