/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.collectiverun.composite;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;

import com.clustercontrol.collectiverun.action.ModifyMaster;
import com.clustercontrol.collectiverun.bean.ItemInfo;
import com.clustercontrol.collectiverun.bean.TreeItem;
import com.clustercontrol.collectiverun.bean.TypeInfo;
import com.clustercontrol.collectiverun.composite.action.MasterInfoModifyListener;
import com.clustercontrol.collectiverun.util.TreeItemUtil;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.util.Messages;

/**
 * 泬إĥ꡼ݥå
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class TypeComposite extends Composite {
    private Text id = null;

    private Text name = null;
    
    private TreeItem selectItem = null;
    
    private TreeComposite composite = null;

    public TypeComposite(Composite parent, int style, TreeComposite composite) {
        super(parent, style);
        this.composite = composite;
        this.selectItem = composite.getSelectItem();
        initialize();
    }

    private void initialize() {
        GridLayout layout = new GridLayout(10, true);
        this.setLayout(layout);
        layout.marginHeight = 5;
        layout.marginWidth = 5;

        GridData gridData = null;
        Label label = null;
        
        Group group = new Group(this, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 10;
        group.setLayoutData(gridData);
        group.setText(Messages.getString("type"));
        
        layout = new GridLayout(10, true);
        group.setLayout(layout);
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.verticalSpacing = 10;
        
        // ID
        label = new Label(group, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 3;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("type.id") + " : ");
        
        this.id = new Text(group, SWT.BORDER);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 7;
        this.id.setLayoutData(gridData);
        this.id.addModifyListener(new MasterInfoModifyListener(this.composite));
        
        // ̾
        label = new Label(group, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 3;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("name") + " : ");
        
        this.name = new Text(group, SWT.BORDER);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 7;
        this.name.setLayoutData(gridData);
        this.name.addModifyListener(new MasterInfoModifyListener(this.composite));
        
        // Ŭѥܥ
        label = new Label(this, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 8;
        label.setLayoutData(gridData);
        
        Button buttonCreate = new Button(this, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        buttonCreate.setLayoutData(gridData);
        buttonCreate.setText(Messages.getString("apply"));
        buttonCreate.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent e) {
                ValidateResult result = validate();

                if (result != null) {
                    displayError(result);
                }
            }
        });
        
        setEnabled();
        
        update();
    }
    
    /**
     * ȥλѲ/ԲĤ
     * 
     */
    public void setEnabled() {
        if(this.composite.getCreateItem() == null){
        	this.id.setEnabled(false);
        }
        else{
        	this.id.setEnabled(true);
        }
    }

    /**
     * 
     * 
     */
    public void update() {
    	if(selectItem instanceof TreeItem){
    		if(selectItem.getInfo() instanceof TypeInfo){
    			TypeInfo info = (TypeInfo)selectItem.getInfo();
    			
    			//ID
    			if(info.getId() != null){
    				this.id.setText(info.getId());
    			}
    			
    			//̾
    			if(info.getName() != null){
    				this.name.setText(info.getName());
    			}
    		}
    	}
    	this.composite.setUpdateItem(null);
    }
    
	/**
	 * ̾
	 * 
	 * @return
	 */
	public ValidateResult createTypeInfo() {
		ValidateResult result = null;
		
    	if(selectItem instanceof TreeItem){
    		if(selectItem.getInfo() instanceof TypeInfo){
    			TypeInfo info = (TypeInfo)selectItem.getInfo();
    			TypeInfo cloneInfo = (TypeInfo)info.clone();
    			
    			ItemInfo parentInfo = selectItem.getParent().getInfo();
    			
		        //ID
		        if (this.id.getText().length() > 0) {
		        	cloneInfo.setId(this.id.getText());
		        } else {
		            result = new ValidateResult();
		            result.setValid(false);
		            result.setID(Messages.getString("message.hinemos.1"));
		            result.setMessage(Messages.getString("message.collective.run.2"));
		            return result;
		        }
		        
		        //IDʣå
		        if (this.id.isEnabled() && 
		        		TreeItemUtil.findId(cloneInfo.getId(), selectItem.getParent())) {
		            result = new ValidateResult();
		            result.setValid(false);
		            result.setID(Messages.getString("message.hinemos.1"));
		            String args[] = { Messages.getString("type.id"), cloneInfo.getId() };
		            result.setMessage(Messages.getString("message.collective.run.16", args));
		            return result;
		        }
		        
		        //̾
		        if (this.name.getText().length() > 0) {
		        	cloneInfo.setName(this.name.getText());
		        } else {
		            result = new ValidateResult();
		            result.setValid(false);
		            result.setID(Messages.getString("message.hinemos.1"));
		            result.setMessage(Messages.getString("message.collective.run.3"));
		            return result;
		        }
		        
		        //̾ʣå
		        if (TreeItemUtil.findTypeName(
		        		cloneInfo.getName(), 
		        		TreeItemUtil.getTopTreeItem(selectItem))) {
		            result = new ValidateResult();
		            result.setValid(false);
		            result.setID(Messages.getString("message.hinemos.1"));
		            String args[] = { Messages.getString("name"), cloneInfo.getName() };
		            result.setMessage(Messages.getString("message.collective.run.16", args));
		            return result;
		        }
		        
		        ModifyMaster modify = new ModifyMaster();
                if(modify.update(cloneInfo, parentInfo)){
                	
                	selectItem.setInfo(cloneInfo);
                	
                	this.composite.setCreateItem(null);
                	this.composite.setUpdateItem(null);
                	this.composite.getTreeViewer().refresh(selectItem);
                }
                else{
                	//顼顼ɽ
                	Object[] args = { cloneInfo.getName() };
    				MessageDialog.openError(null, 
    						Messages.getString("message"), 
    						Messages.getString("message.collective.run.11", args));
                }
    		}
    	}
		
		return null;
	}
	
    /**
     * ͥåԤޤ
     * 
     * ɬפ˱ơͥåƲ
     * 
     * @return ValidateResult֥
     */
    protected ValidateResult validate() {
        ValidateResult result = null;

        result = createTypeInfo();
        if (result != null) {
            return result;
        }
        
        return null;
    }
	
    /**
     * 顼ƤΤޤ
     * <p>
     * 
     * ٹåܥåˤơ饤ȤΤޤ
     * 
     * @param result
     *            ValidateResult֥
     */
    protected void displayError(ValidateResult result) {
        MessageBox messageBox = new MessageBox(this.getShell(), SWT.OK
                | SWT.ICON_WARNING);

        messageBox.setText(result.getID());
        messageBox.setMessage(result.getMessage());

        messageBox.open();
    }

	/**
	 * @return
	 */
	public TreeItem getSelectItem() {
		return selectItem;
	}

	/**
	 * @param selectItem
	 */
	public void setSelectItem(TreeItem selectItem) {
		this.selectItem = selectItem;
	}
}