/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.collectiverun.composite.action;

import java.util.ArrayList;

import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

import com.clustercontrol.collectiverun.bean.HistoryTableDefine;
import com.clustercontrol.collectiverun.composite.HistoryComposite;
import com.clustercontrol.collectiverun.composite.ParameterViewComposite;
import com.clustercontrol.collectiverun.view.DetailView;
import com.clustercontrol.collectiverun.view.ParameterView;

/**
 * ơ֥SelectionChangedListener饹
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class HistorySelectionChangedListener implements
        ISelectionChangedListener {
    protected HistoryComposite m_composite;

    /**
     * 󥹥ȥ饯
     * 
     * @param composite
     * @since 1.0.0
     */
    public HistorySelectionChangedListener(HistoryComposite composite) {
        m_composite = composite;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.jface.viewers.ISelectionChangedListener#selectionChanged(org.eclipse.jface.viewers.SelectionChangedEvent)
     */
    public void selectionChanged(SelectionChangedEvent event) {
        String sessionId = null;

        //åID
        if (((StructuredSelection) event.getSelection()).getFirstElement() != null) {
            ArrayList info = (ArrayList) ((StructuredSelection) event
                    .getSelection()).getFirstElement();
            sessionId = (String) info.get(HistoryTableDefine.SESSION_ID);
            //åID
            m_composite.setSessionId(sessionId);
        }

        //ƥ֥ڡ
        IWorkbenchPage page = PlatformUI.getWorkbench()
                .getActiveWorkbenchWindow().getActivePage();

        //ܺ٥ӥ塼ɽ
        IViewPart viewPart = page.findView(DetailView.ID);
        if (viewPart != null) {
            DetailView view = (DetailView) viewPart
                    .getAdapter(DetailView.class);
            view.update(sessionId);
        }

        //ѥ᡼ӥ塼ɽ
        viewPart = page.findView(ParameterView.ID);
        if (viewPart != null) {
            ParameterView view = (ParameterView) viewPart
                    .getAdapter(ParameterView.class);
            ParameterViewComposite composite = view.getComposite();
            composite.update(sessionId);
        }
    }
}

