/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.collectiverun.preference;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchWindow;

import com.clustercontrol.collectiverun.ui.CollectiveRunUIPlugin;
import com.clustercontrol.collectiverun.view.HistoryView;
import com.clustercontrol.util.Messages;

/**
 * 浡ǽڡ饹Ǥ
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class CollectiveRunPreferencePage extends FieldEditorPreferencePage
        implements IWorkbenchPreferencePage {

    // ----- static ե ----- //

    /** ưե饰 */
    public static final String P_CYCLE_FLG = "cycleFlg";

    /** ư */
    public static final String P_CYCLE_SEC = "cycleSec";

    // ----- 󥹥ȥ饯 ----- //

    /**
     * ͤꤵ줿󥹥󥹤֤ޤ
     */
    public CollectiveRunPreferencePage() {
        super(GRID);
        this.setPreferenceStore(CollectiveRunUIPlugin.getDefault()
                .getPreferenceStore());

        this.initializeDefaults();
    }

    /**
     * ͤꤷޤ
     */
    private void initializeDefaults() {
        IPreferenceStore store = getPreferenceStore();
        store.setDefault(P_CYCLE_FLG, true);
        store.setDefault(P_CYCLE_SEC, 10);
    }

    /**
     * եɤޤ
     */
    public void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        GridData gridData = null;
        // []ӥ塼Ϣ
        Group group = new Group(parent, SWT.SHADOW_NONE);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 10;
        gridData.verticalSpan = 10;
        group.setLayoutData(gridData);
        group.setText(Messages.getString("view.collective.run.history"));
        this.addField(new BooleanFieldEditor(P_CYCLE_FLG, Messages
                .getString("autoupdate.enable"), group));
        this.addField(new IntegerFieldEditor(P_CYCLE_SEC, Messages
                .getString("autoupdate.cycle")
                + " : ", group));
    }

    /**
     * Ƥӥ塼ȿǤޤ
     * 
     * @see org.eclipse.jface.preference.IPreferencePage#performOk()
     */
    public boolean performOk() {
        boolean result = super.performOk();

        this.applySetting();

        return result;
    }

    /**
     * ƤȿǤޤ
     */
    protected void applySetting() {
        IPreferenceStore store = this.getPreferenceStore();

        IWorkbench workbench = CollectiveRunUIPlugin.getDefault()
                .getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();

        int windowCount = windows.length;

        for (int i = 0; i < windowCount; i++) {
            IWorkbenchPage[] pages = windows[i].getPages();
            int pageCount = pages.length;

            for (int j = 0; j < pageCount; j++) {
                HistoryView historyView = (HistoryView) pages[j]
                        .findView(HistoryView.ID);
                if (historyView != null) {
                    int cycle = store.getInt(P_CYCLE_SEC);
                    historyView.setInterval(cycle);
                    if (store.getBoolean(P_CYCLE_FLG)) {
                        historyView.startAutoReload();
                    } else {
                        historyView.stopAutoReload();
                    }
                }
            }
        }
    }

    /**
     * 
     * @see org.eclipse.ui.IWorkbenchPreferencePage#init(org.eclipse.ui.IWorkbench)
     */
    public void init(IWorkbench workbench) {
    }
}