/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.collectiverun.view;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;

import com.clustercontrol.bean.Property;
import com.clustercontrol.collectiverun.composite.HistoryComposite;
import com.clustercontrol.collectiverun.preference.CollectiveRunPreferencePage;
import com.clustercontrol.collectiverun.ui.CollectiveRunUIPlugin;
import com.clustercontrol.view.AutoUpdateView;

/**
 * []ӥ塼饹
 * 
 * @version 1.0.0
 * @since 1.0.0
 *  
 */
public class HistoryView extends AutoUpdateView {
    public static final String ID = "com.clustercontrol.collectiverun.view.HistoryView";

    /** ե륿 */
    private Property m_condition = null;

    /** 򥳥ݥå */
    private HistoryComposite m_history = null;

    /**
     * 󥹥ȥ饯
     */
    public HistoryView() {
        super();
    }

    /**
     * ViewPartؤΥȥ
     * 
     * @see org.eclipse.ui.IWorkbenchPart#createPartControl(org.eclipse.swt.widgets.Composite)
     */
    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout(1, true);
        parent.setLayout(layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;

        //
        m_history = new HistoryComposite(parent, SWT.NONE);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        m_history.setLayoutData(gridData);

        this.update();

        // ȿ
        IPreferenceStore store = CollectiveRunUIPlugin.getDefault()
                .getPreferenceStore();

        this.setInterval(store.getInt(CollectiveRunPreferencePage.P_CYCLE_SEC));

        if (store.getBoolean(CollectiveRunPreferencePage.P_CYCLE_FLG)) {
            this.startAutoReload();
        }
    }

    /**
     * 򥳥ݥåȼ
     * 
     * @return historyComposite
     *  
     */
    public HistoryComposite getComposite() {
        return this.m_history;
    }

    /**
     * ե륿
     * 
     * @return ե륿
     */
    public Property getFilterCondition() {
        return m_condition;
    }

    /**
     * ե륿
     * 
     * @param condition
     *            ե륿
     */
    public void setFilterCondition(Property condition) {
        m_condition = condition;
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.clustercontrol.view.AutoUpdateView#update()
     */
    public void update() {
        if (m_condition == null) {
            m_history.update();
        } else {
            m_history.update(m_condition);
        }
    }

    /**
     * ץȤ׵ᤵ줿硢ȤΥ󥹥󥹤Ϥޤ
     * 
     * @param cls
     *            饹Υ󥹥
     * @return ȤΥ󥹥
     */
    public Object getAdapter(Class cls) {
        if (cls.isInstance(this)) {
            return this;
        } else {
            return super.getAdapter(cls);
        }
    }
}