/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.http.factory;

import java.text.NumberFormat;
import java.util.Date;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.jms.JMSException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.http.ejb.entity.MonitorHttpInfoLocal;
import com.clustercontrol.http.ejb.entity.MonitorHttpInfoPK;
import com.clustercontrol.http.ejb.entity.MonitorHttpInfoUtil;
import com.clustercontrol.http.util.GetHttpResponse;
import com.clustercontrol.monitor.run.factory.RunMonitorNumericValueType;
import com.clustercontrol.util.Messages;

/**
 * HTTPƻ ʹƻѼ¹ԥ饹
 *
 * @version 2.1.0
 * @since 2.1.0
 */
public class RunMonitorHttp extends RunMonitorNumericValueType {
	
	protected static Log m_log = LogFactory.getLog( RunMonitorHttp.class );
	
	public static final String MESSAGE_ID_INFO = "001";
	public static final String MESSAGE_ID_WARNING = "002";
	public static final String MESSAGE_ID_CRITICAL = "003";
	public static final String MESSAGE_ID_UNKNOWN = "004";
	
//	/** Ρ ͥåȥ */
//	protected static final ArrayList<String> m_attributeList = new ArrayList<String>();
//	static{
//		m_attributeList.add(FacilityAttributeConstant.IPNETWORKNUMBER);
//		m_attributeList.add(FacilityAttributeConstant.IPNETWORKNUMBERV6);
//	}
	
	/** HTTPƻ */
	protected MonitorHttpInfoLocal m_http = null;
	
	/** URL */
	protected String m_requestUrl = null;
	
	/** ॢ */
	protected int m_httpTimeout;
	
	/** URLִ */
	protected int m_urlReplace = YesNoConstant.TYPE_NO;
	
	/** ץ */
	protected int m_proxySet = YesNoConstant.TYPE_NO;
	
	/** ץ ۥ */
	protected String m_proxyHost;
	
	/** ץ ݡ */
	protected int m_proxyPort;
	
	/** å */
	protected String m_message = "";
	
	/** ꥸʥå */
	protected String m_messageOrg = null;
	
	/**
	 * 󥹥ȥ饯
	 * 
	 */
	public RunMonitorHttp() throws NamingException, JMSException, CreateException{
		super();
	}
	
	/* ( Javadoc)
	 * @see com.clustercontrol.monitor.run.factory.RunMonitor#runMonitorInfo()
	 */
	@Override
	public boolean runMonitorInfo() throws FinderException, RemoveException, JMSException, NamingException, CreateException {
		
		// ƻå
		setCheckInfo();
		
		if(m_urlReplace == YesNoConstant.TYPE_YES){
			return super.runMonitorInfo();
		}
		else{
			m_now = new Date();
			
			try 
			{
				// ƻܾ
				boolean run = this.setMonitorInfo(m_monitorTypeId, m_monitorId);
				if(!run){
					// λ
					return true;
				}
				
				// Ƚ
				setJudgementInfo();
				
				// ƻͤ
				boolean ret = collect(null);
				
				// ƻͤȽ̤
				int checkResult = getCheckResult(ret);
				
				// ƻ
				notify(true, m_facilityId, checkResult, new Date(m_nodeDate));
				
				return true;
				
			} catch (FinderException e) {
				m_log.error("runMonitorInfo(): ƻоID:" + m_monitorTypeId + ",ƻID" + m_monitorId  + ", " + e.getMessage());
				throw e;
			} catch (CreateException e) {
				m_log.error("runMonitorInfo(): ƻоID:" + m_monitorTypeId + ",ƻID" + m_monitorId  + ", " + e.getMessage());
				throw e;
			} catch (JMSException e) {
				m_log.error("runMonitorInfo(): ƻоID:" + m_monitorTypeId + ",ƻID" + m_monitorId  + ", " + e.getMessage());
				throw e;
			} catch (NamingException e) {
				m_log.error("runMonitorInfo(): ƻоID:" + m_monitorTypeId + ",ƻID" + m_monitorId  + ", " + e.getMessage());
				throw e;
			}
		}
	}
	
	/**
	 * HTTP ֡áˤ
	 * 
	 * @param facilityId եƥID
	 * @return ͼ硢true
	 */
	@Override
	public boolean collect(String facilityId) {
		
		m_nodeDate = m_now.getTime();
		m_value = 0;
		m_message = "";
		m_messageOrg = "";
		
		GetHttpResponse m_request = new GetHttpResponse();
		
//		String url = null;
//		if(m_urlReplace == YesNoConstant.TYPE_YES){
//			
//			String ipNetworkNumber = null; 
//			try{
//				// Ρɤ°
//				HashMap facilityAttrMap = m_repository.getNodeDetail(facilityId, m_attributeList);
//				ipNetworkNumber = (String)facilityAttrMap.get(FacilityAttributeConstant.IPNETWORKNUMBER);
//				
//				// URLִ
//				if(ipNetworkNumber != null && !"".equals(ipNetworkNumber)){
//					
//					url = m_requestUrl.replaceAll("(http://|https://)([^/:]+)(([:/](([^\\s]+)|$))|$)","$1" + ipNetworkNumber + "$3");
//					m_log.debug("collect(): URL = " + url);
//				}
//				else{
//					String[] args = { facilityId };
//					m_message = Messages.getString("message.http.4", args);
//					return false;
//				}
//			}
//			catch(FinderException e){
//				m_log.debug("collect():" + e.getMessage());
//				
//				String[] args = { facilityId };
//				m_message = Messages.getString("message.http.4", args);
//				m_messageOrg = e.getMessage();
//				return false;
//			}
//			catch(NamingException e){
//				m_log.debug("collect():" + e.getMessage());
//				
//				String[] args = { facilityId };
//				m_message = Messages.getString("message.http.4", args);
//				m_messageOrg = e.getMessage();
//				return false;
//			}
//		}
//		else{
//			// URL
//			url = m_requestUrl;
//		}
		
		String url = m_requestUrl;
		boolean result = m_request.execute(url, m_httpTimeout*1000);
		
		if(result){
			m_value = m_request.getResponseTime()/1000;
			
			m_message = Messages.getString("response.time.sec") + " : " + NumberFormat.getNumberInstance().format(m_value);
			
			StringBuffer response = new StringBuffer();
			response.append(Messages.getString("status.code") + " : " + m_request.getStatusCode());
			if(m_request.getHeader() != null && !"".equals(m_request.getHeader().trim())){
				response.append("\n" + Messages.getString("header") + " :\n" + m_request.getHeader().trim());
			}
			if(m_request.getFooter() != null && !"".equals(m_request.getFooter().trim())){
				response.append("\n" + Messages.getString("footer") + " :\n" + m_request.getFooter().trim());
			}
			if(m_request.getResponseBody() != null && !"".equals(m_request.getResponseBody().trim())){
				response.append("\n" + Messages.getString("response.body") + " :\n" + m_request.getResponseBody().trim());
			}
			m_messageOrg = response.toString();
		}
		else{
			m_message = Messages.getString("message.http.3");
			
			StringBuffer response = new StringBuffer();
			response.append(m_request.getErrorMessage());
			response.append("\n" + Messages.getString("status.code") + " : " + m_request.getStatusCode());
			if(m_request.getHeader() != null && !"".equals(m_request.getHeader().trim())){
				response.append("\n" + Messages.getString("header") + " :\n" + m_request.getHeader().trim());
			}
			if(m_request.getFooter() != null && !"".equals(m_request.getFooter().trim())){
				response.append("\n" + Messages.getString("footer") + " :\n" + m_request.getFooter().trim());
			}
			m_messageOrg = response.toString();
		}
		return result;
	}
	
	/* (non-Javadoc)
	 * HTTPƻ
	 * @see com.clustercontrol.monitor.run.factory.OperationNumericValueInfo#setMonitorAdditionInfo()
	 */
	@Override
	public void setCheckInfo() throws FinderException, NamingException{
		
		if(m_http == null){
			// HTTPƻ
			MonitorHttpInfoPK pk = new MonitorHttpInfoPK(m_monitorId, m_monitorTypeId);
			m_http = MonitorHttpInfoUtil.getLocalHome().findByPrimaryKey(pk);
			
			// HTTPƻ
			m_requestUrl = m_http.getRequestUrl().trim();
			m_httpTimeout = m_http.getTimeout().intValue();
			m_urlReplace = m_http.getUrlReplace().intValue();
			m_proxySet = m_http.getProxySet().intValue();
			if(m_http.getProxyHost() != null){
				m_proxyHost = m_http.getProxyHost().trim();
			}
			m_proxyPort = m_http.getProxyPort().intValue();
		}
	}
	
	/* ( Javadoc)
	 * ΡѥåID
	 * @see com.clustercontrol.monitor.run.factory.RunMonitor#getMessageId(int)
	 */
	@Override
	public String getMessageId(int id) {
		
		if(id == PriorityConstant.TYPE_INFO){
			return MESSAGE_ID_INFO;
		}
		else if(id == PriorityConstant.TYPE_WARNING){
			return MESSAGE_ID_WARNING;
		}
		else if(id == PriorityConstant.TYPE_CRITICAL){
			return MESSAGE_ID_CRITICAL;
		}
		else{
			return MESSAGE_ID_UNKNOWN;
		}
	}
	
	/* ( Javadoc)
	 * Ρѥå
	 * @see com.clustercontrol.monitor.run.factory.RunMonitor#getMessage(int)
	 */
	@Override
	public String getMessage(int id) {
		return m_message;
	}
	
	/* ( Javadoc)
	 * Ρѥꥸʥå
	 * @see com.clustercontrol.monitor.run.factory.RunMonitor#getMessageOrg(int)
	 */
	@Override
	public String getMessageOrg(int id) {
		return m_messageOrg;
	}
}