/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.http.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;

import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.util.Messages;

/**
 * HTTP饤
 *
 * @version 2.1.0
 * @since 2.1.0
 */
public class GetHttpResponse {
	
	protected static Log m_log = LogFactory.getLog( GetHttpResponse.class );
	
	/** ܥǥоݤContent-Type */
	public static final String TARGET_CONTENT_TYPE = "text";
	
	/** ץСۥ̾ */
	protected String m_proxyHost;
	
	/** ץ ݡ */
	protected int m_proxyPort;
	
	/** ơ */
	protected int m_statusCode;
	
	/** إå */
	protected StringBuffer m_header;
	
	/** ܥǥ */
	protected String m_responseBody;
	
	/** եå */
	protected StringBuffer m_footer;
	
	/** ֡ʥߥá */
	protected long m_responseTime;
	
	/** 顼å */
	protected String m_errorMessage;
	
	
	/**
	 * 󥹥ȥ饯
	 */
	public GetHttpResponse() {
		super();
	}
	
	/**
	 * 󥹥ȥ饯
	 * 
	 * @param host ץСۥ̾
	 * @param port ץСݡ
	 */
	public GetHttpResponse(String host, int port) {
		super();
		m_proxyHost = host;
		m_proxyPort = port;
	}
	
	/**
	 * ꥯURL
	 * 
	 * @param url URL
	 * @param timeout ॢȡʥߥá
	 * @return
	 */
	public boolean execute(String url, int timeout) {
		
		boolean result = false;
		
		// Create an instance of HttpClient.
		HttpClient client = new HttpClient();
		
		// proxy
		if(m_proxyHost != null && !"".equals(m_proxyHost.trim())){
			client.getHostConfiguration().setProxy(m_proxyHost, m_proxyPort);
		}
		
		// Create a method instance.
		GetMethod method = new GetMethod(url);
		
		// ॢ
		if(timeout > 0){
			// establish a connection within n milliseconds
			client.getHttpConnectionManager().getParams().setConnectionTimeout(timeout);
			
			// socket timeout in milliseconds
			method.getParams().setSoTimeout(timeout);
		}
		
		try {
			// Execute the method.
			long start = System.currentTimeMillis();
			m_statusCode = client.executeMethod(method);
			long end = System.currentTimeMillis();
			m_responseTime = end - start;
			
			// Header
			Header[] headers = method.getResponseHeaders();
			if (headers != null && headers.length>0) {
				m_header = new StringBuffer();
				for (int i = 0; i < headers.length; i++) {
					m_header.append(headers[i]);
				}
			}
			
			// Footer
			Header[] footers = method.getResponseFooters();
			if (footers != null && footers.length>0) {
				m_header = new StringBuffer();
				for (int i = 0; i < footers.length; i++) {
					m_footer.append(footers[i]);
				}
			}
			
			if (m_statusCode == HttpStatus.SC_OK) {
				// Content-TypetextʸξΤߡBody
				Header header = method.getResponseHeader("Content-Type");
				if(header != null && header.getValue() != null && header.getValue().indexOf(TARGET_CONTENT_TYPE) != -1){
					// Read the response body.
					byte[] responseBody = method.getResponseBody();
					m_responseBody = new String(responseBody, "JISAutoDetect");
					result = true;
				}
				else{
					m_errorMessage = Messages.getString("message.http.2");
				}
			}
			else{
				m_errorMessage = method.getStatusText();
			}
			
		} catch (UnsupportedEncodingException e) {
			m_log.debug("execute(): " + e.getMessage());
			m_errorMessage = "UnsupportedEncodingException : " +  e.getMessage();
		} catch (HttpException e) {
			m_log.debug("execute(): Fatal protocol violation. " + e.getMessage());
			m_errorMessage = "HttpException : " + e.getMessage();
		} catch (IOException e) {
			m_log.debug("execute(): Fatal transport error. "  + e.getMessage());
			m_errorMessage = "IOException : " + e.getMessage();
		} finally {
			// Release the connection.
			if(method != null){
				method.releaseConnection();
			}
		}
		return result;
	}
	
	/**
	 * @return m_footer ᤷޤ
	 */
	public String getFooter() {
		
		if(m_footer != null){
			return m_footer.toString();
		}
		return null;
	}
	
	/**
	 * @return m_header ᤷޤ
	 */
	public String getHeader() {
		
		if(m_header != null){
			return m_header.toString();
		}
		return null;
	}
	
	/**
	 * @return m_responseBody ᤷޤ
	 */
	public String getResponseBody() {
		return m_responseBody;
	}
	
	/**
	 * @return m_responseTime ᤷޤ
	 */
	public long getResponseTime() {
		return m_responseTime;
	}
	
	/**
	 * @return m_statusCode ᤷޤ
	 */
	public int getStatusCode() {
		return m_statusCode;
	}
	
	/**
	 * @return m_errorMessage ᤷޤ
	 */
	public String getErrorMessage() {
		return m_errorMessage;
	}
}
