/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.http.dialog;

import java.util.ArrayList;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import com.clustercontrol.bean.MonitorBlockConstant;
import com.clustercontrol.bean.MonitorConstant;
import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.composite.PositiveNumberVerifyListener;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.http.action.GetHttp;
import com.clustercontrol.http.action.GetHttpStringValueListTableDefine;
import com.clustercontrol.http.bean.MonitorHttpInfo;
import com.clustercontrol.monitor.run.bean.MonitorCheckInfo;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.monitor.run.bean.MonitorTypeConstant;
import com.clustercontrol.monitor.run.composite.MonitorBasicScopeComposite;
import com.clustercontrol.monitor.run.composite.MonitorRuleComposite;
import com.clustercontrol.monitor.run.composite.NumericRunJobComposite;
import com.clustercontrol.monitor.run.composite.NumericValueInfoComposite;
import com.clustercontrol.monitor.run.composite.StringValueInfoComposite;
import com.clustercontrol.notify.composite.NotifyInfoComposite;
import com.clustercontrol.util.Messages;

/**
 * HTTPƻѹ饹Ǥ
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class HttpCreateDialog extends CommonDialog {
	
	public static final int WIDTH_TITLE = 5;
	public static final int WIDTH_VALUE = 2;

    // ----- instance ե ----- //

    /** ͤݻ륪֥ */
    private MonitorInfo inputData = null;

    /** ͤݻ륪֥ */
    private ValidateResult validateResult = null;
    
    /** ѹоݤδƻID */
    private String monitorId = null;
    
    /** ƻܾ */
    MonitorBasicScopeComposite m_monitorBasic = null;
    
    /** ƻ ʬ */
    private MonitorRuleComposite m_monitorRule = null;
    
    /** URL */
    private Text m_textRequestUrl = null;
    
    /** ॢȡá */
	protected Text m_comboTimeout = null;
    
    /** ʹƻȽ */
    private NumericValueInfoComposite m_numericValueInfo= null;
    
    /** ʸƻȽ */
    private StringValueInfoComposite m_stringValueInfo= null;
    
    /** ξ */
    private NotifyInfoComposite m_notifyInfo = null;
    
    /** ּ¹ */
    private Button m_checkJobRun = null;
    
    /** ּ¹Ծ */
    private NumericRunJobComposite m_jobRun = null;
    
    /** ͭˤ */
    private Button confirmValid = null;
    
    /** ƻȽ꥿ @version 2.1.0 */
	private int m_monitorType;

    // ----- 󥹥ȥ饯 ----- //

    /**
     * ѥΥ󥹥󥹤֤ޤ
     * 
     * @param parent
     *            ƤΥ륪֥
     */
    public HttpCreateDialog(Shell parent) {
        super(parent);
    }
    
    /**
     * ѥΥ󥹥󥹤֤ޤ
     * 
     * @param parent ƤΥ륪֥
     * @param monitorType ƻȽ꥿
     */
    public HttpCreateDialog(Shell parent, int monitorType) {
        super(parent);

        this.m_monitorType = monitorType;
    }
    
    /**
     * ѹѥΥ󥹥󥹤֤ޤ
     * 
     * @param parent ƤΥ륪֥
     * @param monitorId ѹƻID
     * @param monitorType ƻȽ꥿
     */
    public HttpCreateDialog(Shell parent, String monitorId, int monitorType) {
        super(parent);

        this.monitorId = monitorId;
        this.m_monitorType = monitorType;
    }

    // ----- instance ᥽å ----- //

    /**
     * ꥢޤ
     * 
     * @param parent ƤΥ󥹥
     */
    protected void customizeDialog(Composite parent) {
        Shell shell = this.getShell();

        // ȥ
        shell.setText(Messages.getString("dialog.http.create.modify"));

        // ѿȤѤ٥
        Label label = null;
        // ѿȤѤ륰åɥǡ
        GridData gridData = null;

        // 쥤
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.numColumns = 15;
        parent.setLayout(layout);
        
        // ƻܾ
        m_monitorBasic = new MonitorBasicScopeComposite(parent, SWT.NONE);
        gridData = new GridData();
		gridData.horizontalSpan = 15;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		m_monitorBasic.setLayoutData(gridData);
        
        /*
         * ƻ殺롼
         */
        // ٥
        label = new Label(parent, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("monitor.rule") + " : ");
        
        // 롼
        Group groupRule = new Group(parent, SWT.NONE);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 1;
        groupRule.setLayout(layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        groupRule.setLayoutData(gridData);

        m_monitorRule = new MonitorRuleComposite(groupRule, SWT.NONE);
        gridData = new GridData();
		gridData.horizontalSpan = 15;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		m_monitorRule.setLayoutData(gridData);
        
        /*
         * å殺롼
         */
        // ٥
        label = new Label(groupRule, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("check.rule") + " : ");
        
        // 롼
        Group groupCheckRule = new Group(groupRule, SWT.NONE);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 15;
        groupCheckRule.setLayout(layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        groupCheckRule.setLayoutData(gridData);
        
        /*
         * URL
         */
        // ٥
        label = new Label(groupCheckRule, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = WIDTH_TITLE;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("request.url") + " : ");
        // ƥ
        this.m_textRequestUrl = new Text(groupCheckRule, SWT.BORDER | SWT.LEFT);
        gridData = new GridData();
        gridData.horizontalSpan = 10;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.m_textRequestUrl.setLayoutData(gridData);
        
        /*
         * ॢ(ߥ)
         */
        // ٥
        label = new Label(groupCheckRule, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = WIDTH_TITLE;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("time.out.sec") + " : ");
        // ܥܥå
        this.m_comboTimeout = new Text(groupCheckRule, SWT.BORDER);
        gridData = new GridData();
        gridData.horizontalSpan = WIDTH_VALUE;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.m_comboTimeout.addVerifyListener(new PositiveNumberVerifyListener());
        this.m_comboTimeout.setLayoutData(gridData);
        
        // 
        label = new Label(groupCheckRule, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        
        // ʹƻξ     
		if(m_monitorType == MonitorTypeConstant.TYPE_NUMERIC){
        
			/*
	         * Ρñ̤ν٥롼
	         */
	        // ٥
	        label = new Label(parent, SWT.NONE);
	        gridData = new GridData();
	        gridData.horizontalSpan = 15;
	        gridData.horizontalAlignment = GridData.FILL;
	        gridData.grabExcessHorizontalSpace = true;
	        label.setLayoutData(gridData);
	        label.setText(Messages.getString("def.result.node") + " : ");
	        
	        // 롼
	        Group groupDefResultNode = new Group(parent, SWT.NONE);
	        layout = new GridLayout(1, true);
	        layout.marginWidth = 5;
	        layout.marginHeight = 5;
	        layout.numColumns = 1;
	        groupDefResultNode.setLayout(layout);
	        gridData = new GridData();
	        gridData.horizontalSpan = 15;
	        gridData.horizontalAlignment = GridData.FILL;
	        gridData.grabExcessHorizontalSpace = true;
	        groupDefResultNode.setLayoutData(gridData);
	        
	        // Ƚ
	        m_numericValueInfo = new NumericValueInfoComposite(groupDefResultNode, 
	        		SWT.NONE,
	        		true,
	        		Messages.getString("time.period.sec"),
	        		Messages.getString("time.period.sec"),
	        		NumericValueInfoComposite.INPUT_VERIFICATION_POSITIVE_INTEGER);
	        gridData = new GridData();
			gridData.horizontalSpan = 15;
			gridData.horizontalAlignment = GridData.FILL;
			gridData.grabExcessHorizontalSpace = true;
			m_numericValueInfo.setLayoutData(gridData);
		}
		
		/*
         * ξ°롼
         */
        // ٥
        label = new Label(parent, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("notify.attribute") + " : ");
        
        // 롼
        Group groupNotifyAttribute = new Group(parent, SWT.NONE);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 1;
        groupNotifyAttribute.setLayout(layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        groupNotifyAttribute.setLayoutData(gridData);
        
        // ξIDץꥱID¹ԡ
        if(m_monitorType == MonitorTypeConstant.TYPE_NUMERIC){
        	this.m_notifyInfo = new NotifyInfoComposite(groupNotifyAttribute, SWT.NONE);
        }
        else if(m_monitorType == MonitorTypeConstant.TYPE_STRING){
        	this.m_notifyInfo = new NotifyInfoComposite(groupNotifyAttribute, SWT.NONE, Messages.getString("notify.id.default"));
        }
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		m_notifyInfo.setLayoutData(gridData);
		
		// ʹƻξ     
		if(m_monitorType == MonitorTypeConstant.TYPE_NUMERIC){
			
			// ּ¹
	        this.m_checkJobRun = new Button(groupNotifyAttribute, SWT.CHECK);
	        gridData = new GridData();
	        gridData.horizontalSpan = 1;
	        gridData.horizontalAlignment = GridData.FILL;
	        gridData.grabExcessHorizontalSpace = true;
	        m_checkJobRun.setLayoutData(gridData);
	        m_checkJobRun.setText(Messages.getString("run") + " : ");
	        m_checkJobRun.addSelectionListener(new SelectionAdapter() {
	            public void widgetSelected(SelectionEvent e) {
	            	m_jobRun.setEnabled(m_checkJobRun.getSelection());
	            }
	        });
			
			// ּ¹ԥ롼
	        Group groupRunJob = new Group(groupNotifyAttribute, SWT.NONE);
	        layout = new GridLayout(1, true);
	        layout.marginWidth = 5;
	        layout.marginHeight = 5;
	        layout.numColumns = 1;
	        groupRunJob.setLayout(layout);
	        gridData = new GridData();
	        gridData.horizontalSpan = 15;
	        gridData.horizontalAlignment = GridData.FILL;
	        gridData.grabExcessHorizontalSpace = true;
	        groupRunJob.setLayoutData(gridData);
	        
	        // ¹ԡʼ¹ԡIDϢưƽмԻ
			this.m_jobRun = new NumericRunJobComposite(groupRunJob, SWT.NONE);
			gridData = new GridData();
			gridData.horizontalSpan = 1;
			gridData.horizontalAlignment = GridData.FILL;
			gridData.grabExcessHorizontalSpace = true;
			m_jobRun.setLayoutData(gridData);
		}
		// ʸƻξ
		else if(m_monitorType == MonitorTypeConstant.TYPE_STRING){
			
			/*
	         * Ρñ̤ν٤롼
	         */
			// ٥
	        label = new Label(parent, SWT.NONE);
	        gridData = new GridData();
	        gridData.horizontalSpan = 15;
	        gridData.horizontalAlignment = GridData.FILL;
	        gridData.grabExcessHorizontalSpace = true;
	        label.setLayoutData(gridData);
	        label.setText(Messages.getString("def.result.node") + " : ");
	        
	        // 롼
	        Group groupDefResult = new Group(parent, SWT.NONE);
	        layout = new GridLayout(1, true);
	        layout.marginWidth = 5;
	        layout.marginHeight = 5;
	        layout.numColumns = 1;
	        groupDefResult.setLayout(layout);
	        gridData = new GridData();
	        gridData.horizontalSpan = 15;
	        gridData.horizontalAlignment = GridData.FILL;
	        gridData.grabExcessHorizontalSpace = true;
	        groupDefResult.setLayoutData(gridData);
			
	        // Ρñ̤ν
	        ArrayList tableDefine = GetHttpStringValueListTableDefine.get();
			this.m_stringValueInfo = new StringValueInfoComposite(groupDefResult, SWT.NONE, tableDefine);
			gridData = new GridData();
			gridData.horizontalSpan = 1;
			gridData.horizontalAlignment = GridData.FILL;
			gridData.grabExcessHorizontalSpace = true;
			m_stringValueInfo.setLayoutData(gridData);
		}
		
        /*
         * ̵ͭ
         */
        this.confirmValid = new Button(parent, SWT.CHECK);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.confirmValid.setLayoutData(gridData);
        this.confirmValid.setText(Messages.getString("setting.valid.confirmed"));

        // 饤
        Label line = new Label(parent, SWT.SEPARATOR | SWT.HORIZONTAL);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 15;
        line.setLayoutData(gridData);


        // Ŭ
        // åɥ쥤ȤѤ硢ʤȲ̤äѤˤʤޤ
        shell.pack();
        shell.setSize(new Point(550, shell.getSize().y));

        // 
        Display display = shell.getDisplay();
        shell.setLocation((display.getBounds().width - shell.getSize().x) / 2,
                (display.getBounds().height - shell.getSize().y) / 2);

        // ɽ
        MonitorInfo info = null; 
        if(this.monitorId == null){
        	// ξ
        	info = new MonitorInfo();
        }
        else{
        	// ѹξ硢
        	info = new GetHttp().getHttp(this.monitorId, this.m_monitorType);
        }
        this.setInputData(info);
        
    }

    /**
     * Ƥ֤ޤ
     * 
     * @return Ƥݻξ
     */
    public MonitorInfo getInputData() {
        return this.inputData;
    }

    /**
     * ƹܤͤꤷޤ
     * 
     * @param monitor ͤȤѤƻ
     */
    protected void setInputData(MonitorInfo monitor) {

    	// ƻܾ
    	m_monitorBasic.setInputData(monitor);
    	
    	// ƻ
    	m_monitorRule.setInputData(monitor);
    	
        // ƻ HTTPƻ
        MonitorHttpInfo httpInfo = (MonitorHttpInfo)monitor.getCheckInfo();
        if(httpInfo == null){
        	httpInfo = new MonitorHttpInfo();
        }
        if(httpInfo != null){
            if (httpInfo.getRequestUrl() != null) {
                this.m_textRequestUrl.setText(httpInfo.getRequestUrl());
            }
            this.m_comboTimeout.setText(Integer.toString(httpInfo.getTimeout()));
        }
        
        // ξ°
        if (monitor.getNotifyId() != null) {
        	this.m_notifyInfo.setText(monitor.getNotifyId());
        }
        if (monitor.getApplication() != null) {
        	this.m_notifyInfo.setApplication(monitor.getApplication());
        }
        
        // ʹƻξ     
		if(m_monitorType == MonitorTypeConstant.TYPE_NUMERIC){
			
			// Ρñ̤ν٤
	        m_numericValueInfo.setInputData(monitor);
	    	
	        // ּ¹
	        m_checkJobRun.setSelection(YesNoConstant.typeToBoolean(monitor.getJobRun()));
	        
	        // ƽ٤Υּ¹
	        m_jobRun.setInputData(monitor);
	        m_jobRun.setEnabled(YesNoConstant.typeToBoolean(monitor.getJobRun()));
		}
		// ʸƻξ
		else if(m_monitorType == MonitorTypeConstant.TYPE_STRING){
			
			// ٤ηȽ
	        m_stringValueInfo.setInputData(monitor);
		}
        
        // ̵ͭ
        if (monitor.getValid() == ValidConstant.TYPE_VALID) {
            this.confirmValid.setSelection(true);
        }
    }

    /**
     * ͤѤξޤ
     * 
     * @return ͤݻξ
     */
    protected MonitorInfo createInputData() {
    	MonitorInfo info = new MonitorInfo();

    	info.setMonitorTypeId(MonitorConstant.STRING_HTTP);
    	info.setMonitorType(m_monitorType);
    	
    	// ƻܾ
    	validateResult = m_monitorBasic.createInputData(info);
    	if(validateResult != null){
        	return null;
        }
        
        // ƻ ʬ
        validateResult = m_monitorRule.createInputData(info);
        if(validateResult != null){
        	return null;
        }

        // ƻñ
        info.setMonitorBlock(MonitorBlockConstant.TYPE_NODE);
        
        // ƻ HTTPƻ
        MonitorHttpInfo httpInfo = new MonitorHttpInfo();
        httpInfo.setMonitorTypeId(MonitorConstant.STRING_HTTP);
        httpInfo.setMonitorId(info.getMonitorId());
        
        if (this.m_textRequestUrl.getText() != null
                && !"".equals((this.m_textRequestUrl.getText()).trim())) {
        	httpInfo.setRequestUrl(this.m_textRequestUrl.getText());
        } else {
            this.setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.http.1"));
            return null;
        }
        if (this.m_comboTimeout.getText() != null
                && !"".equals((this.m_comboTimeout.getText()).trim())) {
        	
        	try{
        		httpInfo.setTimeout(Integer.valueOf(this.m_comboTimeout.getText().trim()));
        	}
        	catch(NumberFormatException e){
        		this.setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.monitor.41"));
                return null;
        	}
        } else {
            this.setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.monitor.41"));
            return null;
        }
        info.setCheckInfo((MonitorCheckInfo)httpInfo);
        
        // ξ°
        if (this.m_notifyInfo.getText() != null
                && !"".equals((this.m_notifyInfo.getText()).trim())) {
        	info.setNotifyId(m_notifyInfo.getText());
        }
//        else{
//        	this.setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.monitor.9"));
//            return null;
//        }
        if (this.m_notifyInfo.getApplication() != null
                && !"".equals((this.m_notifyInfo.getApplication()).trim())) {
        	info.setApplication(m_notifyInfo.getApplication());
        }
        else{
        	if (this.m_notifyInfo.getText() != null
                    && !"".equals((this.m_notifyInfo.getText()).trim())) {
            	this.setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.monitor.10"));
                return null;
            }
        }
        
        //ʹƻξ     
		if(m_monitorType == MonitorTypeConstant.TYPE_NUMERIC){
			// Ρñ̤ηȽ
	        validateResult = m_numericValueInfo.createInputData(info);
	        if(validateResult != null){
	        	return null;
	        }
	        
	        // ּ¹
	        info.setJobRun(YesNoConstant.booleanToType(m_checkJobRun.getSelection()));
	        
	        // ƽ٤Υּ¹
	        validateResult = m_jobRun.createInputData(info);
	        if(validateResult != null){
	        	return null;
	        }
		}
		// ʸƻξ
		else if(m_monitorType == MonitorTypeConstant.TYPE_STRING){
			
			// Ƚ
	        validateResult = m_stringValueInfo.createInputData(info);
	        if(validateResult != null){
	        	return null;
	        }
	        
	        // ȽIDꤵƤ
	        if(m_stringValueInfo.isNotify()){
	        	if (this.m_notifyInfo.getApplication() == null
	                    || "".equals((this.m_notifyInfo.getApplication()).trim())) {
	            	this.setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.monitor.10"));
	                return null;
	            }
	        }
	        
	        // ּ¹
	        info.setJobRun(YesNoConstant.TYPE_YES);
		}
        
        // ͭ/̵
        if (this.confirmValid.getSelection()) {
        	info.setValid(ValidConstant.TYPE_VALID);
        } else {
        	info.setValid(ValidConstant.TYPE_INVALID);
        }

        return info;
    }

    /**
     * ͥå򤷤ޤ
     * 
     * @return ڷ
     */
    protected ValidateResult validate() {
        // 
        this.inputData = this.createInputData();

        if (this.inputData != null) {
            return super.validate();
        } else {
            return validateResult;
        }
    }

    /**
     * ϣ˥ܥΥƥȤ֤ޤ
     * 
     * @return ϣ˥ܥΥƥ
     */
    protected String getOkButtonText() {
        return Messages.getString("ok");
    }

    /**
     * 󥻥ܥΥƥȤ֤ޤ
     * 
     * @return 󥻥ܥΥƥ
     */
    protected String getCancelButtonText() {
        return Messages.getString("cancel");
    }
    
    /**
     * ̵ͤξꤷޤ
     *  
     */
    private void setValidateResult(String id, String message) {

        this.validateResult = new ValidateResult();
        this.validateResult.setValid(false);
        this.validateResult.setID(id);
        this.validateResult.setMessage(message);
    }
}