/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.bean;

import java.io.Serializable;

/**
 * λ饹
 * 
 * @version 2.0.0
 * @since 1.0.0
 */
public class JobEndStatusInfo implements Serializable, Cloneable {
	private static final long serialVersionUID = 5256607875379422805L;

	/** ֤μ */
    protected int m_type;

    /** ֤νλ */
    protected int m_value;

    /** λϰ() */
    protected int m_startRangeValue;

    /** λϰ(λ) */
    protected int m_endRangeValue;

    /**
     * @return Returns the endRangeValue.
     * @since 1.0.0
     */
    public int getEndRangeValue() {
        return m_endRangeValue;
    }

    /**
     * @param endRangeValue
     *            The endRangeValue to set.
     * @since 1.0.0
     */
    public void setEndRangeValue(int endRangeValue) {
        this.m_endRangeValue = endRangeValue;
    }

    /**
     * @return Returns the startRangeValue.
     * @since 1.0.0
     */
    public int getStartRangeValue() {
        return m_startRangeValue;
    }

    /**
     * @param startRangeValue
     *            The startRangeValue to set.
     * @since 1.0.0
     */
    public void setStartRangeValue(int startRangeValue) {
        this.m_startRangeValue = startRangeValue;
    }

    /**
     * @return Returns the type.
     * @since 1.0.0
     */
    public int getType() {
        return m_type;
    }

    /**
     * @param type
     *            The type to set.
     * @since 1.0.0
     */
    public void setType(int type) {
        this.m_type = type;
    }

    /**
     * @return Returns the value.
     * @since 1.0.0
     */
    public int getValue() {
        return m_value;
    }

    /**
     * @param value
     *            The value to set.
     * @since 1.0.0
     */
    public void setValue(int value) {
        this.m_value = value;
    }
    
    /* (non-Javadoc)
     * @see java.lang.Object#clone()
     * @since 2.0.0
     */
    protected Object clone() {
        try {
            JobEndStatusInfo clone = (JobEndStatusInfo)super.clone();
            
            clone.setEndRangeValue(this.getEndRangeValue());
            clone.setStartRangeValue(this.getStartRangeValue());
            clone.setType(this.getType());
            clone.setValue(this.getValue());
            
            return clone;
        } catch (CloneNotSupportedException e) {
            return null;
        }
    }
}