/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.bean;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;

/**
 * ־󥯥饹
 * 
 * @version 2.0.0
 * @since 1.0.0
 */
public class JobInfo implements Serializable, Cloneable {
	private static final long serialVersionUID = -1710299199569960870L;

	/** ID */
    protected String m_id;

    /** ̾ */
    protected String m_name;

    /** ֥ */
    protected int m_type;

    /** Ԥ */
    protected JobWaitRuleInfo m_waitRule;

    /** ޥ */
    protected JobCommandInfo m_command;
    
    /** ޥ */
    protected JobFileInfo m_file;

    /** λ */
    protected ArrayList m_endStatus;

    /** λ */
    protected ArrayList m_notifications;
    
    /** ѥ᡼ */
    protected ArrayList m_param;

    /** Ͽ */
    protected Date m_createTime;

    /**  */
    protected Date m_updateTime;
    
    /** Ͽ */
    protected String m_createUser;

    /**  */
    protected String m_updateUser;

    /**  */
    protected String m_description;

    /** ե饰 */
    protected boolean m_update;

    /** ƥ֥ */
    protected JobInfo m_parent;

//    /** ҥ֥ */
//    protected List m_children = new ArrayList();

    /**
     * 󥹥ȥ饯
     * 
     * @param id
     * @param name
     * @param type
     * @since 1.0.0
     */
    public JobInfo(String id, String name, int type) {
        setId(id);
        setName(name);
        setType(type);
    }

    /**
     * λ
     * 
     * @return m_endStatus
     * @since 1.0.0
     */
    public ArrayList getEndStatus() {
        return m_endStatus;
    }

    /**
     * λ
     * 
     * @param m_endStatus
     * @since 1.0.0
     */
    public void setEndStatus(ArrayList endStatus) {
        this.m_endStatus = endStatus;
    }

    /**
     * ¹Ƽ
     * 
     * @return m_command
     * @since 1.0.0
     */
    public JobCommandInfo getCommand() {
        return m_command;
    }

    /**
     * ¹
     * 
     * @param m_command
     * @since 1.0.0
     */
    public void setCommand(JobCommandInfo command) {
        this.m_command = command;
    }

    /**
     * եž
     * 
     * @return m_file
     * @since 2.0.0
     */
    public JobFileInfo getFile() {
        return m_file;
    }

    /**
     * եž
     * 
     * @param m_file
     * @since 2.0.0
     */
    public void setFile(JobFileInfo file) {
        this.m_file = file;
    }
    
    /**
     * ID
     * 
     * @return m_id
     * @since 1.0.0
     */
    public String getId() {
        return m_id;
    }

    /**
     * ID
     * 
     * @param id
     * @since 1.0.0
     */
    public void setId(String id) {
        this.m_id = id;
    }

    /**
     * λ
     * 
     * @return m_notifications
     * @since 1.0.0
     */
    public ArrayList getNotifications() {
        return m_notifications;
    }

    /**
     * λ
     * 
     * @param msg
     * @since 1.0.0
     */
    public void setNotifications(ArrayList notifications) {
        this.m_notifications = notifications;
    }

    /**
     * ѥ᡼
     * 
     * @return m_param
     * @since 2.1.0
     */
    public ArrayList getParam() {
        return m_param;
    }

    /**
     * ѥ᡼
     * 
     * @param msg
     * @since 2.1.0
     */
    public void setParam(ArrayList param) {
        this.m_param = param;
    }
    
    /**
     * ̾
     * 
     * @return m_name
     * @since 1.0.0
     */
    public String getName() {
        return m_name;
    }

    /**
     * ̾
     * 
     * @param name
     * @since 1.0.0
     */
    public void setName(String name) {
        this.m_name = name;
    }

    /**
     * Ԥ
     * 
     * @return m_waitRule
     * @since 1.0.0
     */
    public JobWaitRuleInfo getWaitRule() {
        return m_waitRule;
    }

    /**
     * Ԥ
     * 
     * @param m_waitRule
     * @since 1.0.0
     */
    public void setWaitRule(JobWaitRuleInfo waitRule) {
        this.m_waitRule = waitRule;
    }

    /**
     * ֥׼
     * 
     * @return m_type
     * @since 1.0.0
     */
    public int getType() {
        return m_type;
    }

    /**
     * ֥
     * 
     * @param type
     * @since 1.0.0
     */
    public void setType(int type) {
        this.m_type = type;
    }

//    /**
//     * ƥ֥
//     * 
//     * @param parent
//     * @since 1.0.0
//     */
//    public void setParent(JobInfo parent) {
//        this.m_parent = parent;
//    }

//    /**
//     * ƥ֥ȼ
//     * 
//     * @return
//     * @since 1.0.0
//     */
//    public JobInfo getParent() {
//        return m_parent;
//    }

//    /**
//     * ҥ֥ɲ
//     * 
//     * @param child
//     * @since 1.0.0
//     */
//    public void add(JobInfo child) {
//        m_children.add(child);
//        child.setParent(this);
//    }

//    /**
//     * ҥ֥
//     * 
//     * @return
//     * @since 1.0.0
//     */
//    public int size() {
//        return m_children.size();
//    }

//    /**
//     * ҥ֥ȼ
//     * 
//     * @param index
//     * @return
//     * @since 1.0.0
//     */
//    public JobInfo get(int index) {
//        return (JobInfo) m_children.get(index);
//    }

//    /**
//     * ҥ֥
//     * 
//     * @return
//     * @since 1.0.0
//     */
//    public JobInfo[] getChildren() {
//        return (JobInfo[]) m_children.toArray(new JobInfo[m_children.size()]);
//    }

    /**
     * @return Returns the m_createTime.
     * @since 1.0.0
     */
    public Date getCreateTime() {
        return m_createTime;
    }

    /**
     * @param m_createTime
     *            The m_createTime to set.
     * @since 1.0.0
     */
    public void setCreateTime(Date createTime) {
        this.m_createTime = createTime;
    }

    /**
     * @return Returns the m_updateTime.
     * @since 1.0.0
     */
    public Date getUpdateTime() {
        return m_updateTime;
    }

    /**
     * @param m_updateTime
     *            The m_updateTime to set.
     * @since 1.0.0
     */
    public void setUpdateTime(Date updateTime) {
        this.m_updateTime = updateTime;
    }
    
    /**
     * @return Returns the m_createUser.
     * @since 2.0.0
     */
    public String getCreateUser() {
        return m_createUser;
    }

    /**
     * @param m_createUser
     *            The m_createUser to set.
     * @since 2.0.0
     */
    public void setCreateUser(String createUser) {
        this.m_createUser = createUser;
    }

    /**
     * @return Returns the m_updateUser.
     * @since 2.0.0
     */
    public String getUpdateUser() {
        return m_updateUser;
    }

    /**
     * @param m_updateUser
     *            The m_updateUser to set.
     * @since 2.0.0
     */
    public void setUpdateUser(String updateUser) {
        this.m_updateUser = updateUser;
    }

    /**
     * @return Returns the m_description.
     * @since 1.0.0
     */
    public String getDescription() {
        return m_description;
    }

    /**
     * @param m_description
     *            The m_description to set.
     * @since 1.0.0
     */
    public void setDescription(String description) {
        this.m_description = description;
    }

    /**
     * @return Returns the update.
     * @since 1.0.0
     */
    public boolean isUpdate() {
        return m_update;
    }

    /**
     * @param update
     *            The update to set.
     * @since 1.0.0
     */
    public void setUpdate(boolean update) {
        this.m_update = update;
    }
    
    /* (non-Javadoc)
     * @see java.lang.Object#clone()
     * @since 2.0.0
     */
    @SuppressWarnings("unchecked")
	protected Object clone() {
        try {
            JobInfo clone = (JobInfo)super.clone();
            
            if(this.getCommand() instanceof JobCommandInfo)
                clone.setCommand((JobCommandInfo)this.getCommand().clone());
            if(this.getFile() instanceof JobFileInfo)
                clone.setFile((JobFileInfo)this.getFile().clone());
            if(this.getCreateTime() instanceof Date)
                clone.setCreateTime((Date)this.getCreateTime().clone());
            clone.setDescription(this.getDescription());
            clone.setId(this.getId());
            clone.setName(this.getName());
            clone.setType(this.getType());
            clone.setUpdate(this.isUpdate());
            if(this.getUpdateTime() instanceof Date)
                clone.setUpdateTime((Date)this.getUpdateTime().clone());
            if(this.getWaitRule() instanceof JobWaitRuleInfo)
                clone.setWaitRule((JobWaitRuleInfo)this.getWaitRule().clone());
            
            ArrayList cloneList = new ArrayList();
	        if(this.getEndStatus() != null && this.getEndStatus() instanceof ArrayList){
	            for(int i = 0; i < this.getEndStatus().size(); i++){
	                Object source = this.getEndStatus().get(i);
	                if(source != null && source instanceof JobEndStatusInfo){
	                    cloneList.add(((JobEndStatusInfo)source).clone());
	                }
	            }
            }
	        clone.setEndStatus(cloneList);
	        
            cloneList = new ArrayList();
	        if(this.getNotifications() != null && this.getNotifications() instanceof ArrayList){
	            for(int i = 0; i < this.getNotifications().size(); i++){
	                Object source = this.getNotifications().get(i);
	                if(source != null && source instanceof JobNotificationsInfo){
	                    cloneList.add(((JobNotificationsInfo)source).clone());
	                }
	            }
            }
	        clone.setNotifications(cloneList);
	       
            cloneList = new ArrayList();
	        if(this.getParam() != null && this.getParam() instanceof ArrayList){
	            for(int i = 0; i < this.getParam().size(); i++){
	                Object source = this.getParam().get(i);
	                if(source != null && source instanceof JobParameterInfo){
	                    cloneList.add(((JobParameterInfo)source).clone());
	                }
	            }
            }
	        clone.setParam(cloneList);
            
            return clone;
        } catch (CloneNotSupportedException e) {
            return null;
        }
    }
}