/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.bean;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import com.clustercontrol.bean.JobConstant;

/**
 * ֥ĥ꡼إ֥ȥ饹
 * 
 * @version 2.0.0
 * @since 1.0.0
 */
public class JobTreeItem implements Serializable, Cloneable {
	private static final long serialVersionUID = -5749478055659165471L;

	protected JobInfo m_data;

    protected List<JobTreeItem> m_children = new ArrayList<JobTreeItem>();

    protected JobTreeItem m_parent;

    /** ѥѥ졼 */
    public static final String SEPARATOR = ">";

    /**
     * @since 1.0.0
     */
    public JobTreeItem() {

    }

    /**
     * @param data
     * @since 1.0.0
     */
    public JobTreeItem(JobInfo data) {
        setData(data);
    }

    /**
     * ξݻ󥹥󥹤֤ޤ
     * 
     * @param parent
     *            ƤΥ֥
     * @param data
     *            ׾󥪥֥
     * @since 1.0.0
     */
    public JobTreeItem(JobTreeItem parent, JobInfo data) {

        this.setParent(parent);
        this.setData(data);

        if (parent != null) {
            parent.addChildren(this);
        }

        this.m_children = new ArrayList<JobTreeItem>();
    }

    /**
     * @param parent
     * @since 1.0.0
     */
    public void setParent(JobTreeItem parent) {
        this.m_parent = parent;
    }

    /**
     * @return
     * @since 1.0.0
     */
    public JobTreeItem getParent() {
        return m_parent;
    }

    /**
     * @param content
     * @since 1.0.0
     */
    public void setData(JobInfo data) {
        this.m_data = data;
    }

    /**
     * @return
     * @since 1.0.0
     */
    public JobInfo getData() {
        return m_data;
    }

    /**
     * @param child
     * @since 1.0.0
     */
    public void addChildren(JobTreeItem child) {
        m_children.add(child);
        child.setParent(this);
    }

    /**
     * @param child
     * @since 1.0.0
     */
    public void removeChildren(JobTreeItem child) {
        for (int i = 0; i < m_children.size(); i++) {
            if (child.equals(m_children.get(i))) {
                m_children.remove(i);
                break;
            }
        }
    }

    /**
     * @return
     * @since 1.0.0
     */
    public int size() {
        return m_children.size();
    }

    /**
     * @param index
     * @return
     * @since 1.0.0
     */
    public JobTreeItem getChildren(int index) {
        return (JobTreeItem) m_children.get(index);
    }

    /**
     * @return
     * @since 1.0.0
     */
    public JobTreeItem[] getChildren() {
        return (JobTreeItem[]) m_children.toArray(new JobTreeItem[m_children
                .size()]);
    }

    /**
     * ĥ꡼ƥοƻҴطɽѥʸ֤ޤ
     * <p>
     * 
     * getPath()  "⥷ƥ>ܵҴ>WEB"
     * 
     * @param separator
     *            ѥ졼
     * @return ѥʸ
     * @since 1.0.0
     */
    public String getPath() {

        // ȥå("")ξϡʸϤޤ
        if (this.getData().getType() == JobConstant.TYPE_COMPOSITE) {
            return "";
        }

        StringBuffer buffer = new StringBuffer();

        buffer.append(this.getData().getName());

        /*
         * ƵƤӽФ뤳ȤǤʤΤǡ
         */

        JobTreeItem parent = this.getParent();
        while (parent != null
                && parent.getData().getType() != JobConstant.TYPE_COMPOSITE) {

            buffer.insert(0, SEPARATOR);
            buffer.insert(0, parent.getData().getName());
            parent = parent.getParent();
        }

        return buffer.toString();
    }
    
    /* (non-Javadoc)
     * @see java.lang.Object#clone()
     * @since 2.0.0
     */
    public Object clone() {
        try {
            JobTreeItem clone = (JobTreeItem)super.clone();
            
            clone.setData((JobInfo)this.getData().clone());

            clone.m_children = new ArrayList<JobTreeItem>();
	        if(this.m_children != null && this.m_children instanceof ArrayList){
	            for(int i = 0; i < this.m_children.size(); i++){
	                Object source = this.m_children.get(i);
	                if(source != null && source instanceof JobTreeItem){
	                    clone.addChildren((JobTreeItem)((JobTreeItem)source).clone());
	                }
	            }
            }
            
            return clone;
        } catch (CloneNotSupportedException e) {
            return null;
        }
    }
}