/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.util;

import java.util.ArrayList;

import com.clustercontrol.bean.JobConstant;
import com.clustercontrol.jobmanagement.bean.JobInfo;
import com.clustercontrol.jobmanagement.bean.JobTreeItem;
import com.clustercontrol.jobmanagement.bean.JobWaitRuleInfo;

/**
 * ֥桼ƥƥ饹
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class JobUtil {
    private static final String COPY_OF = "Copy Of?";
    
    /**
     * JobTreeItem饹򥳥ԡ
     * 
     * @param original
     * @return ԡJobTreeItem饹
     * @since 2.0.0
     */
    public static JobTreeItem copy(JobTreeItem original) {
        JobTreeItem clone = null;
        if(original != null){
            clone = (JobTreeItem)original.clone();
        }
        
        return clone;
    }
    
    /**
     * JobTreeItem饹򥳥ԡ
     * 
     * @param original
     * @return ԡJobTreeItem饹
     * @since 2.0.0
     */
    public static JobTreeItem copy(JobTreeItem original, JobTreeItem top) {
        JobTreeItem clone = copy(original);
        
        //Ԥ
        deleteWaitRule(clone);
        
        //IDѹ
        changeJobId(clone, top, clone);
        
        return clone;
    }
    
    /**
     * IDѹ
     * 
     * @param item
     * @since 2.0.0
     */
    protected static void changeJobId(JobTreeItem item, JobTreeItem top, JobTreeItem clone) {
        if(item == null || top == null)
            return;
        
        //IDѹ
        JobInfo info = item.getData();
        if(info != null && info instanceof JobInfo){
            int count = 1;
            StringBuffer jobId = new StringBuffer();
            jobId.append(info.getId());
            while(true){              
                if(!findJobId(jobId.toString(), top) && !findJobId(jobId.toString(), clone)){
                    break;
                }
                jobId.delete(0, jobId.length());
                if(count == 1){
                    jobId.append(COPY_OF.replace("?", " "));
                }
                else{
                    jobId.append(COPY_OF.replace("?", " (" + count + ") "));
                }
                jobId.append(info.getId());
                count++;
            }
            info.setId(jobId.toString());
        }
        
        //JobTreeItem
        JobTreeItem[] childrens = item.getChildren();
        for(int i = 0; i < childrens.length; i++){
            changeJobId(childrens[i], top, clone);
        }
    }
    
    /**
     * Ԥ
     * 
     * @param item
     * @since 2.0.0
     */
    protected static void deleteWaitRule(JobTreeItem item) {
        if(item == null)
            return;
        
        JobInfo info = item.getData();
        if(info != null && info instanceof JobInfo){
            //Ԥ
            JobWaitRuleInfo waitRule = info.getWaitRule();
            if(waitRule != null && waitRule instanceof JobWaitRuleInfo){
    	        if(waitRule.getObject() != null && waitRule.getObject() instanceof ArrayList){
    	            waitRule.setObject(new ArrayList());
                }
            }
        }
        
        //JobTreeItem
        JobTreeItem[] childrens = item.getChildren();
        for(int i = 0; i < childrens.length; i++){
            deleteWaitRule(childrens[i]);
        }
    }
    
    /**
     * ID򸡺
     * 
     * @param jobId
     * @param item
     * @return
     * @since 2.0.0
     */
    public static boolean findJobId(String jobId, JobTreeItem item) {
        boolean find = false;
        
        //IDå
        JobInfo info = item.getData();
        if(info != null && info instanceof JobInfo){
            if(jobId.compareTo(info.getId()) == 0){
                find = true;
                return find;
            }
        }
        
        //JobTreeItem
        JobTreeItem[] childrens = item.getChildren();
        for(int i = 0; i < childrens.length; i++){
            find = findJobId(jobId, childrens[i]);
            if(find){
                break;
            }
        }
        
        return find;
    }
    
    /**
     * JobTreeItem饹κǾ̤Υ󥹥󥹤
     * 
     * @param item
     * @return Ǿ̤Υ󥹥
     * @since 2.0.0
     */
    public static JobTreeItem getTopJobTreeItem(JobTreeItem item) {
        if(item == null)
            return null;
        
        while (item.getParent() != null
                && item.getParent().getData().getType() != JobConstant.TYPE_COMPOSITE) {

            item = item.getParent();
        }
        
        return item;
    }
}