/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.util.ArrayList;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import com.clustercontrol.bean.Property;
import com.clustercontrol.jobmanagement.ejb.session.JobController;
import com.clustercontrol.jobmanagement.util.EjbConnectionManager;
import com.clustercontrol.util.PropertyUtil;

/**
 * 饹
 * 
 * Ф饸
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class GetHistory {

	/**
	 * 
	 * 
	 * @return 
	 * @throws AccessException 
	 * @since 1.0.0
	 */
	public ArrayList getHistory() throws IndexOutOfBoundsException, AccessException {
		JobController job = 
			EjbConnectionManager.getConnectionManager().getJobController();
		
		ArrayList list = null;
		try {
            list = job.getHistoryList();
        } catch (RemoteException e) {
			if(e instanceof AccessException){
				// ʤξ
				throw (AccessException) e;
			}
			if(e instanceof ServerException){
				// ٥Ȥɽ礭
				if(e.getCause() instanceof java.lang.IndexOutOfBoundsException){
					throw (IndexOutOfBoundsException)e.getCause();
				}
			}
        } catch (FinderException e) {
        } catch (NamingException e) {
        }

		return list;
	}
	
	/**
	 * 
	 * 
	 * @param condition ե륿
	 * @return 
	 * @throws AccessException 
	 * @since 1.0.0
	 */
	public ArrayList getHistory(Property property) throws IndexOutOfBoundsException, AccessException {
	    PropertyUtil.deletePropertyDefine(property);
	    
		JobController job = 
			EjbConnectionManager.getConnectionManager().getJobController();
		
		ArrayList list = null;
		try {
            list = job.getHistoryList(property);
        } catch (RemoteException e) {
			if(e instanceof AccessException){
				// ʤξ
				throw (AccessException) e;
			}
			if(e instanceof ServerException){
				// ٥Ȥɽ礭
				if(e.getCause() instanceof java.lang.IndexOutOfBoundsException){
					throw (IndexOutOfBoundsException)e.getCause();
				}
			}
        } catch (FinderException e) {
        } catch (NamingException e) {
        }

		return list;
	}
}
