/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.bean.CommonTableTreeItem;
import com.clustercontrol.jobmanagement.ejb.session.JobController;
import com.clustercontrol.jobmanagement.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;

/**
 * 饹
 * 
 * Ф饸
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class GetJobDetail {

	/**
	 * 
	 * 
	 * @return 
	 * @since 1.0.0
	 */
	public CommonTableTreeItem getJobDetail(String sessionId) {
		JobController job = 
			EjbConnectionManager.getConnectionManager().getJobController();
		
		CommonTableTreeItem item = null;
		try {
		    item = job.getDetailList(sessionId);
        } catch (RemoteException e) {
			if(e instanceof AccessException){
				// ʤξ硢顼ɽ
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
        } catch (FinderException e) {
        } catch (NamingException e) {
        }

		return item;
	}
}
