/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.jobmanagement.ejb.session.JobController;
import com.clustercontrol.jobmanagement.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;

/**
 * ͽܺ٥ơ֥饹
 *
 * @version 2.0.0
 * @since 2.0.0
 */
public class GetRunScheduleDetailTableDefine {

	/**
	 * ͽܺ٥ơ֥֤ޤ
	 * 
	 * @return ơ֥
	 */
	public static ArrayList get(Date base) {
		JobController job = 
			EjbConnectionManager.getConnectionManager().getJobController();
		
		ArrayList tableDefine = null;
		try {
			tableDefine = job.getRunScheduleDetailTableDefine(base, Locale.getDefault());
		} catch (RemoteException e) {
			if(e instanceof AccessException){
				// ʤξ硢顼ɽ
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
		}
		return tableDefine;
	}
}
