/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.action;

import java.rmi.AccessException;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.bean.Property;
import com.clustercontrol.jobmanagement.ejb.session.JobController;
import com.clustercontrol.jobmanagement.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;

/**
 * 饹
 * 
 * Фإ֤Τ
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class OperationJob {
	
	/**
	 * 
	 * 
	 * @param info
	 * @since 1.0.0
	 */
	public void operationJob(Property property) {
	    PropertyUtil.deletePropertyDefine(property);
	    
		JobController job = 
			EjbConnectionManager.getConnectionManager().getJobController();
		
		try {
			job.operationJob(property);
		} catch (Exception e) {
			if(e instanceof AccessException){
				// ʤξ硢顼ɽ
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
			if(e.getCause() instanceof NullPointerException){
				// λ̤ϻ顼ɽ
				MessageDialog.openError(null, Messages.getString("message"), Messages.getString("message.job.21"));		
			}
			else if(e.getCause() instanceof IllegalStateException){
				// ¹ԥ顼顼ɽ
				MessageDialog.openError(null, Messages.getString("message"), Messages.getString("message.job.36"));		
			}
			else{
			    // ¹ԥ顼顼ɽ
			    MessageDialog.openError(null, Messages.getString("message"), Messages.getString("message.job.34"));		
			}
		}
	}
}
