/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.jobmanagement.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;

import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.jobmanagement.ejb.entity.JobEndInfoBean;
import com.clustercontrol.jobmanagement.ejb.entity.JobEndInfoPK;
import com.clustercontrol.jobmanagement.util.ConnectionManager;

/**
 * Entity Bean JobEndInfo DAO饹
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class JobEndInfoDAOImpl implements JobEndInfoDAO {
	protected static Log m_log = LogFactory.getLog(JobEndInfoDAOImpl.class);
	
	/* (non Javadoc)
	 * @see com.clustercontrol.jobmanagement.dao.JobCommandInfoDAO#init()
	 */
	public void init() {
	}
	
	/* (non Javadoc)
	 * @see com.clustercontrol.jobmanagement.dao.JobCommandInfoDAO#load(com.clustercontrol.jobmanagement.ejb.entity.JobCommandInfoPK, com.clustercontrol.jobmanagement.ejb.entity.JobCommandInfoBean)
	 */
	public void load(JobEndInfoPK pk, JobEndInfoBean ejb) throws EJBException {
		m_log.debug("load() start : " + pk.toString());
		
		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet res = null;
		
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			
			//SQLʸ
			String sql = "SELECT * FROM cc_job_end_info WHERE session_id = ? AND job_id = ? AND end_status = ?";
			//SQLʸΥå
			stmt = conn.prepareStatement(sql);
			
			stmt.setString(1, pk.getSession_id());
			stmt.setString(2, pk.getJob_id());
			stmt.setInt(3, pk.getEnd_status());
			
			res = stmt.executeQuery();
			
			if (res.next()) {
				//ͤBean˥å
				ejb.setEnd_status(res.getInt("end_status"));
				ejb.setEnd_value(res.getInt("end_value"));
				ejb.setEnd_value_from(res.getInt("end_value_from"));
				ejb.setEnd_value_to(res.getInt("end_value_to"));
				ejb.setJob_id(res.getString("job_id"));
				ejb.setSession_id(res.getString("session_id"));
			} else {
				String msg = "JobEndInfo data is not found.";
				m_log.error("load() error : " + pk.toString() + " SQLException " + msg);
				throw new EJBException(msg);
			}
		} catch (SQLException e) {
			m_log.error("load() error : " + pk.toString() + " SQLException");
			throw new EJBException(e.getMessage());
		} finally {
			//ͥ󡢷̥åȡץڥɥơȥȤΥ
			try {
				if (stmt != null) {
					stmt.close();
				}
				if (res != null) {
					res.close();
				}
				if (conn != null) {
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("load() error : " + pk.toString() + " SQLException " + e1.getMessage());
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("load() end : " + pk.toString());
	}
	
	/* (non Javadoc)
	 * @see com.clustercontrol.jobmanagement.dao.JobEndInfoDAO#store(com.clustercontrol.jobmanagement.ejb.entity.JobEndInfoBean)
	 */
	public void store(JobEndInfoBean ejb) throws EJBException {
		m_log.debug("store() start : " + ejb.getSession_id() + ", " + ejb.getJob_id() + ", " + ejb.getEnd_status());
		
		Connection conn = null;
		PreparedStatement stmt = null;
		
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			//SQLʸ
			StringBuilder sql = new StringBuilder();
			sql.append("UPDATE cc_job_end_info SET ");
			sql.append("end_value = ?, ");
			sql.append("end_value_from = ?, ");
			sql.append("end_value_to = ? ");
			sql.append("WHERE session_id = ? AND ");
			sql.append("job_id = ? AND ");
			sql.append("end_status = ?");
			
			//SQLʸΥå
			stmt = conn.prepareStatement(sql.toString());
			
			stmt.setInt(1, ejb.getEnd_value());
			stmt.setInt(2, ejb.getEnd_value_from());
			stmt.setInt(3, ejb.getEnd_value_to());
			stmt.setString(4, ejb.getSession_id());
			stmt.setString(5, ejb.getJob_id());
			stmt.setInt(6, ejb.getEnd_status());
			
			int row = stmt.executeUpdate();
			
			if (row != 1) {
				String msg = "result row is not 1";
				m_log.error("store() error : " + ejb.getSession_id() + ", "
						+ ejb.getJob_id() + ", " + ejb.getEnd_status() + " SQLException" + msg);
				throw new EJBException(msg);
			}
		} catch (SQLException e) {
			m_log.error("store() error : " + ejb.getSession_id() + ", "
					+ ejb.getJob_id() + ", " + ejb.getEnd_status() + " SQLException");
			throw new EJBException(e.getMessage());
		} finally {
			// ͥ󡢷̥åȡץڥɥơȥȤΥ
			try {
				if (stmt != null) {
					stmt.close();
				}
				if (conn != null) {
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("store() error : " + ejb.getSession_id() + ", "
						+ ejb.getJob_id() + ", " + ejb.getEnd_status() + " SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("store() end : " + ejb.getSession_id() + ", " + ejb.getJob_id() + ", " + ejb.getEnd_status());
	}
	
	/* (non Javadoc)
	 * @see com.clustercontrol.jobmanagement.dao.JobEndInfoDAO#remove(com.clustercontrol.jobmanagement.ejb.entity.JobEndInfoPK)
	 */
	public void remove(JobEndInfoPK pk) throws RemoveException, EJBException {
		m_log.debug("remove() start : " + pk.toString());
		
		Connection conn = null;
		PreparedStatement stmt = null;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			
			//SQLʸ
			String sql = "DELETE FROM cc_job_end_info WHERE session_id = ? AND job_id = ? AND end_status = ?";
			//SQLʸΥå
			stmt = conn.prepareStatement(sql);
			
			stmt.setString(1, pk.getSession_id());
			stmt.setString(2, pk.getJob_id());
			stmt.setInt(3, pk.getEnd_status());
			
			int row = stmt.executeUpdate();
			
			if (row != 1 ) {
				String msg = "result row is not 1";
				m_log.error("remove() error : " + pk.toString() + " SQLException" + msg);
				throw new EJBException(msg);	
			}
		} catch (SQLException e) {
			m_log.error("remove() error : " + pk.toString() + " SQLException");
			throw new EJBException(e.getMessage());
			
		} finally {
			try {
				if(stmt != null){
					stmt.close();
				}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("remove() error : " + pk.toString() + " SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("remove() end : " + pk.toString());
	}
	
	/* (non Javadoc)
	 * @see com.clustercontrol.jobmanagement.dao.JobEndInfoDAO#create(com.clustercontrol.jobmanagement.ejb.entity.JobEndInfoBean)
	 */
	public JobEndInfoPK create(JobEndInfoBean ejb) throws CreateException, EJBException {
		m_log.debug("create() start : " + ejb.getSession_id() + ", " + ejb.getJob_id() + ", " + ejb.getEnd_status());
		
		Connection conn = null;
		PreparedStatement stmt = null;
		JobEndInfoPK pk;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			//SQLʸ
			StringBuilder sql = new StringBuilder();
			sql.append("INSERT INTO cc_job_end_info (");
			sql.append("session_id, ");
			sql.append("job_id, ");
			sql.append("end_status, ");
			sql.append("end_value, ");
			sql.append("end_value_from, ");
			sql.append("end_value_to) ");
			sql.append("VALUES (?,?,?,?,?,?)");
			
			//SQLʸΥå
			stmt = conn.prepareStatement(sql.toString());
			
			stmt.setString(1, ejb.getSession_id());
			stmt.setString(2, ejb.getJob_id());
			stmt.setInt(3, ejb.getEnd_status());
			stmt.setInt(4, ejb.getEnd_value());
			stmt.setInt(5, ejb.getEnd_value_from());
			stmt.setInt(6, ejb.getEnd_value_to());
			
			int row =	stmt.executeUpdate();
			pk = new JobEndInfoPK(
					ejb.getSession_id(),
					ejb.getJob_id(),
					ejb.getEnd_status());
			
			if (row != 1) {
				String msg = "result row is not 1";
				m_log.error("create() error : " + ejb.getSession_id() + ", " + ejb.getJob_id() + ", " + ejb.getEnd_status() + " SQLException");
				throw new EJBException(msg);
			}
		} catch (SQLException e) {
			if(e.getSQLState().equals("23505")){
				m_log.error("create() error : " + ejb.getSession_id() + ", " + ejb.getJob_id() + ", " + ejb.getEnd_status() + " SQLException" + "DuplicateKeyException ");
				throw new DuplicateKeyException(e.getMessage());
			}
			throw new CreateException(e.getMessage());
		}finally{
			try {
				if(stmt != null){
					stmt.close();
				}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("create() error : " + ejb.getSession_id() + ", " + ejb.getJob_id() + ", " + ejb.getEnd_status() + " SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("create() end : " + ejb.getSession_id() + ", " + ejb.getJob_id() + ", " + ejb.getEnd_status());
		return pk;
	}
	
	/* (non Javadoc)
	 * @see com.clustercontrol.jobmanagement.dao.JobEndInfoDAO#findAll()
	 */
	public Collection findAll() throws FinderException {
		m_log.debug("findAll() start : ");
		
		ArrayList<JobEndInfoPK> ret = new ArrayList<JobEndInfoPK>();
		
		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet res = null;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();	
			//SQLʸ
			String sql = "SELECT * FROM cc_job_end_info";
			//SQLʸΥå
			stmt = conn.prepareStatement(sql);
			res = stmt.executeQuery();
			
			while(res.next()) {
				JobEndInfoPK pk= new JobEndInfoPK(
						res.getString("session_id"),
						res.getString("job_id"),
						res.getInt("end_status")
				);
				ret.add(pk);
			}
			
		} catch (SQLException e) {
			m_log.error("findAll() error :  SQLException");
			throw new EJBException(e.getMessage());
		}  finally{
			try {
				if(stmt != null){
					stmt.close();}
				if(res != null){
					res.close();}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("findAll() error :  SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("findAll() end : ");
		return ret;
	}
	
	/* (non Javadoc)
	 * @see com.clustercontrol.jobmanagement.dao.JobEndInfoDAO#findByPrimaryKey(com.clustercontrol.jobmanagement.ejb.entity.JobEndInfoPK)
	 */
	public JobEndInfoPK findByPrimaryKey(JobEndInfoPK pk) throws FinderException {
		m_log.debug("findByPrimaryKey() start : " + pk.toString());
		
		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet res = null;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			
			//SQLʸ
			String sql = "SELECT * FROM cc_job_end_info WHERE session_id = ? AND job_id = ? AND end_status = ?";
			//SQLʸΥå
			stmt = conn.prepareStatement(sql);
			
			stmt.setString(1, pk.getSession_id());
			stmt.setString(2, pk.getJob_id());
			stmt.setInt(3, pk.getEnd_status());
			
			res = stmt.executeQuery();
			
			if (res.next()) {
				return pk;
			} else {
				String msg = "id " + pk.toString() + " not found.";
				throw new FinderException(msg);
			}
		} catch (SQLException e) {
			m_log.error("find() error : " + pk.toString() + " SQLException");
			throw new EJBException(e.getMessage());
		}  finally{
			try {
				if(stmt != null){
					stmt.close();}
				if(res != null){
					res.close();}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("find() error : " + pk.toString() + " SQLException");
				throw new EJBException(e1.getMessage());
			}
			m_log.debug("findByPrimaryKey() end : " + pk.toString());
		}
	}
	
	/* (non Javadoc)
	 * @see com.clustercontrol.jobmanagement.dao.JobEndInfoDAO#findBySessionIdAndJobId(java.lang.String, java.lang.String)
	 */
	public Collection findBySessionIdAndJobId(String session_id, String job_id) throws FinderException {
		m_log.debug("findBySessionIdAndJobId() start : " + session_id + ", " + job_id);
		
		ArrayList<JobEndInfoPK> ret = new ArrayList<JobEndInfoPK>();
		
		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet res = null;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();	
			//SQLʸ
			String sql = "SELECT * FROM cc_job_end_info WHERE session_id = ? AND job_id = ?";
			//SQLʸΥå
			stmt = conn.prepareStatement(sql);
			
			stmt.setString(1, session_id);
			stmt.setString(2, job_id);
			
			res = stmt.executeQuery();
			
			while(res.next()) {
				JobEndInfoPK pk= new JobEndInfoPK(
						res.getString("session_id"),
						res.getString("job_id"),
						res.getInt("end_status")
				);
				ret.add(pk);
			}
			
		} catch (SQLException e) {
			m_log.error("findBySessionIdAndJobId() error : " + session_id + ", " + job_id + " SQLException");
			throw new EJBException(e.getMessage());
		}  finally{
			try {
				if(stmt != null){
					stmt.close();}
				if(res != null){
					res.close();}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("findBySessionIdAndJobId() error : " + session_id + ", " + job_id + " SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("findBySessionIdAndJobId() end : " + session_id + ", " + job_id);
		return ret;
	}
	
	/**
	 * 
	 * 
	 * @version 2.1.0
	 * @since 2.1.0
	 * 
	 * @param sessionId
	 * @param jobs
	 * @throws CreateException
	 */
	public void makeSession(String sessionId, Collection jobs) throws CreateException{
		m_log.debug("makeSession() start : " + sessionId );
		
		Connection conn = null;
		Connection connMaster = null;
		PreparedStatement stmt = null;
		PreparedStatement stmtMaster = null;
		String jobId = null;
		
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			connMaster = ConnectionManager.getConnectionManager().getConnection();
			
			//SQLʸ(INSERT)
			StringBuilder sql = new StringBuilder();
			sql.append("INSERT INTO cc_job_end_info (");
			sql.append("session_id, ");
			sql.append("job_id, ");
			sql.append("end_status, ");
			sql.append("end_value, ");
			sql.append("end_value_from, ");
			sql.append("end_value_to) ");
			sql.append("VALUES (?,?,?,?,?,?)");
			
			//SQLʸΥå(INSERT)
			stmt = conn.prepareStatement(sql.toString());
			stmt.setString(1, sessionId);
			
			//SQLʸ(ޥ)
			String sqlMaster = "SELECT * FROM cc_job_end_mst WHERE job_id = ?";
			//SQLSQLʸΥå(ޥ)
			stmtMaster = connMaster.prepareStatement(sqlMaster);
			
			Iterator it = jobs.iterator();
			while(it.hasNext()){
				//ID
				Hashtable ht = (Hashtable)it.next();
				jobId = (String)ht.get("jobId");
				
				//SQL¹(ޥ)
				stmtMaster.setString(1, jobId);
				ResultSet resMaster = stmtMaster.executeQuery();

				while(resMaster.next()){
					//SQLʸΥå(INSERT)
					stmt.setString(2, jobId);
					stmt.setInt(3, resMaster.getInt("end_status"));
					stmt.setInt(4, resMaster.getInt("end_value"));
					stmt.setInt(5, resMaster.getInt("end_value_from"));
					stmt.setInt(6, resMaster.getInt("end_value_to"));
					
					//INSERT¹
					int row =	stmt.executeUpdate();
					if (row != 1) {
						String msg = "result row is not 1";
						m_log.error("makeSession() error : " + sessionId + ", " + jobId + " SQLException");
						throw new EJBException(msg);
					}
				}
				resMaster.close();
			}
		}catch (SQLException e) {
			if(e.getSQLState().equals("23505")){
				m_log.error("makeSession() error : " + sessionId + ", " + jobId + " SQLException" + "DuplicateKeyException ");
				throw new DuplicateKeyException(e.getMessage());
			}
			throw new CreateException(e.getMessage());
		}finally{
			try {
				if(stmt != null){
					stmt.close();
				}
				if(stmtMaster != null){
					stmtMaster.close();
				}
				if(conn != null){
					conn.close();
				}
				if(connMaster != null){
					connMaster.close();
				}
			} catch (SQLException e1) {
				m_log.error("makeSession() error : " + sessionId + ", " + jobId + " SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("makeSession() end : " + sessionId );
	}
}
