/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.jobmanagement.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;

import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.jobmanagement.ejb.entity.JobStartJobMasterBean;
import com.clustercontrol.jobmanagement.ejb.entity.JobStartJobMasterPK;
import com.clustercontrol.jobmanagement.util.ConnectionManager;

/**
 * Entity Bean JobStartJobMaster DAO饹
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class JobStartJobMasterDAOImpl implements JobStartJobMasterDAO {
	protected static Log m_log = LogFactory.getLog(JobStartJobMasterDAOImpl.class);
	
	/* (non Javadoc)
	 * @see com.clustercontrol.jobmanagement.dao.JobCommandInfoDAO#init()
	 */
	public void init() {
	}
	
	/* (non Javadoc)
	 * @see com.clustercontrol.jobmanagement.dao.JobCommandInfoDAO#load(com.clustercontrol.jobmanagement.ejb.entity.JobCommandInfoPK, com.clustercontrol.jobmanagement.ejb.entity.JobCommandInfoBean)
	 */
	public void load(JobStartJobMasterPK pk, JobStartJobMasterBean ejb) throws EJBException {
		m_log.debug("load() start : " + pk.toString());
		
		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet res = null;
		
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			
			//SQLʸ
			String sql = "SELECT * FROM cc_job_start_job_mst WHERE job_id = ? AND target_job_id = ? AND target_job_type = ? AND target_job_end_value = ?";
			//SQLʸΥå
			stmt = conn.prepareStatement(sql);
			
			stmt.setString(1, pk.getJob_id());
			stmt.setString(2, pk.getTarget_job_id());
			stmt.setInt(3, pk.getTarget_job_type());
			stmt.setInt(4, pk.getTarget_job_end_value());
			
			res = stmt.executeQuery();
			
			if (res.next()) {
				//ͤBean˥å
				ejb.setJob_id(res.getString("job_id"));
				ejb.setTarget_job_end_value(res.getInt("target_job_end_value"));
				ejb.setTarget_job_type(res.getInt("target_job_type"));
				ejb.setTarget_job_id(res.getString("target_job_id"));
			} else {
				String msg = "JobStartJobMaster data is not found.";
				m_log.error("load() error : " + pk.toString() + " SQLException " + msg);
				throw new EJBException(msg);
			}
		} catch (SQLException e) {
			m_log.error("load() error : " + pk.toString() + " SQLException");
			throw new EJBException(e.getMessage());
		} finally {
			//ͥ󡢷̥åȡץڥɥơȥȤΥ
			try {
				if (stmt != null) {
					stmt.close();
				}
				if (res != null) {
					res.close();
				}
				if (conn != null) {
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("load() error : " + pk.toString() + " SQLException " + e1.getMessage());
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("load() end : " + pk.toString());
	}
	
	/* (non Javadoc)
	 * @see com.clustercontrol.jobmanagement.dao.JobStartJobMasterDAO#store(com.clustercontrol.jobmanagement.ejb.entity.JobStartJobMasterBean)
	 */
	public void store(JobStartJobMasterBean ejb) throws EJBException {
		m_log.debug("store() start : " + ejb.getJob_id() + ", " + ejb.getTarget_job_id() + ", " + ejb.getTarget_job_type() + ", " + ejb.getTarget_job_end_value());
		
		m_log.debug("store() end : " + ejb.getJob_id() + ", " + ejb.getTarget_job_id() + ", " + ejb.getTarget_job_type() + ", " + ejb.getTarget_job_end_value());
	}
	
	/* (non Javadoc)
	 * @see com.clustercontrol.jobmanagement.dao.JobStartJobMasterDAO#remove(com.clustercontrol.jobmanagement.ejb.entity.JobStartJobMasterPK)
	 */
	public void remove(JobStartJobMasterPK pk) throws RemoveException, EJBException {
		m_log.debug("remove() start : " + pk.toString());
		
		Connection conn = null;
		PreparedStatement stmt = null;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			
			//SQLʸ
			String sql = "DELETE FROM cc_job_start_job_mst WHERE job_id = ? AND target_job_id = ? AND target_job_type = ? AND target_job_end_value = ?";
			//SQLʸΥå
			stmt = conn.prepareStatement(sql);
			
			stmt.setString(1, pk.getJob_id());
			stmt.setString(2, pk.getTarget_job_id());
			stmt.setInt(3, pk.getTarget_job_type());
			stmt.setInt(4, pk.getTarget_job_end_value());
			
			int row = stmt.executeUpdate();
			
			if (row != 1 ) {
				String msg = "result row is not 1";
				m_log.error("remove() error : " + pk.toString() + " SQLException" + msg);
				throw new EJBException(msg);	
			}
		} catch (SQLException e) {
			m_log.error("remove() error : " + pk.toString() + " SQLException");
			throw new EJBException(e.getMessage());
			
		} finally {
			try {
				if(stmt != null){
					stmt.close();
				}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("remove() error : " + pk.toString() + " SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("remove() end : " + pk.toString());
	}
	
	/* (non Javadoc)
	 * @see com.clustercontrol.jobmanagement.dao.JobStartJobMasterDAO#create(com.clustercontrol.jobmanagement.ejb.entity.JobStartJobMasterBean)
	 */
	public JobStartJobMasterPK create(JobStartJobMasterBean ejb) throws CreateException, EJBException {
		m_log.debug("create() start : " + ejb.getJob_id() + ", " + ejb.getTarget_job_id() + ", " + ejb.getTarget_job_type() + ", " + ejb.getTarget_job_end_value());
		
		Connection conn = null;
		PreparedStatement stmt = null;
		JobStartJobMasterPK pk;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			//SQLʸ
			StringBuilder sql = new StringBuilder();
			sql.append("INSERT INTO cc_job_start_job_mst (");
			sql.append("job_id, ");
			sql.append("target_job_id, ");
			sql.append("target_job_type, ");
			sql.append("target_job_end_value) ");
			sql.append("VALUES (?,?,?,?)");
			
			//SQLʸΥå
			stmt = conn.prepareStatement(sql.toString());
			
			stmt.setString(1, ejb.getJob_id());
			stmt.setString(2, ejb.getTarget_job_id());
			stmt.setInt(3, ejb.getTarget_job_type());
			stmt.setInt(4, ejb.getTarget_job_end_value());
			
			int row =	stmt.executeUpdate();
			pk = new JobStartJobMasterPK(
					ejb.getJob_id(),
					ejb.getTarget_job_id(),
					ejb.getTarget_job_type(), 
					ejb.getTarget_job_end_value());
			
			if (row != 1) {
				String msg = "result row is not 1";
				m_log.error("create() error : " + ejb.getJob_id() + ", "
						+ ejb.getTarget_job_id() + ", " + ejb.getTarget_job_type() + ", " + ejb.getTarget_job_end_value() + " SQLException");
				throw new EJBException(msg);
			}
		} catch (SQLException e) {
			if(e.getSQLState().equals("23505")){
				m_log.error("create() error : " + ejb.getJob_id() + ", "
						+ ejb.getTarget_job_id() + ", " + ejb.getTarget_job_type() + ", " + ejb.getTarget_job_end_value() + " SQLException" + "DuplicateKeyException ");
				throw new DuplicateKeyException(e.getMessage());
			}
			throw new CreateException(e.getMessage());
		}finally{
			try {
				if(stmt != null){
					stmt.close();
				}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("create() error : " + ejb.getJob_id() + ", "
						+ ejb.getTarget_job_id() + ", " + ejb.getTarget_job_type() + ", " + ejb.getTarget_job_end_value() + " SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("create() end : " + ejb.getJob_id() + ", "
				+ ejb.getTarget_job_id() + ", " + ejb.getTarget_job_type() + ", " + ejb.getTarget_job_end_value());
		return pk;
	}
	
	/* (non Javadoc)
	 * @see com.clustercontrol.jobmanagement.dao.JobStartJobMasterDAO#findAll()
	 */
	public Collection findAll() throws FinderException {
		m_log.debug("findAll() start : ");
		
		ArrayList<JobStartJobMasterPK> ret = new ArrayList<JobStartJobMasterPK>();
		
		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet res = null;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();	
			//SQLʸ
			String sql = "SELECT * FROM cc_job_start_job_mst";
			//SQLʸΥå
			stmt = conn.prepareStatement(sql);
			res = stmt.executeQuery();
			
			while(res.next()) {
				JobStartJobMasterPK pk= new JobStartJobMasterPK(
						res.getString("job_id"),
						res.getString("target_job_id"),
						res.getInt("target_job_type"), 
						res.getInt("target_job_end_value")
				);
				ret.add(pk);
			}
			
		} catch (SQLException e) {
			m_log.error("findAll() error :  SQLException");
			throw new EJBException(e.getMessage());
		}  finally{
			try {
				if(stmt != null){
					stmt.close();}
				if(res != null){
					res.close();}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("findAll() error :  SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("findAll() end : ");
		return ret;
	}
	
	/* (non Javadoc)
	 * @see com.clustercontrol.jobmanagement.dao.JobStartJobMasterDAO#findByPrimaryKey(com.clustercontrol.jobmanagement.ejb.entity.JobStartJobMasterPK)
	 */
	public JobStartJobMasterPK findByPrimaryKey(JobStartJobMasterPK pk) throws FinderException {
		m_log.debug("findByPrimaryKey() start : " + pk.toString());
		
		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet res = null;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			
			//SQLʸ
			String sql = "SELECT * FROM cc_job_start_job_mst WHERE job_id = ? AND target_job_id = ? AND target_job_type = ? AND target_job_end_value = ?";
			//SQLʸΥå
			stmt = conn.prepareStatement(sql);
			
			stmt.setString(1, pk.getJob_id());
			stmt.setString(2, pk.getTarget_job_id());
			stmt.setInt(3, pk.getTarget_job_type());
			stmt.setInt(4, pk.getTarget_job_end_value());
			
			res = stmt.executeQuery();
			
			if (res.next()) {
				return pk;
			} else {
				String msg = "id " + pk.toString() + " not found.";
				throw new FinderException(msg);
			}
		} catch (SQLException e) {
			m_log.error("find() error : " + pk.toString() + " SQLException");
			throw new EJBException(e.getMessage());
		}  finally{
			try {
				if(stmt != null){
					stmt.close();}
				if(res != null){
					res.close();}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("find() error : " + pk.toString() + " SQLException");
				throw new EJBException(e1.getMessage());
			}
			m_log.debug("findByPrimaryKey() end : " + pk.toString());
		}
	}
	
	/* (non Javadoc)
	 * @see com.clustercontrol.jobmanagement.dao.JobStartJobMasterDAO#findByJobId(java.lang.String)
	 */
	public Collection findByJobId(String job_id) throws FinderException {
		m_log.debug("findByJobId() start : " + job_id);
		
		ArrayList<JobStartJobMasterPK> ret = new ArrayList<JobStartJobMasterPK>();
		
		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet res = null;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();	
			//SQLʸ
			String sql = "SELECT * FROM cc_job_start_job_mst WHERE job_id = ?";
			//SQLʸΥå
			stmt = conn.prepareStatement(sql);
			
			stmt.setString(1, job_id);
			
			res = stmt.executeQuery();
			
			while(res.next()) {
				JobStartJobMasterPK pk= new JobStartJobMasterPK(
						res.getString("job_id"),
						res.getString("target_job_id"),
						res.getInt("target_job_type"), 
						res.getInt("target_job_end_value")
				);
				ret.add(pk);
			}
			
		} catch (SQLException e) {
			m_log.error("findByJobId() error : " + job_id + " SQLException");
			throw new EJBException(e.getMessage());
		}  finally{
			try {
				if(stmt != null){
					stmt.close();}
				if(res != null){
					res.close();}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("findByJobId() error : " + job_id + " SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("findByJobId() end : " + job_id);
		return ret;
	}
}
