/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.ejb.entity;

import java.util.Collection;

import javax.ejb.FinderException;
import javax.naming.NamingException;

/**
 * 
 * @ejb.bean name="JobCommandMaster"
 *           jndi-name="JobCommandMaster"
 *           type="BMP"
 * 
 * @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 *           
 * @ejb.dao class="com.clustercontrol.jobmanagement.dao.JobCommandMasterDAO"
 * impl-class="com.clustercontrol.jobmanagement.dao.JobCommandMasterDAOImpl"
 * 
 * @ejb.permission
 *     unchecked="true"
 *     
 **/
public abstract class JobCommandMasterBean implements javax.ejb.EntityBean {
	protected String job_id;
	protected String facility_id;
	protected Integer process_mode;
	protected String start_command;
	protected String stop_command;
	protected String effective_user;
	protected Integer error_end_flg;
	protected Integer error_end_value;
	protected String argument_job_id;
	protected String argument;
	
	/**
	 *
	 * <!-- begin-user-doc -->
	 * The  ejbCreate method.
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.create-method 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public JobCommandMasterPK ejbCreate(
			String job_id, 
			String facility_id, 
			Integer process_mode, 
			String start_command, 
			String stop_command, 
			String effective_user, 
			Integer error_end_flg, 
			Integer error_end_value, 
			String argument_job_id, 
			String argument
	) throws javax.ejb.CreateException {
		this.job_id = job_id;
		this.facility_id = facility_id;
		this.process_mode = process_mode;
		this.start_command = start_command;
		this.stop_command = stop_command;
		this.effective_user = effective_user;
		this.error_end_flg = error_end_flg;
		this.error_end_value = error_end_value;
		this.argument_job_id = argument_job_id;
		this.argument = argument;
		return null;
	}
	
	/**
	 * <!-- begin-user-doc -->
	 * The container invokes this method immediately after it calls ejbCreate.
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void ejbPostCreate() throws javax.ejb.CreateException {
		// begin-user-code
		// end-user-code
	}
	
	public Collection ejbFindAll() throws FinderException {
		return null;
	}
	
	public JobCommandMasterPK ejbFindByPrimaryKey(JobCommandMasterPK pk) throws FinderException {
		return null;
	}
	
	/**
	 * @return the job_id
	 * @ejb.persistent-field 
	 * @ejb.pk-field 
	 * @ejb.interface-method
	 */
	public java.lang.String getJob_id() {
		return job_id;
	}
	
	/**
	 * @param java.lang.String the new job_id value
	 * @ejb.interface-method
	 */
	public void setJob_id(java.lang.String job_id) {
		this.job_id = job_id;
	}
	
	/**
	 * @return the facility_id
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public java.lang.String getFacility_id() {
		return facility_id;
	}
	
	/**
	 * @param java.lang.String the new facility_id value
	 * @ejb.interface-method
	 */
	public void setFacility_id(java.lang.String facility_id) {
		this.facility_id = facility_id;
	}
	
	/**
	 * @return the process_mode
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public java.lang.Integer getProcess_mode() {
		return process_mode;
	}
	
	/**
	 * @param java.lang.Integer the new process_mode value
	 * @ejb.interface-method
	 */
	public void setProcess_mode(java.lang.Integer process_mode) {
		this.process_mode = process_mode;
	}
	
	/**
	 * @return the start_command
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public java.lang.String getStart_command() {
		return start_command;
	}
	
	/**
	 * @param java.lang.String the new start_command value
	 * @ejb.interface-method
	 */
	public void setStart_command(java.lang.String start_command) {
		this.start_command = start_command;
	}
	
	/**
	 * @return the stop_command
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public java.lang.String getStop_command() {
		return stop_command;
	}
	
	/**
	 * @param java.lang.String the new stop_command value
	 * @ejb.interface-method
	 */
	public void setStop_command(java.lang.String stop_command) {
		this.stop_command = stop_command;
	}
	
	/**
	 * @return the effective_user
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public java.lang.String getEffective_user() {
		return effective_user;
	}
	
	/**
	 * @param java.lang.String the new effective_user value
	 * @ejb.interface-method
	 */
	public void setEffective_user(java.lang.String effective_user) {
		this.effective_user = effective_user;
	}
	
	/**
	 * @return the error_end_flg
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public java.lang.Integer getError_end_flg() {
		return error_end_flg;
	}
	
	/**
	 * @param java.lang.Integer the new error_end_flg value
	 * @ejb.interface-method
	 */
	public void setError_end_flg(java.lang.Integer error_end_flg) {
		this.error_end_flg = error_end_flg;
	}
	
	/**
	 * @return the error_end_value
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public java.lang.Integer getError_end_value() {
		return error_end_value;
	}
	
	/**
	 * @param java.lang.Integer the new error_end_value value
	 * @ejb.interface-method
	 */
	public void setError_end_value(java.lang.Integer error_end_value) {
		this.error_end_value = error_end_value;
	}
	
	/**
	 * @return the argument_job_id
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public java.lang.String getArgument_job_id() {
		return argument_job_id;
	}
	
	/**
	 * @param java.lang.String the new argument_job_id value
	 * @ejb.interface-method
	 */
	public void setArgument_job_id(java.lang.String argument_job_id){
		this.argument_job_id = argument_job_id;
	}
	
	/**
	 * @return the argument
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public java.lang.String getArgument() {
		return argument;
	}
	
	/**
	 * @param java.lang.String the new argument value
	 * @ejb.interface-method
	 */
	public void setArgument(java.lang.String argument) {
		this.argument = argument;
	}
	
	//	==========================================
	//	 CMR fields
	//	==========================================
	/**
	 * @ejb.interface-method view-type="local"
	 */
	public JobMasterLocal getJobMaster() {
		JobMasterLocal jobMaster = null;
		try {
			jobMaster = JobMasterUtil.getLocalHome().findByPrimaryKey(new JobMasterPK(getJob_id()));
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		return jobMaster;
	}
}
