/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.ejb.entity;

import java.util.Collection;
import java.util.Date;

import javax.ejb.FinderException;
import javax.naming.NamingException;

/**
 * 
 * @ejb.bean name="JobMaster"
 *           jndi-name="JobMaster"
 *           type="BMP"
 *           
 * @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 * 
 * @ejb.dao class="com.clustercontrol.jobmanagement.dao.JobMasterDAO"
 * impl-class="com.clustercontrol.jobmanagement.dao.JobMasterDAOImpl"
 * 
 * @ejb.permission
 *     unchecked="true"
 *     
 **/
public abstract class JobMasterBean implements javax.ejb.EntityBean {
	protected String job_id;
	protected String job_name;
	protected String description;
	protected Integer job_type;
	protected Date reg_date;
	protected Date update_date;
	protected String reg_user;
	protected String update_user;
	
	/**
	 *
	 * <!-- begin-user-doc -->
	 * The  ejbCreate method.
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.create-method 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public JobMasterPK ejbCreate(
			String job_id, 
			String job_name, 
			String description, 
			Integer job_type, 
			Date reg_date, 
			Date update_date, 
			String reg_user, 
			String update_user
			) throws javax.ejb.CreateException {
		this.job_id = job_id;
		this.job_name = job_name;
		this.description = description;
		this.job_type = job_type;
		this.reg_date = reg_date;
		this.update_date = update_date;
		this.reg_user = reg_user;
		this.update_user = update_user;
		return null;
	}

    /**
     * <!-- begin-user-doc -->
     * The container invokes this method immediately after it calls ejbCreate.
     * <!-- end-user-doc -->
     * 
     * @generated
     */
    public void ejbPostCreate() throws javax.ejb.CreateException {
        // begin-user-code
        // end-user-code
    }
    
	public Collection ejbFindAll() throws FinderException {
		return null;
	}
	
	public JobMasterPK ejbFindByPrimaryKey(JobMasterPK pk) throws FinderException {
		return null;
	}

	/**
	 * @return the job_id
	 * @ejb.persistent-field 
	 * @ejb.pk-field 
	 * @ejb.interface-method
	 */
	public java.lang.String getJob_id() {
		return job_id;
	}
	
	/**
	 * @param java.lang.String the new job_id value
	 * @ejb.interface-method
	 */
	public void setJob_id(java.lang.String job_id) {
		this.job_id = job_id;
	}
	
	/**
	 * @return the job_name
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public java.lang.String getJob_name() {
		return job_name;
	}
	
	/**
	 * @param java.lang.String the new job_name value
	 * @ejb.interface-method
	 */
	public void setJob_name(java.lang.String job_name) {
		this.job_name = job_name;
	}
	
	/**
	 * @return the description
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public java.lang.String getDescription() {
		return description;
	}
	
	/**
	 * @param java.lang.String the new description value
	 * @ejb.interface-method
	 */
	public void setDescription(java.lang.String description) {
		this.description = description;
	}
	
	/**
	 * @return the job_type
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public java.lang.Integer getJob_type() {
		return job_type;
	}
	
	/**
	 * @param java.lang.Integer the new job_type value
	 * @ejb.interface-method
	 */
	public void setJob_type(java.lang.Integer job_type) {
		this.job_type = job_type;
	}
	
	/**
	 * @return the reg_date
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public java.util.Date getReg_date() {
		return reg_date;
	}
	
	/**
	 * @param java.util.Date the new reg_date value
	 * @ejb.interface-method
	 */
	public void setReg_date(java.util.Date reg_date) {
		this.reg_date = reg_date;
	}
	
	/**
	 * @return the update_date
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public java.util.Date getUpdate_date() {
		return update_date;
	}
	
	/**
	 * @param java.util.Date the new update_date value
	 * @ejb.interface-method
	 */
	public void setUpdate_date(java.util.Date update_date) {
		this.update_date = update_date;
	}
	
	/**
	 * @return the reg_user
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public java.lang.String getReg_user() {
		return reg_user;
	}
	
	/**
	 * @param java.lang.String the new reg_user value
	 * @ejb.interface-method
	 */
	public void setReg_user(java.lang.String reg_user) {
		this.reg_user = reg_user;
	}
	
	/**
	 * @return the update_user
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public java.lang.String getUpdate_user() {
		return update_user;
	}
	
	/**
	 * @param java.lang.String the new update_user value
	 * @ejb.interface-method
	 */
	public void setUpdate_user(java.lang.String update_user) {
		this.update_user = update_user;
	}

	//	==========================================
	//	 CMR fields
	//	==========================================
    /**
     * @ejb.interface-method view-type="local"
     */
    public JobCommandMasterLocal getJobCommandMaster() {
    	JobCommandMasterLocal jobCommandMaster = null;
		try {
			jobCommandMaster = JobCommandMasterUtil.getLocalHome().findByPrimaryKey(new JobCommandMasterPK(getJob_id()));
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		return jobCommandMaster;
	}
    
    /**
     * @ejb.interface-method view-type="local"
     */
    public Collection getJobEndMaster() {
    	Collection collection = null;
		try {
			collection = JobEndMasterUtil.getLocalHome().findByJobId(getJob_id());
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		return collection;
	}
    
    /**
     * @ejb.interface-method view-type="local"
     */
    public Collection getJobNoticeMaster() {
    	Collection collection = null;
		try {
			collection = JobNoticeMasterUtil.getLocalHome().findByJobId(getJob_id());
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		return collection;
	}

    /**
     * @ejb.interface-method view-type="local"
     */
    public JobStartMasterLocal getJobStartMaster() {
    	JobStartMasterLocal jobStartMaster = null;
		try {
			jobStartMaster = JobStartMasterUtil.getLocalHome().findByPrimaryKey(new JobStartMasterPK(getJob_id()));
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		return jobStartMaster;
	}

    /**
     * @ejb.interface-method view-type="local"
     * 
     */
    public JobRelationMasterLocal getJobRelationMaster() {
    	JobRelationMasterLocal jobRelationMaster = null;
		try {
			jobRelationMaster = JobRelationMasterUtil.getLocalHome().findByJobId(getJob_id());
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		return jobRelationMaster;
	}

    /**
     * @ejb.interface-method view-type="local"
     */
    public JobFileMasterLocal getJobFileMaster() {
    	JobFileMasterLocal jobFileMaster = null;
		try {
			jobFileMaster = JobFileMasterUtil.getLocalHome().findByPrimaryKey(new JobFileMasterPK(getJob_id()));
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		return jobFileMaster;
	}
    
    /**
     * @ejb.interface-method view-type="local"
     */
    public Collection getJobParamMaster() {
    	Collection collection = null;
		try {
			collection = JobParamMasterUtil.getLocalHome().findByJobId(getJob_id());
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		return collection;
	}
}
