/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.ejb.entity;

import java.util.Collection;

import javax.ejb.FinderException;
import javax.naming.NamingException;


/**
 * 
 * @ejb.bean name="JobNoticeMaster"
 *           jndi-name="JobNoticeMaster"
 *           type="BMP"
 *           
 * @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 * 
 * @ejb.dao class="com.clustercontrol.jobmanagement.dao.JobNoticeMasterDAO"
 * impl-class="com.clustercontrol.jobmanagement.dao.JobNoticeMasterDAOImpl"
 * 
 * @ejb.permission
 *     unchecked="true"
 *     
 **/
public abstract class JobNoticeMasterBean implements javax.ejb.EntityBean {
    protected String job_id;
    protected Integer notice_type;
    protected Integer priority;
    protected String notify_id;
    
    /**
     *
     * <!-- begin-user-doc -->
     * The  ejbCreate method.
     * <!-- end-user-doc -->
     *
     * <!-- begin-xdoclet-definition --> 
     * @ejb.create-method 
     * <!-- end-xdoclet-definition --> 
     * @generated
     */
    public JobNoticeMasterPK ejbCreate(
            String job_id, 
            Integer notice_type, 
            Integer priority, 
            String notify_id
            ) throws javax.ejb.CreateException {
        this.job_id = job_id;
        this.notice_type = notice_type;
        this.priority = priority;
        this.notify_id = notify_id;
        return null;
    }

    
    /**
     * <!-- begin-user-doc -->
     * The container invokes this method immediately after it calls ejbCreate.
     * <!-- end-user-doc -->
     * 
     * @generated
     */
    public void ejbPostCreate() throws javax.ejb.CreateException {
        // begin-user-code
        // end-user-code
    }
    
	public Collection ejbFindAll() throws FinderException {
		return null;
	}
	
	public JobNoticeMasterPK ejbFindByPrimaryKey(JobNoticeMasterPK pk) throws FinderException {
		return null;
	}
	
	public Collection ejbFindByJobId(String job_id) throws FinderException {
		return null;
	}

    /**
     * @return the job_id
     * @ejb.persistent-field 
     * @ejb.pk-field 
     * @ejb.interface-method
     */
    public java.lang.String getJob_id() {
    	return job_id;
    }

    /**
     * @param java.lang.String the new job_id value
     * @ejb.interface-method
     */
    public void setJob_id(java.lang.String job_id) {
    	this.job_id = job_id;
    }

    /**
     * @return the notice_type
     * @ejb.persistent-field 
     * @ejb.pk-field 
     * @ejb.interface-method
     */
    public java.lang.Integer getNotice_type() {
    	return notice_type;
    }

    /**
     * @param java.lang.Integer the new notice_type value
     * @ejb.interface-method
     */
    public void setNotice_type(java.lang.Integer notice_type) {
    	this.notice_type = notice_type;
    }

    /**
     * @return the priority
     * @ejb.persistent-field 
     * @ejb.interface-method
     */
    public java.lang.Integer getPriority() {
    	return priority;
    }

    /**
     * @param java.lang.Integer the new priority value
     * @ejb.interface-method
     */
    public void setPriority(java.lang.Integer priority) {
    	this.priority = priority;
    }

    /**
     * @return the notify_id
     * @ejb.persistent-field 
     * @ejb.interface-method

     */
    public java.lang.String getNotify_id() {
    	return notify_id;
    }

    /**
     * @param java.lang.String the new notify_id value
     * @ejb.interface-method
     */
    public void setNotify_id(java.lang.String notify_id) {
    	this.notify_id = notify_id;
    }
    
    //	==========================================
	//	 CMR fields
	//	==========================================
    /**
     * @ejb.interface-method view-type="local"
     */
    public JobMasterLocal getJobMaster() {
		JobMasterLocal jobMaster = null;
		try {
			jobMaster = JobMasterUtil.getLocalHome().findByPrimaryKey(new JobMasterPK(getJob_id()));
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		return jobMaster;
	}
    
    

}
