/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.ejb.entity;

import java.util.Collection;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import com.clustercontrol.jobmanagement.dao.JobRelationInfoDAOImpl;


/**
 * 
 * @ejb.bean name="JobRelationInfo"
 *           jndi-name="JobRelationInfo"
 *           type="BMP"
 *           
 * @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 * 
 * @ejb.dao class="com.clustercontrol.jobmanagement.dao.JobRelationInfoDAO"
 * impl-class="com.clustercontrol.jobmanagement.dao.JobRelationInfoDAOImpl"
 * 
 * @ejb.permission
 *     unchecked="true"
 *     
 **/
public abstract class JobRelationInfoBean implements javax.ejb.EntityBean {
    protected String session_id;
    protected String job_id;
    protected String parent_job_id;
    
    /**
     *
     * <!-- begin-user-doc -->
     * The  ejbCreate method.
     * <!-- end-user-doc -->
     *
     * <!-- begin-xdoclet-definition --> 
     * @ejb.create-method 
     * <!-- end-xdoclet-definition --> 
     * @generated
     */
    public JobRelationInfoPK ejbCreate(
            String session_id, 
            String job_id, 
            String parent_job_id
            ) throws javax.ejb.CreateException {
        this.session_id = session_id;
        this.job_id = job_id;
        this.parent_job_id = parent_job_id;
        return null;
    }
    
    /**
     * <!-- begin-user-doc -->
     * The container invokes this method immediately after it calls ejbCreate.
     * <!-- end-user-doc -->
     * 
     * @generated
     */
    public void ejbPostCreate() throws javax.ejb.CreateException {
        // begin-user-code
        // end-user-code
    }
    
	public Collection ejbFindAll() throws FinderException {
		return null;
	}
	
	public JobRelationInfoPK ejbFindByPrimaryKey(JobRelationInfoPK pk) throws FinderException {
		return null;
	}
	
	public Collection ejbFindByParentJobId(java.lang.String session_id, java.lang.String parent_job_id) throws FinderException {
		return null;
	}
	
	public Collection ejbFindByStartStatus(java.lang.String session_id, java.lang.String parent_job_id) throws FinderException {
		return null;
	}
	
	public Collection ejbFindByStatus(java.lang.String session_id, java.lang.String parent_job_id, java.lang.Integer status) throws FinderException {
		return null;
	}
	
	public Collection ejbFindByStartDate(java.lang.String session_id, java.lang.String parent_job_id) throws FinderException {
		return null;
	}
	
	public JobRelationInfoPK ejbFindBySessionIdAndJobId(java.lang.String session_id, java.lang.String job_id) throws FinderException {
		return null;
	}

    /**
     * @return the session_id
     * @ejb.persistent-field
     * @ejb.pk-field 
     * @ejb.interface-method
     */
    public java.lang.String getSession_id() {
    	return session_id;
    }

    /**
     * @param java.lang.String the new session_id value
     * @ejb.interface-method
     */
    public void setSession_id(java.lang.String session_id) {
    	this.session_id = session_id;
    }

    /**
     * @return the job_id
     * @ejb.persistent-field 
     * @ejb.pk-field 
     * @ejb.interface-method
     */
    public java.lang.String getJob_id() {
    	return job_id;
    }

    /**
     * @param java.lang.String the new job_id value
     * @ejb.interface-method
     */
    public void setJob_id(java.lang.String job_id) {
    	this.job_id = job_id;
    }

    /**
     * @return the parent_job_id
     * @ejb.persistent-field 
     * @ejb.pk-field 
     * @ejb.interface-method
     */
    public java.lang.String getParent_job_id() {
    	return parent_job_id;
    }

    /**
     * @param java.lang.String the new parent_job_id value
     * @ejb.interface-method
     */
    public void setParent_job_id(java.lang.String parent_job_id) {
    	this.parent_job_id = parent_job_id;
    }
    
	//	==========================================
	//	 CMR fields
	//	==========================================
    /**
     * @ejb.interface-method view-type="local"
     */
    public JobSessionJobLocal getJobSessionJob() {
    	JobSessionJobLocal jobSessionJob = null;
		try {
			jobSessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(getSession_id(), getJob_id()));
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		return jobSessionJob;
	}
    
    /**
     * @ejb.home-method view-type="both"
     * @param sessionId
     * @param jobs
     * @throws javax.ejb.CreateException
     */
    public void ejbHomeMakeSession(String sessionId,Collection jobs) throws javax.ejb.CreateException{
    	JobRelationInfoDAOImpl jriDAO = new JobRelationInfoDAOImpl(); 
    	
    	jriDAO.makeSession(sessionId,jobs);
    }

}