/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.ejb.entity;

import java.util.Collection;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import com.clustercontrol.jobmanagement.dao.JobRelationMasterDAOImpl;


/**
 * 
 * @ejb.bean name="JobRelationMaster"
 *           jndi-name="JobRelationMaster"
 *           type="BMP"
 *           
 * @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 * 
 * @ejb.dao class="com.clustercontrol.jobmanagement.dao.JobRelationMasterDAO"
 * impl-class="com.clustercontrol.jobmanagement.dao.JobRelationMasterDAOImpl"
 * 
 * @ejb.permission
 *     unchecked="true"
 *     
 **/
public abstract class JobRelationMasterBean implements javax.ejb.EntityBean {
    protected String job_id;
    protected String parent_job_id;
    
    /**
     *
     * <!-- begin-user-doc -->
     * The  ejbCreate method.
     * <!-- end-user-doc -->
     *
     * <!-- begin-xdoclet-definition --> 
     * @ejb.create-method 
     * <!-- end-xdoclet-definition --> 
     * @generated
     */
    public JobRelationMasterPK ejbCreate(
            String job_id, 
            String parent_job_id
            ) throws javax.ejb.CreateException {
        this.job_id = job_id;
        this.parent_job_id = parent_job_id;
        return null;
    }
    
    /**
     * <!-- begin-user-doc -->
     * The container invokes this method immediately after it calls ejbCreate.
     * <!-- end-user-doc -->
     * 
     * @generated
     */
    public void ejbPostCreate() throws javax.ejb.CreateException {
        // begin-user-code
        // end-user-code
    }
    
	public Collection ejbFindAll() throws FinderException {
		return null;
	}
	
	public JobRelationMasterPK ejbFindByPrimaryKey(JobRelationMasterPK pk) throws FinderException {
		return null;
	}
	
	public Collection ejbFindByParentJobId(java.lang.String parent_job_id) throws FinderException {
		return null;
	}
	
	public JobRelationMasterPK ejbFindByJobId(java.lang.String job_id) throws FinderException {
		return null;
	}
	
    /**
     * @return the job_id
     * @ejb.persistent-field 
     * @ejb.pk-field 
     * @ejb.interface-method
     */
    public java.lang.String getJob_id() {
    	return job_id;
    }

    /**
     * @param java.lang.String the new job_id value
     * @ejb.interface-method
     */
    public void setJob_id(java.lang.String job_id) {
    	this.job_id = job_id;
    }

    /**
     * @return the parent_job_id
     * @ejb.persistent-field 
     * @ejb.pk-field 
     * @ejb.interface-method
     */
    public java.lang.String getParent_job_id() {
    	return parent_job_id;
    }

    /**
     * @param java.lang.String the new parent_job_id value
     * @ejb.interface-method
     */
    public void setParent_job_id(java.lang.String parent_job_id) {
    	this.parent_job_id = parent_job_id;
    }
    
	//	==========================================
	//	 CMR fields
	//	==========================================
	/**
	 * @ejb.interface-method view-type="local"
	 */
	public JobMasterLocal getJobMaster() {
		JobMasterLocal jobMaster = null;
		try {
			jobMaster = JobMasterUtil.getLocalHome().findByPrimaryKey(new JobMasterPK(getJob_id()));
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		return jobMaster;
	}
	
	
    /**
     * @ejb.home-method view-type="local"
     * @param jobId
     * @return
     * @throws javax.ejb.FinderException
     */
    public Collection ejbHomeGetJobsList(String jobId) throws javax.ejb.FinderException{

    	
    	JobRelationMasterDAOImpl jrmDAO = new JobRelationMasterDAOImpl();
    	
    	
    	return jrmDAO.getJobsList(jobId);
    }
	
    /**
     * @ejb.home-method view-type="local"
     * @param jobId
     * @return
     * @throws javax.ejb.FinderException
     */
    public String ejbHomeGetTopJobId(String jobId) throws javax.ejb.FinderException{

    	
    	JobRelationMasterDAOImpl jrmDAO = new JobRelationMasterDAOImpl();
    	
    	
    	return jrmDAO.getTopJobId(jobId);
    }
}
