/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.ejb.entity;

import java.util.Collection;

import javax.ejb.FinderException;
import javax.naming.NamingException;


/**
 * 
 * @ejb.bean name="JobStartJobMaster"
 *           jndi-name="JobStartJobMaster"
 *           type="BMP"
 *           
 * @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 * 
 * @ejb.dao class="com.clustercontrol.jobmanagement.dao.JobStartJobMasterDAO"
 * impl-class="com.clustercontrol.jobmanagement.dao.JobStartJobMasterDAOImpl"
 * 
 * @ejb.permission
 *     unchecked="true"
 *     
 **/
public abstract class JobStartJobMasterBean implements javax.ejb.EntityBean {
    protected String job_id;
    protected String target_job_id;
    protected Integer target_job_type;
    protected Integer target_job_end_value;
    
    /**
     *
     * <!-- begin-user-doc -->
     * The  ejbCreate method.
     * <!-- end-user-doc -->
     *
     * <!-- begin-xdoclet-definition --> 
     * @ejb.create-method 
     * <!-- end-xdoclet-definition --> 
     * @generated
     */
    public JobStartJobMasterPK ejbCreate(
            String job_id, 
            String target_job_id, 
            Integer target_job_type, 
            Integer target_job_end_value
            ) throws javax.ejb.CreateException {
        this.job_id = job_id;
        this.target_job_id = target_job_id;
        this.target_job_type = target_job_type;
        this.target_job_end_value = target_job_end_value;
        return null;
    }

    /**
     * <!-- begin-user-doc -->
     * The container invokes this method immediately after it calls ejbCreate.
     * <!-- end-user-doc -->
     * 
     * @generated
     */
    public void ejbPostCreate() throws javax.ejb.CreateException {
        // begin-user-code
        // end-user-code
    }
    
	public Collection ejbFindAll() throws FinderException {
		return null;
	}
	
	public JobStartJobMasterPK ejbFindByPrimaryKey(JobStartJobMasterPK pk) throws FinderException {
		return null;
	}
	
	public Collection ejbFindByJobId(java.lang.String job_id) throws FinderException {
		return null;
	}

    /**
     * @return the job_id
     * @ejb.persistent-field 
     * @ejb.pk-field 
     * @ejb.interface-method
     */
    public java.lang.String getJob_id() {
    	return job_id;
    }

    /**
     * @param java.lang.String the new job_id value
     * @ejb.interface-method
     */
    public void setJob_id(java.lang.String job_id) {
    	this.job_id = job_id;
    }

    /**
     * @return the target_job_id
     * @ejb.persistent-field 
     * @ejb.pk-field 
     * @ejb.interface-method
     */
    public java.lang.String getTarget_job_id() {
    	return target_job_id;
    }

    /**
     * @param java.lang.String the new target_job_id value
     * @ejb.interface-method
     */
    public void setTarget_job_id(java.lang.String target_job_id) {
    	this.target_job_id = target_job_id;
    }

    /**
     * @return the target_job_type
     * @ejb.persistent-field 
     * @ejb.pk-field 
     * @ejb.interface-method
     */
    public java.lang.Integer getTarget_job_type() {
    	return target_job_type;
    }

    /**
     * @param java.lang.Integer the new target_job_type value
     * @ejb.interface-method
     */
    public void setTarget_job_type(
            java.lang.Integer target_job_type) {
    	this.target_job_type = target_job_type;
    }
    
    /**
     * @return the target_job_end_value
     * @ejb.persistent-field 
     * @ejb.pk-field 
     * @ejb.interface-method
     */
    public java.lang.Integer getTarget_job_end_value() {
    	return target_job_end_value;
    }

    /**
     * @param java.lang.Integer the new target_job_end_value value
     * @ejb.interface-method
     */
    public void setTarget_job_end_value(
            java.lang.Integer target_job_end_value) {
    	this.target_job_end_value = target_job_end_value;
    }

	//	==========================================
	//	 CMR fields
	//	==========================================
    /**
     * @ejb.interface-method view-type="local"
     */
    public JobStartMasterLocal getJobStartMaster() {
    	JobStartMasterLocal jobStartMaster = null;
		try {
			jobStartMaster = JobStartMasterUtil.getLocalHome().findByPrimaryKey(new JobStartMasterPK(getJob_id()));
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		return jobStartMaster;
	}
}
