/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.ejb.entity;

import java.sql.Time;
import java.util.Collection;

import javax.ejb.FinderException;
import javax.naming.NamingException;

/**
 * 
 * @ejb.bean name="JobStartTimeMaster"
 *           jndi-name="JobStartTimeMaster"
 *           type="BMP"
 *           
 * @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 * 
 * @ejb.dao class="com.clustercontrol.jobmanagement.dao.JobStartTimeMasterDAO"
 * impl-class="com.clustercontrol.jobmanagement.dao.JobStartTimeMasterDAOImpl"
 * 
 * @ejb.permission
 *     unchecked="true"
 *     
 **/
public abstract class JobStartTimeMasterBean implements javax.ejb.EntityBean {
	protected String job_id;
	protected Time start_time;
	    
    /**
     *
     * <!-- begin-user-doc -->
     * The  ejbCreate method.
     * <!-- end-user-doc -->
     *
     * <!-- begin-xdoclet-definition --> 
     * @ejb.create-method 
     * <!-- end-xdoclet-definition --> 
     * @generated
     */
    public JobStartTimeMasterPK ejbCreate(
            String job_id, 
            Time start_time
            ) throws javax.ejb.CreateException {
        this.job_id = job_id;
        this.start_time = start_time;
        return null;
    }

    /**
     * <!-- begin-user-doc -->
     * The container invokes this method immediately after it calls ejbCreate.
     * <!-- end-user-doc -->
     * 
     * @generated
     */
    public void ejbPostCreate() throws javax.ejb.CreateException {
        // begin-user-code
        // end-user-code
    }
    
	public Collection ejbFindAll() throws FinderException {
		return null;
	}
	
	public JobStartTimeMasterPK ejbFindByPrimaryKey(JobStartTimeMasterPK pk) throws FinderException {
		return null;
	}
    
    /**
     * @return the job_id
     * @ejb.persistent-field 
     * @ejb.pk-field 
     * @ejb.interface-method
     */
    public java.lang.String getJob_id() {
    	return job_id;
    }

    /**
     * @param java.lang.String the new job_id value
     * @ejb.interface-method
     */
    public void setJob_id(java.lang.String job_id) {
    	this.job_id = job_id;
    }
    
    /**
     * @return the start_time
     * @ejb.persistent-field 
     * @ejb.interface-method
     */
    public java.sql.Time getStart_time() {
    	return start_time;
    }

    /**
     * @param java.util.Date the new start_time value
     * @ejb.interface-method
     */
    public void setStart_time(java.sql.Time start_time) {
    	this.start_time = start_time;
    }
    
	//	==========================================
	//	 CMR fields
	//	==========================================
    /**
     * @ejb.interface-method view-type="local"
     */
    public JobStartMasterLocal getJobStartMaster() {
    	JobStartMasterLocal jobStartMaster = null;
		try {
			jobStartMaster = JobStartMasterUtil.getLocalHome().findByPrimaryKey(new JobStartMasterPK(getJob_id()));
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		return jobStartMaster;
	}
}
