/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.ejb.mdb;

import javax.ejb.FinderException;
import javax.jms.ObjectMessage;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.jobmanagement.bean.CommandTypeConstant;
import com.clustercontrol.jobmanagement.bean.TopicConstant;
import com.clustercontrol.jobmanagement.ejb.session.JobRunManagementLocal;
import com.clustercontrol.jobmanagement.ejb.session.JobRunManagementUtil;
import com.clustercontrol.jobmanagement.message.RunInstructionInfo;
import com.clustercontrol.jobmanagement.message.RunResultInfo;
import com.clustercontrol.jobmanagement.util.SendTopic;

/**
 *
 * <!-- begin-user-doc --> You can insert your documentation for '<em><b>JobResponseBean</b></em>'. <!-- end-user-doc --> *
 *
 *
 * <!-- begin-xdoclet-definition -->
 * @ejb.bean name="JobResponseBean" 
 *     acknowledge-mode="Auto-acknowledge"
 *     destination-type="javax.jms.Queue"
 *     
 *     transaction-type="Container"
 *     destination-jndi-name="queue/clustercontrol/JobManagement/status"
 * 
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=AccessController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=RepositoryController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=NotifyController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=QuartzManager"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=MonitorController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=CalendarController"
 * 
 * @ejb.transaction
 *     type="Required"
 * 
 * @jboss.container-configuration
 *     name="Singleton Message Driven Bean"
 * 
 *--
 * Server Runtime Specific Tags
 * If you are not using a specific runtime, you can safely remove the tags below.
 * @jonas.message-driven-destination 
 *     jndi-name="queue/clustercontrol/JobManagement/status"
 * @jboss.destination-jndi-name 
 *     name="queue/clustercontrol/JobManagement/status"
 *
 *--
 * <!-- end-xdoclet-definition -->
 * @generated
 **/
public class JobResponseBean implements javax.ejb.MessageDrivenBean, javax.jms.MessageListener {
    protected static Log m_log = LogFactory.getLog( JobResponseBean.class );
    
    /** 
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * The context for the message-driven bean, set by the EJB container. 
     * @generated
     */
    private javax.ejb.MessageDrivenContext messageContext = null;

    /** 
     * Required method for container to set context.
     * @generated 
     */
    public void setMessageDrivenContext(
            javax.ejb.MessageDrivenContext messageContext)
            throws javax.ejb.EJBException {
        this.messageContext = messageContext;
    }

    /** 
     * Required creation method for message-driven beans. 
     *
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     *
     * <!-- begin-xdoclet-definition -->
     * @ejb.create-method 
     * <!-- end-xdoclet-definition -->
     * @generated
     */
    public void ejbCreate() {
        //no specific action required for message-driven beans 
    }

    /** 
     * Required removal method for message-driven beans. 
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void ejbRemove() {
        messageContext = null;
    }

    /** 
     * This method implements the business logic for the EJB. 
     * 
     * <p>Make sure that the business logic accounts for asynchronous message processing. 
     * For example, it cannot be assumed that the EJB receives messages in the order they were 
     * sent by the client. Instance pooling within the container means that messages are not 
     * received or processed in a sequential order, although individual onMessage() calls to 
     * a given message-driven bean instance are serialized. 
     * 
     * <p>The <code>onMessage()</code> method is required, and must take a single parameter 
     * of type javax.jms.Message. The throws clause (if used) must not include an application 
     * exception. Must not be declared as final or static. 
     *
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @throws Exception
     * @generated
     */
    public void onMessage(javax.jms.Message message) {
        m_log.debug("onMessage()");
        try {
            if(message instanceof ObjectMessage){
                ObjectMessage objectMessage = (ObjectMessage)message;
                if(objectMessage.getObject() instanceof RunResultInfo){

                    RunResultInfo info = (RunResultInfo)objectMessage.getObject();

                    m_log.debug("onMessage() receive: SessionId = " + info.getSessionId() + ", JobId = " + info.getJobId() + ", FacilityId = " + info.getFacilityId() + ", status = " + info.getStatus() + ", CommandType = " + info.getCommandType());

    	            JobRunManagementLocal JobRunManagement = 
    	                JobRunManagementUtil.getLocalHome().create();
    	            
                    try {
                        JobRunManagement.endNode(info);
            		} catch (FinderException e) {
            			m_log.debug("onMessage() : 곰Υåޤ ˴ޤ" + 
            					" sessionId=" + info.getSessionId() + 
            					", jobId=" + info.getJobId() + 
            					", facilityId=" + info.getFacilityId());
            			
            			if(info.getCommandType() == CommandTypeConstant.NORMAL || 
            					info.getCommandType() == CommandTypeConstant.STOP){
            				//
            				RunInstructionInfo instructionInfo = new RunInstructionInfo();
            				instructionInfo.setSessionId(info.getSessionId());
            				instructionInfo.setJobId(info.getJobId());
            				instructionInfo.setFacilityId(info.getFacilityId());
            				instructionInfo.setCommand("");
            				if(info.getCommandType() == CommandTypeConstant.NORMAL)
            					instructionInfo.setCommandType(CommandTypeConstant.DELETE_NORMAL_HISTORY);
            				else if(info.getCommandType() == CommandTypeConstant.STOP)
            					instructionInfo.setCommandType(CommandTypeConstant.DELETE_STOP_HISTORY);
            				
            				try {
            					//Topic
            					SendTopic send = new SendTopic(TopicConstant.TOPIC_NAME_EXECUTE);
            					send.put(instructionInfo);
            				} catch (Exception e1) {
            					m_log.debug("onMessage() : 顼 : " + e.getMessage());
            				}
            			}
                    } catch (Exception e) {
                    	m_log.debug("onMessage() : endNode() : " + e.getMessage());
                    }
                }
	        }
        } catch (Exception e) {
        	m_log.debug("onMessage() : " + e.getMessage());
        }
    }
}
