/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.ejb.session;

import java.rmi.RemoteException;
import java.security.Principal;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionContext;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.SWT;
import org.quartz.SchedulerException;

import com.clustercontrol.bean.CommonTableTreeItem;
import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.TableColumnInfo;
import com.clustercontrol.calendar.bean.ScheduleTableConstant;
import com.clustercontrol.calendar.ejb.session.CalendarControllerLocal;
import com.clustercontrol.calendar.ejb.session.CalendarControllerUtil;
import com.clustercontrol.jobmanagement.bean.ForwardFileTableDefine;
import com.clustercontrol.jobmanagement.bean.HistoryTableDefine;
import com.clustercontrol.jobmanagement.bean.JobDetailTableDefine;
import com.clustercontrol.jobmanagement.bean.JobTableDefine;
import com.clustercontrol.jobmanagement.bean.JobTreeItem;
import com.clustercontrol.jobmanagement.bean.NodeDetailTableDefine;
import com.clustercontrol.jobmanagement.bean.RunScheduleDetailListTableDefine;
import com.clustercontrol.jobmanagement.bean.RunScheduleDetailTableDefine;
import com.clustercontrol.jobmanagement.bean.RunScheduleListTableDefine;
import com.clustercontrol.jobmanagement.bean.ScheduleInfo;
import com.clustercontrol.jobmanagement.bean.ScheduleTableDefine;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionUtil;
import com.clustercontrol.jobmanagement.factory.HistoryFilterProperty;
import com.clustercontrol.jobmanagement.factory.JobOperationProperty;
import com.clustercontrol.jobmanagement.factory.ModifyJob;
import com.clustercontrol.jobmanagement.factory.ModifySchedule;
import com.clustercontrol.jobmanagement.factory.SelectJob;
import com.clustercontrol.jobmanagement.factory.SelectRunSchedule;
import com.clustercontrol.jobmanagement.factory.SelectSchedule;
import com.clustercontrol.monitor.message.LogOutputInfo;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.apllog.AplLogger;

/**
 *
 * <!-- begin-user-doc --> A generated session bean <!-- end-user-doc --> *
 *
 * <!-- begin-xdoclet-definition --> 
 * @ejb.bean name="JobController"	
 *           jndi-name="JobController"
 *           type="Stateless" 
 *           transaction-type="Container"
 * 
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=AccessController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=RepositoryController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=NotifyController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=QuartzManager"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=MonitorController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=CalendarController"
 * 
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="Home"
 *     
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="LocalHome"
 *     
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="Local"
 *           
 * @ejb.env-entry
 *     name="JobHistoryDisplayNumber"
 *     type="java.lang.Integer"
 *     value="500"
 *     
 * <!-- end-xdoclet-definition --> 
 * @generated
 */
public abstract class JobControllerBean implements javax.ejb.SessionBean {
    protected static Log m_log = LogFactory.getLog( JobControllerBean.class );
    
	@SuppressWarnings("unused")
	private SessionContext m_context;
	
	public void setSessionContext(SessionContext ctx) throws EJBException, RemoteException {
		m_context = ctx;
	}
	
	/**
	 * ơ֥
	 * 
	 * @ejb.interface-method
	 * 
     * @ejb.permission
     *     unchecked="true"
     *     method-intf="Remote"
	 * 
	 * @param local
	 * @return TableColumnInfo
	 */
	@SuppressWarnings("unchecked")
	public ArrayList getHistoryTableDefine(Locale locale) {
		//ơ֥
		ArrayList tableDefine = new ArrayList();

		tableDefine.add(HistoryTableDefine.STATUS, 
				new TableColumnInfo(Messages.getString("run.status", locale), TableColumnInfo.STATE, 80, SWT.LEFT));
		tableDefine.add(HistoryTableDefine.END_STATUS, 
				new TableColumnInfo(Messages.getString("end.status", locale), TableColumnInfo.END_STATUS, 80, SWT.LEFT));
		tableDefine.add(HistoryTableDefine.END_VALUE, 
				new TableColumnInfo(Messages.getString("end.value", locale), TableColumnInfo.NONE, 50, SWT.LEFT));
		tableDefine.add(HistoryTableDefine.SESSION_ID, 
				new TableColumnInfo(Messages.getString("session.id", locale), TableColumnInfo.NONE, 140, SWT.LEFT));
		tableDefine.add(HistoryTableDefine.JOB_ID, 
				new TableColumnInfo(Messages.getString("job.id", locale), TableColumnInfo.NONE, 100, SWT.LEFT));
		tableDefine.add(HistoryTableDefine.JOB_NAME, 
				new TableColumnInfo(Messages.getString("job.name", locale), TableColumnInfo.NONE, 150, SWT.LEFT));
		tableDefine.add(HistoryTableDefine.JOB_TYPE, 
				new TableColumnInfo(Messages.getString("type", locale), TableColumnInfo.JOB, 110, SWT.LEFT));
		tableDefine.add(HistoryTableDefine.FACILITY_ID, 
				new TableColumnInfo(Messages.getString("facility.id", locale), TableColumnInfo.NONE, 100, SWT.LEFT));
		tableDefine.add(HistoryTableDefine.SCOPE, 
				new TableColumnInfo(Messages.getString("scope", locale), TableColumnInfo.FACILITY, 150, SWT.LEFT));
		tableDefine.add(HistoryTableDefine.SCHEDULED_START_TIME, 
				new TableColumnInfo(Messages.getString("scheduled.start.time", locale), TableColumnInfo.NONE, 150, SWT.LEFT));
		tableDefine.add(HistoryTableDefine.START_RERUN_TIME, 
				new TableColumnInfo(Messages.getString("start.rerun.time", locale), TableColumnInfo.NONE, 150, SWT.LEFT));
		tableDefine.add(HistoryTableDefine.END_SUSPEND_TIME, 
				new TableColumnInfo(Messages.getString("end.suspend.time", locale), TableColumnInfo.NONE, 150, SWT.LEFT));

		return tableDefine;
	}
	
	/**
	 * ־ܺ٥ơ֥
	 * 
	 * @ejb.interface-method
	 * 
     * @ejb.permission
     *     unchecked="true"
     *     method-intf="Remote"
	 * 
	 * @param locale
	 * @return TableColumnInfo
	 */
	@SuppressWarnings("unchecked")
	public ArrayList getDetailTableDefine(Locale locale) {
		//ơ֥
		ArrayList tableDefine = new ArrayList();
		
		tableDefine.add(JobDetailTableDefine.TREE, 
				new TableColumnInfo("", TableColumnInfo.NONE, 30, SWT.LEFT));
		tableDefine.add(JobDetailTableDefine.STATUS, 
				new TableColumnInfo(Messages.getString("run.status", locale), TableColumnInfo.STATE, 80, SWT.LEFT));
		tableDefine.add(JobDetailTableDefine.END_STATUS, 
				new TableColumnInfo(Messages.getString("end.status", locale), TableColumnInfo.END_STATUS, 80, SWT.LEFT));
		tableDefine.add(JobDetailTableDefine.END_VALUE, 
				new TableColumnInfo(Messages.getString("end.value", locale), TableColumnInfo.NONE, 50, SWT.LEFT));
		tableDefine.add(JobDetailTableDefine.JOB_ID, 
				new TableColumnInfo(Messages.getString("job.id", locale), TableColumnInfo.NONE, 100, SWT.LEFT));
		tableDefine.add(JobDetailTableDefine.JOB_NAME, 
				new TableColumnInfo(Messages.getString("job.name", locale), TableColumnInfo.NONE, 150, SWT.LEFT));
		tableDefine.add(JobDetailTableDefine.JOB_TYPE, 
				new TableColumnInfo(Messages.getString("type", locale), TableColumnInfo.JOB, 110, SWT.LEFT));
		tableDefine.add(JobDetailTableDefine.FACILITY_ID, 
				new TableColumnInfo(Messages.getString("facility.id", locale), TableColumnInfo.NONE, 100, SWT.LEFT));
		tableDefine.add(JobDetailTableDefine.SCOPE, 
				new TableColumnInfo(Messages.getString("scope", locale), TableColumnInfo.FACILITY, 150, SWT.LEFT));
		tableDefine.add(JobDetailTableDefine.WAIT_RULE_TIME, 
				new TableColumnInfo(Messages.getString("wait.rule.time", locale), TableColumnInfo.NONE, 120, SWT.LEFT));
		tableDefine.add(JobDetailTableDefine.START_RERUN_TIME, 
				new TableColumnInfo(Messages.getString("start.rerun.time", locale), TableColumnInfo.NONE, 150, SWT.LEFT));
		tableDefine.add(JobDetailTableDefine.END_SUSPEND_TIME, 
				new TableColumnInfo(Messages.getString("end.suspend.time", locale), TableColumnInfo.NONE, 150, SWT.LEFT));

		return tableDefine;
	}
	
	/**
	 * ֥ơ֥
	 * 
	 * @ejb.interface-method
	 * 
     * @ejb.permission
     *     unchecked="true"
     *     method-intf="Remote"
	 * 
	 * @param locale
	 * @return TableColumnInfo
	 */
	@SuppressWarnings("unchecked")
	public ArrayList getJobTableDefine(Locale locale) {
		//ơ֥
		ArrayList tableDefine = new ArrayList();

		tableDefine.add(JobTableDefine.JOB_ID, 
				new TableColumnInfo(Messages.getString("job.id", locale), TableColumnInfo.NONE, 100, SWT.LEFT));
		tableDefine.add(JobTableDefine.JOB_NAME, 
				new TableColumnInfo(Messages.getString("job.name", locale), TableColumnInfo.NONE, 150, SWT.LEFT));
		tableDefine.add(JobTableDefine.JOB_TYPE, 
				new TableColumnInfo(Messages.getString("type", locale), 	TableColumnInfo.JOB, 110, SWT.LEFT));
		tableDefine.add(JobTableDefine.FACILITY_ID, 
				new TableColumnInfo(Messages.getString("facility.id", locale), TableColumnInfo.NONE, 100, SWT.LEFT));
		tableDefine.add(JobTableDefine.SCOPE, 
				new TableColumnInfo(Messages.getString("scope", locale), TableColumnInfo.FACILITY, 150, SWT.LEFT));
		tableDefine.add(JobTableDefine.WAIT_RULE, 
				new TableColumnInfo(Messages.getString("wait.rule", locale), TableColumnInfo.WAIT_RULE, 120, SWT.LEFT));
		tableDefine.add(JobTableDefine.CREATE_USER, 
				new TableColumnInfo(Messages.getString("creator.name", locale), TableColumnInfo.NONE, 80, SWT.LEFT));
		tableDefine.add(JobTableDefine.CREATE_TIME, 
				new TableColumnInfo(Messages.getString("create.time", locale), TableColumnInfo.NONE, 150, SWT.LEFT));
		tableDefine.add(JobTableDefine.UPDATE_USER, 
				new TableColumnInfo(Messages.getString("modifier.name", locale), TableColumnInfo.NONE, 80, SWT.LEFT));
		tableDefine.add(JobTableDefine.UPDATE_TIME, 
				new TableColumnInfo(Messages.getString("update.time", locale), TableColumnInfo.NONE, 150, SWT.LEFT));
		
		return tableDefine;
	}
	
	/**
	 * Ρɾܺ٥ơ֥
	 * 
	 * @ejb.interface-method
	 * 
     * @ejb.permission
     *     unchecked="true"
     *     method-intf="Remote"
	 * 
	 * @param locale
	 * @return TableColumnInfo
	 */
	@SuppressWarnings("unchecked")
	public ArrayList getNodeDetailTableDefine(Locale locale) {
		//ơ֥
		ArrayList tableDefine = new ArrayList();

		tableDefine.add(NodeDetailTableDefine.STATUS, 
				new TableColumnInfo(Messages.getString("run.status", locale), TableColumnInfo.STATE, 80, SWT.LEFT));
		tableDefine.add(NodeDetailTableDefine.RETURN_VALUE, 
				new TableColumnInfo(Messages.getString("return.value", locale), TableColumnInfo.NONE, 50, SWT.LEFT));
		tableDefine.add(NodeDetailTableDefine.FACILITY_ID, 
				new TableColumnInfo(Messages.getString("facility.id", locale), TableColumnInfo.NONE, 100, SWT.LEFT));
		tableDefine.add(NodeDetailTableDefine.FACILITY_NAME, 
				new TableColumnInfo(Messages.getString("facility.name", locale), TableColumnInfo.FACILITY, 150, SWT.LEFT));
		tableDefine.add(NodeDetailTableDefine.START_RERUN_TIME, 
				new TableColumnInfo(Messages.getString("start.rerun.time", locale), TableColumnInfo.NONE, 150, SWT.LEFT));
		tableDefine.add(NodeDetailTableDefine.END_SUSPEND_TIME, 
				new TableColumnInfo(Messages.getString("end.suspend.time", locale), TableColumnInfo.NONE, 150, SWT.LEFT));
		tableDefine.add(NodeDetailTableDefine.MESSAGE, 
				new TableColumnInfo(Messages.getString("message", locale), TableColumnInfo.NONE, 300, SWT.LEFT));
		
		return tableDefine;
	}
	
	/**
	 * 塼ơ֥
	 * 
	 * @ejb.interface-method
	 * 
     * @ejb.permission
     *     unchecked="true"
     *     method-intf="Remote"
	 * 
	 * @param locale
	 * @return TableColumnInfo
	 */
	@SuppressWarnings("unchecked")
	public ArrayList getScheduleTableDefine(Locale locale) {
		//ơ֥
		ArrayList tableDefine = new ArrayList();

		tableDefine.add(ScheduleTableDefine.SCHE_ID, 
				new TableColumnInfo(Messages.getString("schedule.id", locale), TableColumnInfo.NONE, 80, SWT.LEFT));
		tableDefine.add(ScheduleTableDefine.SCHE_NAME, 
				new TableColumnInfo(Messages.getString("schedule.name", locale), TableColumnInfo.NONE, 150, SWT.LEFT));
		tableDefine.add(ScheduleTableDefine.JOB_ID, 
				new TableColumnInfo(Messages.getString("job.id", locale), TableColumnInfo.NONE, 80, SWT.LEFT));
		tableDefine.add(ScheduleTableDefine.JOB_NAME, 
				new TableColumnInfo(Messages.getString("job.name", locale), TableColumnInfo.NONE, 150, SWT.LEFT));
		tableDefine.add(ScheduleTableDefine.CALENDAR_ID, 
				new TableColumnInfo(Messages.getString("calendar.id", locale), TableColumnInfo.NONE, 80, SWT.LEFT));
		tableDefine.add(ScheduleTableDefine.SCHEDULE, 
				new TableColumnInfo(Messages.getString("schedule", locale), TableColumnInfo.SCHEDULE, 100, SWT.LEFT));
		tableDefine.add(ScheduleTableDefine.VALID, 
				new TableColumnInfo(Messages.getString("valid", locale) + "/" + Messages.getString("invalid", locale), TableColumnInfo.VALID, 100, SWT.LEFT));
		tableDefine.add(ScheduleTableDefine.CREATE_USER, 
				new TableColumnInfo(Messages.getString("creator.name", locale), TableColumnInfo.NONE, 80, SWT.LEFT));
		tableDefine.add(ScheduleTableDefine.CREATE_TIME, 
				new TableColumnInfo(Messages.getString("create.time", locale), TableColumnInfo.NONE, 150, SWT.LEFT));
		tableDefine.add(ScheduleTableDefine.UPDATE_USER, 
				new TableColumnInfo(Messages.getString("modifier.name", locale), TableColumnInfo.NONE, 80, SWT.LEFT));
		tableDefine.add(ScheduleTableDefine.UPDATE_TIME, 
				new TableColumnInfo(Messages.getString("update.time", locale), TableColumnInfo.NONE, 150, SWT.LEFT));

		return tableDefine;
	}
	
	/**
	 * ͽơ֥
	 * 
	 * @ejb.interface-method
	 * 
     * @ejb.permission
     *     unchecked="true"
     *     method-intf="Remote"
	 * 
	 * @param locale
	 * @return TableColumnInfo
	 */
	@SuppressWarnings("unchecked")
	public ArrayList getRunScheduleListTableDefine(Locale locale) {
		//ơ֥
		ArrayList tableDefine = new ArrayList();

		tableDefine.add(RunScheduleListTableDefine.SCHE_ID, 
				new TableColumnInfo(Messages.getString("schedule.id", locale), TableColumnInfo.NONE, 80, SWT.LEFT));
		tableDefine.add(RunScheduleListTableDefine.SCHE_NAME, 
				new TableColumnInfo(Messages.getString("schedule.name", locale), TableColumnInfo.NONE, 150, SWT.LEFT));
		tableDefine.add(RunScheduleListTableDefine.JOB_ID, 
				new TableColumnInfo(Messages.getString("job.id", locale), TableColumnInfo.NONE, 80, SWT.LEFT));
		tableDefine.add(RunScheduleListTableDefine.JOB_NAME, 
				new TableColumnInfo(Messages.getString("job.name", locale), TableColumnInfo.NONE, 150, SWT.LEFT));
		tableDefine.add(RunScheduleListTableDefine.CALENDAR_ID, 
				new TableColumnInfo(Messages.getString("calendar.id", locale), TableColumnInfo.NONE, 80, SWT.LEFT));
		tableDefine.add(RunScheduleListTableDefine.CALENDAR_ID + 1, 
				new TableColumnInfo("", TableColumnInfo.CHECKBOX, 0, SWT.LEFT));

		return tableDefine;
	}
	
	/**
	 * ͽܺ٥ơ֥
	 * 
	 * @ejb.interface-method
	 * 
     * @ejb.permission
     *     unchecked="true"
     *     method-intf="Remote"
	 * 
	 * @param locale
	 * @return TableColumnInfo
	 */
	@SuppressWarnings("unchecked")
	public ArrayList getRunScheduleDetailListTableDefine(Locale locale) {
		//ơ֥
		ArrayList tableDefine = new ArrayList();
		
		tableDefine.add(RunScheduleDetailListTableDefine.TREE, 
				new TableColumnInfo("", TableColumnInfo.NONE, 30, SWT.LEFT));
		tableDefine.add(RunScheduleDetailListTableDefine.JOB_ID, 
				new TableColumnInfo(Messages.getString("job.id", locale), TableColumnInfo.NONE, 100, SWT.LEFT));
		tableDefine.add(RunScheduleDetailListTableDefine.JOB_NAME, 
				new TableColumnInfo(Messages.getString("job.name", locale), TableColumnInfo.NONE, 150, SWT.LEFT));
		tableDefine.add(RunScheduleDetailListTableDefine.JOB_TYPE, 
				new TableColumnInfo(Messages.getString("type", locale), TableColumnInfo.JOB, 110, SWT.LEFT));
		tableDefine.add(RunScheduleDetailListTableDefine.CALENDAR_ID, 
				new TableColumnInfo(Messages.getString("calendar.id", locale), TableColumnInfo.NONE, 80, SWT.LEFT));

		return tableDefine;
	}
	
	/**
	 * ͽơ֥
	 * 
	 * @ejb.interface-method
	 * 
     * @ejb.permission
     *     unchecked="true"
     *     method-intf="Remote"
	 * 
	 * @param base
	 * @param locale
	 * @return TableColumnInfo
	 * @throws NamingException 
	 * @throws CreateException 
	 */
	@SuppressWarnings("unchecked")
	public ArrayList getRunScheduleTableDefine(Date base, Locale locale) {
		//ơ֥
		ArrayList tableDefine = new ArrayList();
		
		tableDefine.add(0, 
				new TableColumnInfo("", TableColumnInfo.NONE, 0, SWT.LEFT));
		for(int i = 0; i < ScheduleTableConstant.DAYS; i++){
			Calendar baseCalendar = Calendar.getInstance();
			baseCalendar.setTime(base);
			baseCalendar.add(Calendar.DAY_OF_MONTH, i);
			Date work = baseCalendar.getTime();
			tableDefine.add(i + 1, 
					new TableColumnInfo(
							DateFormat.getDateInstance(DateFormat.SHORT, locale).format(work), 
							TableColumnInfo.SCHEDULE_ON_OFF, 70, SWT.LEFT));			
		}
		
		return tableDefine;
	}
	
	/**
	 * ͽܺ٥ơ֥
	 * 
	 * @ejb.interface-method
	 * 
     * @ejb.permission
     *     unchecked="true"
     *     method-intf="Remote"
	 * 
	 * @param base
	 * @param locale
	 * @return TableColumnInfo
	 * @throws NamingException 
	 * @throws CreateException 
	 */
	@SuppressWarnings("unchecked")
	public ArrayList getRunScheduleDetailTableDefine(Date base, Locale locale) {
		//ơ֥
		ArrayList tableDefine = new ArrayList();
		
		tableDefine.add(RunScheduleDetailTableDefine.TREE, 
				new TableColumnInfo("", TableColumnInfo.NONE, 0, SWT.LEFT));
		tableDefine.add(RunScheduleDetailTableDefine.JOB_ID, 
				new TableColumnInfo("", TableColumnInfo.NONE, 0, SWT.LEFT));
		for(int i = 0; i < ScheduleTableConstant.DAYS; i++){
			Calendar baseCalendar = Calendar.getInstance();
			baseCalendar.setTime(base);
			baseCalendar.add(Calendar.DAY_OF_MONTH, i);
			Date work = baseCalendar.getTime();
			tableDefine.add(i + 2, 
					new TableColumnInfo(
							DateFormat.getDateInstance(DateFormat.SHORT, locale).format(work), 
							TableColumnInfo.SCHEDULE_ON_OFF, 70, SWT.LEFT));			
		}
		
		return tableDefine;
	}
	
	/**
	 * եžơ֥
	 * 
	 * @ejb.interface-method
	 * 
     * @ejb.permission
     *     unchecked="true"
     *     method-intf="Remote"
	 * 
	 * @param locale
	 * @return TableColumnInfo
	 */
	@SuppressWarnings("unchecked")
	public ArrayList getForwardFileTableDefine(Locale locale) {
		//ơ֥
		ArrayList tableDefine = new ArrayList();
		
		tableDefine.add(ForwardFileTableDefine.STATUS, 
				new TableColumnInfo(Messages.getString("run.status", locale), TableColumnInfo.STATE, 80, SWT.LEFT));
		tableDefine.add(ForwardFileTableDefine.END_STATUS, 
				new TableColumnInfo(Messages.getString("end.status", locale), TableColumnInfo.END_STATUS, 80, SWT.LEFT));
		tableDefine.add(ForwardFileTableDefine.FILE_NAME, 
				new TableColumnInfo(Messages.getString("file", locale), TableColumnInfo.NONE, 150, SWT.LEFT));
		tableDefine.add(ForwardFileTableDefine.SRC_FACILITY_ID, 
				new TableColumnInfo(Messages.getString("forward.source", locale) + Messages.getString("facility.id", locale), TableColumnInfo.NONE, 100, SWT.LEFT));
		tableDefine.add(ForwardFileTableDefine.SRC_FACILITY_NAME, 
				new TableColumnInfo(Messages.getString("forward.source", locale) + Messages.getString("facility.name", locale), TableColumnInfo.NONE, 100, SWT.LEFT));
		tableDefine.add(ForwardFileTableDefine.DEST_FACILITY_ID, 
				new TableColumnInfo(Messages.getString("forward.destination", locale) + Messages.getString("facility.id", locale), TableColumnInfo.NONE, 100, SWT.LEFT));
		tableDefine.add(ForwardFileTableDefine.DEST_FACILITY_NAME, 
				new TableColumnInfo(Messages.getString("forward.destination", locale) + Messages.getString("facility.name", locale), TableColumnInfo.NONE, 100, SWT.LEFT));
		tableDefine.add(ForwardFileTableDefine.START_RERUN_TIME, 
				new TableColumnInfo(Messages.getString("start.rerun.time", locale), TableColumnInfo.NONE, 150, SWT.LEFT));
		tableDefine.add(ForwardFileTableDefine.END_SUSPEND_TIME, 
				new TableColumnInfo(Messages.getString("end.suspend.time", locale), TableColumnInfo.NONE, 150, SWT.LEFT));

		return tableDefine;
	}
	
	/**
	 * ե륿ѥץѥƥ
	 * 
	 * @ejb.interface-method
	 * 
     * @ejb.permission
     *     unchecked="true"
     *     method-intf="Remote"
	 * 
	 * @param locale
	 * @return 
	 */
	public Property getHistoryFilterProperty(Locale locale) {
	    HistoryFilterProperty history = new HistoryFilterProperty();
		return history.getProperty(locale);
	}
	
	/**
	 * ѥ졼ʸ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="JobManagementRead"
     *     method-intf="Remote"
	 * 
	 * @return
	 */
	public String getSeparator() {
		return SelectJob.SEPARATOR;
	}
	
	/**
	 * ֥ĥ꡼
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="JobManagementRead"
     *     method-intf="Remote"
     *     
	 * @ejb.permission
     *     role-name="JobManagementExecute"
     *     method-intf="Remote"
     *     
	 * @jboss.method-attributes
	 *     read-only="true"
	 *     
	 * @param locale
	 * @param treeOnly
	 * @return JobTreeItemγإ֥
	 * @throws FinderException
	 * @throws NamingException
	 */
	public JobTreeItem getJobTree(boolean treeOnly, Locale locale) throws FinderException, NamingException {
	    m_log.debug("getJobTree() : treeOnly=" + treeOnly + ", locale=" + locale);
	    
		//֥ĥ꡼
	    SelectJob select = new SelectJob();
		JobTreeItem item = select.getJobTree(treeOnly, locale);

		return item;
	}
	
	/**
	 * Ʊ쳬إ֥ĥ꡼
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="JobManagementRead"
     *     method-intf="Remote"
	 * 
	 * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @param parentJobId
	 * @param locale
	 * @return JobTreeItemγإ֥
	 * @throws FinderException
	 * @throws NamingException
	 */
	public JobTreeItem getJobTreeOneLevel(String parentJobId, Locale locale) throws FinderException, NamingException {
	    m_log.debug("getJobTreeOneLevel() : parentJobId=" + parentJobId + ", locale=" + locale);
	    
		//֥ĥ꡼
	    SelectJob select = new SelectJob();
		JobTreeItem item = select.getJobTreeOneLevel(parentJobId, locale);

		return item;
	}
	
	/**
	 * Ͽ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="JobManagementWrite"
     *     method-intf="Remote"
	 * 
	 * @param JobTreeItem
	 * @throws FinderException
	 * @throws NamingException
	 * @throws CreateException
	 * @throws RemoveException
	 */
	public void registerJob(JobTreeItem item) throws FinderException, NamingException, RemoveException, CreateException {
	    m_log.debug("registerJob()");
	    
	    Principal pri = m_context.getCallerPrincipal();
	    
	    ModifyJob modify = new ModifyJob();
	    try {
            modify.registerJob(item, pri.getName());
        } catch (FinderException e) {
            m_log.debug("registerJob() : " + e.getMessage());
            throw e;
        } catch (NamingException e) {
            m_log.debug("registerJob() : " + e.getMessage());
            throw e;
        } catch (RemoveException e) {
            m_log.debug("registerJob() : " + e.getMessage());
            throw e;
        } catch (CreateException e) {
            m_log.debug("registerJob() : " + e.getMessage());
            throw e;
        }
	}
	
	/**
	 * ѥץѥƥ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="JobManagementExecute"
     *     method-intf="Remote"
     *     
	 * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @param local
	 * @return ѥץѥƥ
	 */
	public Property getStartProperty(String sessionId, String jobId, String facilityId, Locale locale) {
	    JobOperationProperty jobPropaerty = new JobOperationProperty();
	    return jobPropaerty.getStartProperty(sessionId, jobId, facilityId, locale);
	}
	
	/**
	 * ѥץѥƥ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="JobManagementExecute"
     *     method-intf="Remote"
     *     
	 * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @param local
	 * @return ѥץѥƥ
	 */
	public Property getStopProperty(String sessionId, String jobId, String facilityId, Locale locale) {
	    JobOperationProperty jobPropaerty = new JobOperationProperty();
	    return jobPropaerty.getStopProperty(sessionId, jobId, facilityId, locale);
	}

	/**
	 * ּ¹
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="JobManagementExecute"
     *     method-intf="Remote"
	 * 
	 * @param jobId
	 * @throws CreateException
	 * @throws FinderException
	 * @throws NamingException
	 */
	public void runJob(String jobId) throws CreateException, FinderException, NamingException {
	    m_log.debug("runJob() : jobId=" + jobId);
		
	    //־
        JobControllerLocal jobController = JobControllerUtil.getLocalHome().create();
        String sessionId = null;
        try {
            sessionId = jobController.createJobInfo(jobId, null);
        } catch (CreateException e) {
            AplLogger apllog = new AplLogger("JOB", "job");
            String[] args = {jobId};
            apllog.put("SYS", "003", args);
            m_log.debug("runJob() : " + e.getMessage());
            throw e;
        } catch (FinderException e) {
            AplLogger apllog = new AplLogger("JOB", "job");
            String[] args = {jobId};
            apllog.put("SYS", "003", args);
            m_log.debug("runJob() : " + e.getMessage());
            throw e;
        } catch (NamingException e) {
            AplLogger apllog = new AplLogger("JOB", "job");
            String[] args = {jobId};
            apllog.put("SYS", "003", args);
            m_log.debug("runJob() : " + e.getMessage());
            throw e;
        }
        
        //ּ¹
	    JobRunManagementLocal JobRunManagement = JobRunManagementUtil.getLocalHome().create();
	    try {
            JobRunManagement.runJob(sessionId, jobId);
        } catch (FinderException e) {
            AplLogger apllog = new AplLogger("JOB", "job");
            String[] args = {sessionId, jobId};
            apllog.put("SYS", "002", args);
            m_log.debug("runJob() : " + e.getMessage());
            throw e;
        } catch (NamingException e) {
            AplLogger apllog = new AplLogger("JOB", "job");
            String[] args = {sessionId, jobId};
            apllog.put("SYS", "002", args);
            m_log.debug("runJob() : " + e.getMessage());
            throw e;
        }
	}
	
	/**
	 * ּ¹
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="JobManagementExecute"
     *     method-intf="Remote"
	 * 
	 * @param jobId
	 * @param info
	 * @throws CreateException
	 * @throws FinderException
	 * @throws NamingException
	 */
	public void runJob(String jobId, LogOutputInfo info) throws CreateException, FinderException, NamingException {
	    m_log.debug("runJob() : jobId=" + jobId);
	    
	    //־
	    JobControllerLocal jobController = JobControllerUtil.getLocalHome().create();
	    String sessionId = null;
	    try {
	    	sessionId = jobController.createJobInfo(jobId, info);
	    } catch (CreateException e) {
	    	AplLogger apllog = new AplLogger("JOB", "job");
	    	String[] args = {jobId};
	    	apllog.put("SYS", "003", args);
	    	m_log.debug("runJob() : " + e.getMessage());
	    	throw e;
	    } catch (FinderException e) {
	    	AplLogger apllog = new AplLogger("JOB", "job");
	    	String[] args = {jobId};
	    	apllog.put("SYS", "003", args);
	    	m_log.debug("runJob() : " + e.getMessage());
	    	throw e;
	    } catch (NamingException e) {
	    	AplLogger apllog = new AplLogger("JOB", "job");
	    	String[] args = {jobId};
	    	apllog.put("SYS", "003", args);
	    	m_log.debug("runJob() : " + e.getMessage());
	    	throw e;
	    }
	    
        //ּ¹
	    JobRunManagementLocal JobRunManagement = JobRunManagementUtil.getLocalHome().create();
	    try {
            JobRunManagement.runJob(sessionId, jobId);
        } catch (FinderException e) {
            AplLogger apllog = new AplLogger("JOB", "job");
            String[] args = {sessionId, jobId};
            apllog.put("SYS", "002", args);
            m_log.debug("runJob() : " + e.getMessage());
            throw e;
        } catch (NamingException e) {
            AplLogger apllog = new AplLogger("JOB", "job");
            String[] args = {sessionId, jobId};
            apllog.put("SYS", "002", args);
            m_log.debug("runJob() : " + e.getMessage());
            throw e;
        }
	}
	
	/**
	 * ּ¹(塼)
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     unchecked="true"
     *     method-intf="Remote"
	 * 
	 * @param jobId
	 * @param calendarId
	 * @throws CreateException
	 * @throws FinderException
	 * @throws NamingException
	 */
	public void scheduleRunJob(String jobId, String calendarId) throws CreateException, FinderException, NamingException {
	    m_log.debug("runJob() : jobId=" + jobId + ", calendarId=" + calendarId);
	    
    	//å
	    boolean check = false;
		if(calendarId != null && calendarId.length() > 0){
	    	try {
				CalendarControllerLocal calendar = 
					CalendarControllerUtil.getLocalHome().create();
					
				//ˤ¹Բ/ԲĤΥå
				if(calendar.isRun(calendarId, new Date()).booleanValue()){
					check = true;
				}
			} catch (CreateException e) {
			} catch (NamingException e) {
			}
		}
		else{
			check = true;
		}
		
		if(!check)
			return;
		
	    //ּ¹
		runJob(jobId);
	}
	
	/**
	 * ־
	 * 
     * @ejb.interface-method
     *     view-type="local"
     *     
	 * @ejb.permission
     *     role-name="JobManagementWrite"
     *     method-intf="Remote"
     *     
	 * @ejb.transaction
	 *     type="RequiresNew"
	 * 
	 * @param jobId
	 * @param info
	 * @return
	 * @throws CreateException
	 * @throws FinderException
	 * @throws NamingException
	 */
	public String createJobInfo(String jobId, LogOutputInfo info) throws CreateException, FinderException, NamingException  {
	    m_log.debug("createJobInfo() : jobId=" + jobId);

	    return JobSessionUtil.getLocalHome().makeSession(jobId, info);
	}

	/**
	 * 
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="JobManagementExecute"
     *     method-intf="Remote"
	 * 
	 * @param property
	 * @throws FinderException
	 * @throws CreateException
	 * @throws NamingException
	 */
	public void operationJob(Property property) throws FinderException, CreateException, NamingException {
	    m_log.debug("operationJob()");
	    
	    JobRunManagementLocal JobRunManagement = JobRunManagementUtil.getLocalHome().create();
        JobRunManagement.operationJob(property);
	}
	
	/**
	 * 
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="JobManagementRead"
     *     method-intf="Remote"
	 * 
	 * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	public ArrayList getHistoryList() throws FinderException, NamingException {
	    m_log.debug("getHistoryList()");
	    
	    SelectJob select = new SelectJob();
	    ArrayList list = select.getHistoryList();
	    
	    return list;
	}
	
	/**
	 * 
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="JobManagementRead"
     *     method-intf="Remote"
	 * 
	 * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @param property
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	public ArrayList getHistoryList(Property property) throws FinderException, NamingException {
	    m_log.debug("getHistoryList()");
	    
	    SelectJob select = new SelectJob();
	    ArrayList list = select.getHistoryList(property);
	    
	    return list;
	}
	
	/**
	 * ־ٰܺ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="JobManagementRead"
     *     method-intf="Remote"
	 * 
	 * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @param sessionId
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 */
	public CommonTableTreeItem getDetailList(String sessionId) throws FinderException, NamingException {
	    m_log.debug("getDetailList() : sessionId=" + sessionId);
	    
	    SelectJob select = new SelectJob();
	    CommonTableTreeItem item = select.getDetailList(sessionId);
	    
	    return item;
	}
	
	/**
	 * ־ٰܺ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="JobManagementRead"
     *     method-intf="Remote"
     *     
	 * @jboss.method-attributes
	 *     read-only="true"
	 *     
	 * @param sessionId
	 * @param jobId
	 * @param locale
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 * @throws CreateException 
	 */
	public ArrayList getNodeDetailList(String sessionId, String jobId, Locale locale) throws FinderException, NamingException, CreateException {
	    m_log.debug("getNodeDetailList() : sessionId=" + sessionId + ", jobId=" + jobId);
	    
	    SelectJob select = new SelectJob();
	    ArrayList list = select.getNodeDetailList(sessionId, jobId, locale);

	    return list;
	}
	
	/**
	 * եž
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="JobManagementRead"
     *     method-intf="Remote"
     *     
	 * @jboss.method-attributes
	 *     read-only="true"
	 *     
	 * @param sessionId
	 * @param jobId
	 * @param locale
	 * @return
	 * @throws FinderException
	 * @throws NamingException
	 * @throws CreateException 
	 */
	public ArrayList getForwardFileList(String sessionId, String jobId) throws FinderException, NamingException, CreateException {
	    m_log.debug("getNodeDetailList() : sessionId=" + sessionId + ", jobId=" + jobId);
	    
	    SelectJob select = new SelectJob();
	    ArrayList list = select.getForwardFileList(sessionId, jobId);

	    return list;
	}
	
	/**
	 * 塼Ͽ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="JobManagementWrite"
     *     method-intf="Remote"
	 * 
	 * @param info
	 * @throws ParseException
	 * @throws NamingException
	 * @throws SchedulerException
	 */
	public void addSchedule(ScheduleInfo info) throws ParseException, NamingException, SchedulerException {
	    m_log.debug("addSchedule() : scheduleId=" + info.getId());
	    
	    Principal pri = m_context.getCallerPrincipal();
	    
	    ModifySchedule modify = new ModifySchedule();
	    try {
            modify.addSchedule(info, pri.getName());
        } catch (ParseException e) {
            AplLogger apllog = new AplLogger("JOB", "job");
            String[] args = {info.getId(), info.getJobId()};
            apllog.put("SYS", "004", args);
            m_log.debug("addSchedule() : " + e.getMessage());
            throw e;
        } catch (NamingException e) {
            AplLogger apllog = new AplLogger("JOB", "job");
            String[] args = {info.getId(), info.getJobId()};
            apllog.put("SYS", "004", args);
            m_log.debug("addSchedule() : " + e.getMessage());
            throw e;
        } catch (SchedulerException e) {
            AplLogger apllog = new AplLogger("JOB", "job");
            String[] args = {info.getId(), info.getJobId()};
            apllog.put("SYS", "004", args);
            m_log.debug("addSchedule() : " + e.getMessage());
            throw e;
        }
	}
	
	/**
	 * 塼ѹ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="JobManagementWrite"
     *     method-intf="Remote"
	 * 
	 * @param info
	 * @throws NamingException
	 * @throws SchedulerException
	 * @throws ParseException
	 */
	public void modifySchedule(ScheduleInfo info) throws NamingException, SchedulerException, ParseException {
	    m_log.debug("modifySchedule() : scheduleId=" + info.getId());
	    
	    Principal pri = m_context.getCallerPrincipal();
	    
	    ModifySchedule modify = new ModifySchedule();
	    try {
            modify.modifySchedule(info, pri.getName());
        } catch (NamingException e) {
            AplLogger apllog = new AplLogger("JOB", "job");
            String[] args = {info.getId()};
            apllog.put("SYS", "006", args);
            m_log.debug("modifySchedule() : " + e.getMessage());
            throw e;
        } catch (SchedulerException e) {
            AplLogger apllog = new AplLogger("JOB", "job");
            String[] args = {info.getId()};
            apllog.put("SYS", "006", args);
            m_log.debug("modifySchedule() : " + e.getMessage());
            throw e;
        } catch (ParseException e) {
            AplLogger apllog = new AplLogger("JOB", "job");
            String[] args = {info.getId()};
            apllog.put("SYS", "006", args);
            m_log.debug("modifySchedule() : " + e.getMessage());
            throw e;
        }
	}
	
	/**
	 * 塼
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="JobManagementWrite"
     *     method-intf="Remote"
	 * 
	 * @param scheduleId
	 * @throws NamingException
	 * @throws SchedulerException
	 */
	public void deleteSchedule(String scheduleId) throws NamingException, SchedulerException {
		m_log.debug("deleteSchedule() : scheduleId=" + scheduleId);
	    
	    ModifySchedule modify = new ModifySchedule();
	    try {
            modify.deleteSchedule(scheduleId);
        } catch (NamingException e) {
            AplLogger apllog = new AplLogger("JOB", "job");
            String[] args = {scheduleId};
            apllog.put("SYS", "005", args);
            m_log.debug("deleteSchedule() : " + e.getMessage());
            throw e;
        } catch (SchedulerException e) {
            AplLogger apllog = new AplLogger("JOB", "job");
            String[] args = {scheduleId};
            apllog.put("SYS", "005", args);
            m_log.debug("deleteSchedule() : " + e.getMessage());
            throw e;
        }
	}
	
	/**
	 * 塼
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="JobManagementRead"
     *     method-intf="Remote"
	 * 
	 * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @return
	 * @throws NamingException
	 * @throws SchedulerException
	 */
	public ArrayList getScheduleList() throws NamingException, SchedulerException {
	    m_log.debug("getScheduleList()");
	    
	    SelectSchedule select = new SelectSchedule();
	    ArrayList list = select.getScheduleList();

	    return list;
	}
	
	/**
	 * ͽ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="JobManagementRead"
     *     method-intf="Remote"
	 * 
	 * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @return
	 * @throws NamingException
	 * @throws SchedulerException
	 */
	public ArrayList getRunScheduleList() throws NamingException, SchedulerException {
	    m_log.debug("getRunScheduleList()");
	    
	    SelectRunSchedule select = new SelectRunSchedule();
	    ArrayList list = select.getList();

	    return list;
	}
	
	/**
	 * ͽ
	 * 
	 * @ejb.interface-method
     *     
	 * @ejb.permission
     *     role-name="JobManagementRead"
     *     method-intf="Remote"
     *     
	 * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @param base
	 * @return ֥Ȥ2
	 * @throws NamingException
	 * @throws SchedulerException
	 * @throws FinderException 
	 */
	public ArrayList getRunSchedule(Date base) throws NamingException, SchedulerException, FinderException {
		m_log.debug("getRunSchedule() : base=" + base);
		
		SelectRunSchedule select = new SelectRunSchedule();
		ArrayList list = select.getSchedule(base);

		return list;
	}
	
	/**
	 * ͽٰܺ
	 * 
	 * @ejb.interface-method
     *     
	 * @ejb.permission
     *     role-name="JobManagementRead"
     *     method-intf="Remote"
     *     
	 * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @param scheduleId
	 * @return
	 * @throws NamingException
	 * @throws FinderException
	 * @throws SchedulerException 
	 */
	public CommonTableTreeItem getRunScheduleDetailList(String scheduleId) throws NamingException, FinderException, SchedulerException {
		m_log.debug("getRunScheduleDetailList() : scheduleId=" + scheduleId);
		
		SelectRunSchedule select = new SelectRunSchedule();
		CommonTableTreeItem item = select.getDetailList(scheduleId);

		return item;
	}
	
	/**
	 * ͽܺټ
	 * 
	 * @ejb.interface-method
     *     
	 * @ejb.permission
     *     role-name="JobManagementRead"
     *     method-intf="Remote"
     *     
	 * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @param scheduleId
	 * @param base
	 * @return 
	 * @throws FinderException
	 * @throws NamingException
	 * @throws SchedulerException 
	 */
	public CommonTableTreeItem getRunScheduleDetail(String scheduleId, Date base) throws FinderException, NamingException, SchedulerException {
		m_log.debug("getRunScheduleDetail() : scheduleId=" + scheduleId + ", base=" + base);
		
		SelectRunSchedule select = new SelectRunSchedule();
		CommonTableTreeItem item = select.getDetailSchedule(scheduleId, base);

		return item;
	}
	
	/**
	 * IDꥹȼ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="JobManagementRead"
     *     method-intf="Remote"
     *     
	 * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @return
	 * @throws CreateException
	 * @throws NamingException
	 * @throws FinderException
	 */
	public ArrayList getCalendarIdList() throws CreateException, NamingException, FinderException {
		m_log.debug("getCalendarIdList()");
		
		CalendarControllerLocal calendar = 
			CalendarControllerUtil.getLocalHome().create();
		
		ArrayList list = calendar.getCalendarIdList();
		
	    return list;
	}
	
	/**
	 * å󥸥־
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
     *     role-name="JobManagementRead"
     *     method-intf="Remote"
     *     
	 * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @return
	 * @throws NamingException
	 * @throws FinderException
	 */
	public JobTreeItem getSessionJobInfo(String sessionId, String jobId) throws NamingException, FinderException {
	    m_log.debug("getSessionJobInfo() : sessionId=" + sessionId + ", jobId=" + jobId);
	    
	    SelectJob select = new SelectJob();
	    JobTreeItem item = select.getSessionJobInfo(sessionId, jobId);
		
	    return item;
	}
}
