/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.ejb.session;

import java.rmi.RemoteException;
import java.text.ParseException;
import java.util.ArrayList;

import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.SchedulerException;
import org.quartz.jobs.ee.ejb.EJBInvokerJob;

import com.clustercontrol.bean.JobConstant;
import com.clustercontrol.bean.Property;
import com.clustercontrol.jobmanagement.bean.JobOperationConstant;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobPK;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionNodeLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionNodePK;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionNodeUtil;
import com.clustercontrol.jobmanagement.factory.JobOperationJudgment;
import com.clustercontrol.jobmanagement.factory.JobOperationProperty;
import com.clustercontrol.jobmanagement.factory.OperateStartOfJob;
import com.clustercontrol.jobmanagement.factory.OperationJob;
import com.clustercontrol.jobmanagement.factory.OperateMaintenanceOfJob;
import com.clustercontrol.jobmanagement.factory.OperateSkipOfJob;
import com.clustercontrol.jobmanagement.factory.OperateStopOfJob;
import com.clustercontrol.jobmanagement.factory.OperateSuspendOfJob;
import com.clustercontrol.jobmanagement.factory.OperateWaitOfJob;
import com.clustercontrol.jobmanagement.message.RunResultInfo;
import com.clustercontrol.jobmanagement.util.QuartzUtil;
import com.clustercontrol.quartzmanager.ejb.session.QuartzManager;
import com.clustercontrol.util.PropertyUtil;
import com.clustercontrol.util.apllog.AplLogger;


/**
 *
 * <!-- begin-user-doc --> A generated session bean <!-- end-user-doc --> *
 *
 * <!-- begin-xdoclet-definition --> 
 * @ejb.bean name="JobRunManagement"	
 *           jndi-name="JobRunManagement"
 *           type="Stateless" 
 *           transaction-type="Container"
 * 
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=AccessController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=RepositoryController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=NotifyController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=QuartzManager"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=MonitorController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=CalendarController"
 * 
 * @ejb.permission
 *     unchecked="true"
 *     
 * <!-- end-xdoclet-definition --> 
 * @generated
 */
public abstract class JobRunManagementBean implements javax.ejb.SessionBean {
    protected static Log m_log = LogFactory.getLog( JobRunManagementBean.class );
    public static final String GROUP_NAME = "JOB_MANAGEMENT";
    
    /**
     * QuartzϿ
     * 
     * @ejb.interface-method
     * @generated
     * 
     * @param cronString
     * @throws NamingException
     * @throws ParseException
     * @throws SchedulerException
     */
    public void addQuartz(String cronString) throws NamingException, ParseException, SchedulerException {
        //QuartzScheduleråå
		QuartzManager manager = QuartzUtil.getQuartzManager();
		
        try {
            //ֺ
        	manager.deleteSchedule(JobRunManagementHome.JNDI_NAME, 
                    GROUP_NAME);
        } catch (SchedulerException e) {
            m_log.debug("addQuartz() : deleteJob error = " + e.getMessage());
        } catch (RemoteException e) {
		}
        
        //JobDetail
        JobDetail job = new JobDetail(
        		JobRunManagementHome.JNDI_NAME, 
                GROUP_NAME, 
                EJBInvokerJob.class);
        
        String serverName = System.getProperty("jboss.server.name");
	    if(serverName.equals("all")){
	        job.getJobDataMap().put(
	                EJBInvokerJob.PROVIDER_URL, 
	                "jnp://localhost:1100");
	    }
	    
        //ִλ˺ʤ褦ˤ롣
        job.setDurability(true);
	    //ּ¹ԼԻ˺Ƽ¹Ԥ褦ˤ롣
	    job.setRequestsRecovery(true);
	    
        //JobDetail˸ƤӽФ饹ȥ᥽åɤ
        job.getJobDataMap().put(
                EJBInvokerJob.EJB_JNDI_NAME_KEY, 
                JobRunManagementHome.JNDI_NAME);
        job.getJobDataMap().put(
                EJBInvokerJob.EJB_METHOD_KEY, 
                "run");
        
        //JobDetail˸ƤӽФ᥽åɤΰ
        Object[] jdArgs = new Object[0];
        job.getJobDataMap().put(EJBInvokerJob.EJB_ARGS_KEY, jdArgs);
        
        //CronTrigger
        CronTrigger cronTrigger = new CronTrigger(JobRunManagementHome.JNDI_NAME, GROUP_NAME);
        
        //塼
        cronTrigger.setCronExpression(cronString);
        
        //Scheduler˥֤Ͽ
        try {
			manager.addSchedule(job, cronTrigger);
		} catch (RemoteException e) {
		}
    }
    
    /**
     * Quartz
     * 
     * @ejb.interface-method
     * @generated
     * 
     * @throws NamingException
     * @throws ParseException
     * @throws SchedulerException
     */
    public void deleteQuartz() throws NamingException, ParseException, SchedulerException {
        //QuartzScheduleråå
    	QuartzManager manager = QuartzUtil.getQuartzManager();
		
        try {
            //ֺ
        	manager.deleteSchedule(JobRunManagementHome.JNDI_NAME, 
                    GROUP_NAME);
        } catch (SchedulerException e) {
            m_log.debug("deleteQuartz() : deleteJob error = " + e.getMessage());
        } catch (RemoteException e) {
		}
    }
    
    /**
     * QuartzΥХå᥽å
     * 
     * @ejb.interface-method
     * @generated
     * 
     * @throws FinderException
     * @throws NamingException
     */
    public void run() throws FinderException, NamingException {
        m_log.debug("run()");
        
        OperationJob operation = new OperationJob();
        operation.runJob();
    }
    
    /**
     * ּ¹
     * 
     * @ejb.interface-method
     * 
     * @ejb.transaction
	 *     type="RequiresNew"
     * 
     * @generated
     * 
     * @param sessionId
     * @param jobId
     * @throws FinderException
     * @throws NamingException
     */
    public void runJob(String sessionId, String jobId) throws FinderException, NamingException {
        m_log.debug("runJob() : sessionId=" + sessionId + ", jobId=" + jobId);
        
        OperationJob operation = new OperationJob();
        operation.runJob(sessionId, jobId);
    }

	/**
	 * 
	 * 
	 * @ejb.interface-method
	 * @generated
	 * 
	 * @param property
	 * @throws FinderException
	 * @throws NamingException
	 */
	public void operationJob(Property property) throws FinderException, NamingException {
	    m_log.debug("operationJob()");
	    
		//åID
		ArrayList values = PropertyUtil.getPropertyValue(property, JobOperationProperty.SESSION);
		String sessionId = null;
		if(values.get(0) instanceof String && ((String)values.get(0)).length() > 0)
		    sessionId = (String)values.get(0);
		
		//ID
		values = PropertyUtil.getPropertyValue(property, JobOperationProperty.JOB);
		String jobId = null;
		if(values.get(0) instanceof String && ((String)values.get(0)).length() > 0)
		    jobId = (String)values.get(0);
		
		//եƥID
		values = PropertyUtil.getPropertyValue(property, JobOperationProperty.FACILITY);
		String facilityId = null;
		if(values.size() > 0 && values.get(0) instanceof String && ((String)values.get(0)).length() > 0)
		    facilityId = (String)values.get(0);
		
		//
		values = PropertyUtil.getPropertyValue(property, JobOperationProperty.CONTROL);
		Integer control = null;
		if(values.get(0) instanceof String){
		    String controlString = (String)values.get(0);
		    control = new Integer(JobOperationConstant.stringToType(controlString));
		}
		
		//λͼ
		values = PropertyUtil.getPropertyValue(property, JobOperationProperty.END_VALUE);
		Integer endValue = null;
		if(values.size() > 0 && values.get(0) instanceof Integer)
		    endValue = (Integer)values.get(0);

	    int status = 0;
	    int jobType = 0;
	    
	    try {
            if(facilityId != null && facilityId.length() > 0){
                //åIDȥID顢å󥸥֤
                JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(
                            new JobSessionJobPK(sessionId, jobId));
                
                //֥פ
                if(sessionJob.getJobInfo().getJob_type().intValue() == JobConstant.TYPE_FILEJOB){
                	jobId = jobId + "_" + facilityId;
                	facilityId = null;
                	
                	//åIDȥID顢å󥸥֤
                    JobSessionJobLocal childSessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(
                            new JobSessionJobPK(sessionId, jobId));
	                
	                //ơ
	                status = childSessionJob.getStatus().intValue();
	                
	                //֥פ
	                jobType = JobOperationJudgment.TYPE_JOBNET;
                }
                else{
	                //åIDȥID顢å󥸥֤
	                JobSessionNodeLocal sessionNode = 
	                    JobSessionNodeUtil.getLocalHome().findByPrimaryKey(
	                            new JobSessionNodePK(sessionId, jobId, facilityId));
	                
	                //ơ
	                status = sessionNode.getStatus().intValue();
	                
	                //֥פ
	                jobType = JobOperationJudgment.TYPE_NODE;
                }
            }
            else{
                //åIDȥID顢å󥸥֤
                JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(
                            new JobSessionJobPK(sessionId, jobId));
                
                //ơ
                status = sessionJob.getStatus().intValue();
                
                //֥פ
                if(sessionJob.getJobInfo().getJob_type().intValue() == JobConstant.TYPE_JOB){
                    jobType = JobOperationJudgment.TYPE_JOB;
                }
                else{
                    jobType = JobOperationJudgment.TYPE_JOBNET;
                }
            }
        } catch (Exception e) {

        }
        
        //֥פȥ֤Υơǽå
        if(JobOperationJudgment.judgment(control.intValue(), jobType, status)){
            if(control.intValue() == JobOperationConstant.TYPE_START_AT_ONCE){
                //[¨]
        	    try {
                    new OperateStartOfJob().startJob(sessionId, jobId, facilityId);
                } catch (FinderException e) {
                    AplLogger apllog = new AplLogger("JOB", "job");
                    String[] args = {sessionId, jobId, facilityId};
                    apllog.put("SYS", "007", args);
                    m_log.debug("operationJob() : " + e.getMessage());
                    throw e;
                } catch (NamingException e) {
                    AplLogger apllog = new AplLogger("JOB", "job");
                    String[] args = {sessionId, jobId, facilityId};
                    apllog.put("SYS", "007", args);
                    m_log.debug("operationJob() : " + e.getMessage());
                    throw e;
                } catch (EJBException e) {
                    AplLogger apllog = new AplLogger("JOB", "job");
                    String[] args = {sessionId, jobId, facilityId};
                    apllog.put("SYS", "007", args);
                    m_log.debug("operationJob() : " + e.getMessage());
                    throw e;
				} catch (RemoveException e) {
                    AplLogger apllog = new AplLogger("JOB", "job");
                    String[] args = {sessionId, jobId, facilityId};
                    apllog.put("SYS", "007", args);
                    m_log.debug("operationJob() : " + e.getMessage());
				}
            }
            else if(control.intValue() == JobOperationConstant.TYPE_START_SUSPEND){
                //[ǲ]
                try {
                    new OperateSuspendOfJob().releaseSuspendJob(sessionId, jobId);
                } catch (FinderException e) {
                    AplLogger apllog = new AplLogger("JOB", "job");
                    String[] args = {sessionId, jobId};
                    apllog.put("SYS", "008", args);
                    m_log.debug("operationJob() : " + e.getMessage());
                    throw e;
                } catch (NamingException e) {
                    AplLogger apllog = new AplLogger("JOB", "job");
                    String[] args = {sessionId, jobId, facilityId};
                    apllog.put("SYS", "008", args);
                    m_log.debug("operationJob() : " + e.getMessage());
                    throw e;
                }
            }
            else if(control.intValue() == JobOperationConstant.TYPE_START_WAIT){
                //[α]
                try {
                    new OperateWaitOfJob().releaseWaitJob(sessionId, jobId);
                } catch (FinderException e) {
                    AplLogger apllog = new AplLogger("JOB", "job");
                    String[] args = {sessionId, jobId, facilityId};
                    apllog.put("SYS", "009", args);
                    m_log.debug("operationJob() : " + e.getMessage());
                    throw e;
                } catch (NamingException e) {
                    AplLogger apllog = new AplLogger("JOB", "job");
                    String[] args = {sessionId, jobId, facilityId};
                    apllog.put("SYS", "009", args);
                    m_log.debug("operationJob() : " + e.getMessage());
                    throw e;
                }
            }
            else if(control.intValue() == JobOperationConstant.TYPE_START_SKIP){
                //[åײ]
                try {
                    new OperateSkipOfJob().releaseSkipJob(sessionId, jobId);
                } catch (FinderException e) {
                    AplLogger apllog = new AplLogger("JOB", "job");
                    String[] args = {sessionId, jobId, facilityId};
                    apllog.put("SYS", "010", args);
                    m_log.debug("operationJob() : " + e.getMessage());
                    throw e;
                } catch (NamingException e) {
                    AplLogger apllog = new AplLogger("JOB", "job");
                    String[] args = {sessionId, jobId, facilityId};
                    apllog.put("SYS", "010", args);
                    m_log.debug("operationJob() : " + e.getMessage());
                    throw e;
                }
            }
            else if(control.intValue() == JobOperationConstant.TYPE_STOP_AT_ONCE){
                try {
                    //[¨]
                    new OperateStopOfJob().stopJob(sessionId, jobId, facilityId);
                } catch (FinderException e) {
                    AplLogger apllog = new AplLogger("JOB", "job");
                    String[] args = {sessionId, jobId, facilityId};
                    apllog.put("SYS", "011", args);
                    m_log.debug("operationJob() : " + e.getMessage());
                    throw e;
                } catch (NamingException e) {
                    AplLogger apllog = new AplLogger("JOB", "job");
                    String[] args = {sessionId, jobId, facilityId};
                    apllog.put("SYS", "011", args);
                    m_log.debug("operationJob() : " + e.getMessage());
                    throw e;
                }
            }
            else if(control.intValue() == JobOperationConstant.TYPE_STOP_SUSPEND){
                try {
                    //[]
                    new OperateSuspendOfJob().suspendJob(sessionId, jobId);
                } catch (FinderException e) {
                    AplLogger apllog = new AplLogger("JOB", "job");
                    String[] args = {sessionId, jobId};
                    apllog.put("SYS", "012", args);
                    m_log.debug("operationJob() : " + e.getMessage());
                    throw e;
                } catch (NamingException e) {
                    AplLogger apllog = new AplLogger("JOB", "job");
                    String[] args = {sessionId, jobId};
                    apllog.put("SYS", "012", args);
                    m_log.debug("operationJob() : " + e.getMessage());
                    throw e;
                }
            }
            else if(control.intValue() == JobOperationConstant.TYPE_STOP_WAIT){
                try {
                    //[α]
                    new OperateWaitOfJob().waitJob(sessionId, jobId);
                } catch (FinderException e) {
                    AplLogger apllog = new AplLogger("JOB", "job");
                    String[] args = {sessionId, jobId};
                    apllog.put("SYS", "012", args);
                    m_log.debug("operationJob() : " + e.getMessage());
                    throw e;
                } catch (NamingException e) {
                    AplLogger apllog = new AplLogger("JOB", "job");
                    String[] args = {sessionId, jobId};
                    apllog.put("SYS", "012", args);
                    m_log.debug("operationJob() : " + e.getMessage());
                    throw e;
                }
            }
            else if(control.intValue() == JobOperationConstant.TYPE_STOP_SKIP){
                //[å]
                if(endValue == null){
                    throw new NullPointerException();
                }
                try {
                    new OperateSkipOfJob().skipJob(sessionId, jobId, endValue);
                } catch (FinderException e) {
                    AplLogger apllog = new AplLogger("JOB", "job");
                    String[] args = {sessionId, jobId};
                    apllog.put("SYS", "013", args);
                    m_log.debug("operationJob() : " + e.getMessage());
                    throw e;
                } catch (NamingException e) {
                    AplLogger apllog = new AplLogger("JOB", "job");
                    String[] args = {sessionId, jobId};
                    apllog.put("SYS", "013", args);
                    m_log.debug("operationJob() : " + e.getMessage());
                    throw e;
                }
            }
            else if(control.intValue() == JobOperationConstant.TYPE_STOP_MAINTENANCE){
                //[]
                if(endValue == null){
                    throw new NullPointerException();
                }
                try {
                    new OperateMaintenanceOfJob().maintenanceJob(sessionId, jobId, facilityId, endValue);
                } catch (FinderException e) {
                    AplLogger apllog = new AplLogger("JOB", "job");
                    String[] args = {sessionId, jobId, facilityId};
                    apllog.put("SYS", "014", args);
                    m_log.debug("operationJob() : " + e.getMessage());
                    throw e;
                } catch (NamingException e) {
                    AplLogger apllog = new AplLogger("JOB", "job");
                    String[] args = {sessionId, jobId, facilityId};
                    apllog.put("SYS", "014", args);
                    m_log.debug("operationJob() : " + e.getMessage());
                    throw e;
                }
            }
        }
        else{
            throw new IllegalStateException();
        }
	}
	
	/**
	 * Ρɽλ
	 * 
	 * @ejb.interface-method
	 * @generated
	 * 
	 * @param info
	 * @throws FinderException
	 * @throws NamingException
	 */
	public void endNode(RunResultInfo info) throws FinderException, NamingException {
	    m_log.debug("endNode() : sessionId=" + info.getSessionId() + ", jobId=" + info.getJobId() + ", facilityId=" + info.getFacilityId());
	    
	    OperationJob operation = new OperationJob();
	    operation.endNode(info);
	}
}
