/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.factory;

import java.util.ArrayList;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.EndStatusConstant;
import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.priority.util.PriorityJudgment;

/**
 * ֽλȽꥯ饹
 *
 * @version 2.1.0
 * @since 1.0.0
 */
public class EndJudgment extends PriorityJudgment {
	protected static Log m_log = LogFactory.getLog(EndJudgment.class);
    
	/**
	 * λ֤ѥƤϤơȽꤹ
	 * 
	 * @param stausList λ֤(int)
	 * @return
	 */
	public static Integer judgment(ArrayList stausList) {
        Integer priority = null;
        Integer endStatus = null;
        boolean normal = false;
        boolean abnormal = false;
        boolean warning = false;
        boolean unknown = false;
        
        for(int i =0; i < stausList.size(); i++){
            Integer status = (Integer)stausList.get(i);

            if(status.intValue() == EndStatusConstant.TYPE_NORMAL){
                normal = true;
            }
            else if(status.intValue() == EndStatusConstant.TYPE_WARNING){
                warning = true;
            }
            else if(status.intValue() == EndStatusConstant.TYPE_ABNORMAL){
                abnormal = true;
            }
        }
        
        if(normal && !warning && !abnormal && !unknown){
    		//      | ٹ | ۾ | 
            // ѥ 1:  | ߡ | ߡ | ߡ
        	priority = (Integer)m_patternMap.get(PATTERN_1);
        }
        else if(normal && warning && !abnormal && !unknown){
    		//      | ٹ | ۾ | 
    		// ѥ 3:  |  | ߡ | ߡ
        	priority = (Integer)m_patternMap.get(PATTERN_3);
        }
        else if(!normal && warning && !abnormal && !unknown){
    		//      | ٹ | ۾ | 
    		// ѥ 5: ߡ |  | ߡ | ߡ
        	priority = (Integer)m_patternMap.get(PATTERN_5);
        }
        else if(normal && !warning && abnormal && !unknown){
    		//      | ٹ | ۾ | 
    		// ѥ 7:  | ߡ |  | ߡ 
        	priority = (Integer)m_patternMap.get(PATTERN_7);
        }
        else if(normal && warning && abnormal && !unknown){
    		//      | ٹ | ۾ | 
    		// ѥ 9:  |  |  | ߡ 
        	priority = (Integer)m_patternMap.get(PATTERN_9);
        }
        else if(!normal && warning && abnormal && !unknown){
    		//      | ٹ | ۾ | 
    		// ѥ11: ߡ |  |  | ߡ 
        	priority = (Integer)m_patternMap.get(PATTERN_11);
        }
        else if(!normal && !warning && abnormal && !unknown){
    		//      | ٹ | ۾ | 
    		// ѥ13: ߡ | ߡ |  | ߡ 
        	priority = (Integer)m_patternMap.get(PATTERN_13);
        }
        else{
            return null;
        }
        
        //٤齪λ֤Ѵ
        endStatus = changePriorityToEndStatus(priority);
        
	    return endStatus;
    }
	
	/**
	 * ٤齪λ֤Ѵ
	 * 
	 * @param priority
	 * @return
	 */
	public static Integer changePriorityToEndStatus(Integer priority) {
		if(priority.intValue() == PriorityConstant.TYPE_INFO){
			return new Integer(EndStatusConstant.TYPE_NORMAL);
		}
		else if(priority.intValue() == PriorityConstant.TYPE_WARNING){
			return new Integer(EndStatusConstant.TYPE_WARNING);
		}
		else if(priority.intValue() == PriorityConstant.TYPE_CRITICAL){
			return new Integer(EndStatusConstant.TYPE_ABNORMAL);
		}
		else {
			return null;
		}
	}
}
