/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.factory;

import java.util.ArrayList;
import java.util.HashMap;

import com.clustercontrol.bean.StatusConstant;
import com.clustercontrol.jobmanagement.bean.JobOperationConstant;

/**
 * Ƚꥯ饹
 *
 * @version 2.0.0
 * @since 1.0.0
 */
public class JobOperationJudgment {
    protected static HashMap<Integer, ArrayList> m_statusPatternMap = new HashMap<Integer, ArrayList>();
    protected static HashMap<Integer, ArrayList> m_jobPatternMap = new HashMap<Integer, ArrayList>();
    public static final int TYPE_JOBNET = 0;
    public static final int TYPE_JOB = 1;
    public static final int TYPE_NODE = 2;
    
	static{
		// ΥơΥѥϥåݻ

	    //[¨]
	    ArrayList<Integer> operation = new ArrayList<Integer>();
	    operation.add(new Integer(StatusConstant.TYPE_SUSPEND));
	    operation.add(new Integer(StatusConstant.TYPE_STOP));
	    operation.add(new Integer(StatusConstant.TYPE_END));
	    operation.add(new Integer(StatusConstant.TYPE_MODIFIED));
	    operation.add(new Integer(StatusConstant.TYPE_ERROR));
	    m_statusPatternMap.put(
	            new Integer(JobOperationConstant.TYPE_START_AT_ONCE), operation);
	    
	    //[ǲ]
	    operation = new ArrayList<Integer>();
	    operation.add(new Integer(StatusConstant.TYPE_SUSPEND));
	    m_statusPatternMap.put(
	            new Integer(JobOperationConstant.TYPE_START_SUSPEND), operation);
	    
	    //[α]
	    operation = new ArrayList<Integer>();
	    operation.add(new Integer(StatusConstant.TYPE_RESERVING));
	    m_statusPatternMap.put(
	            new Integer(JobOperationConstant.TYPE_START_WAIT), operation);
	    
	    //[åײ]
	    operation = new ArrayList<Integer>();
	    operation.add(new Integer(StatusConstant.TYPE_SKIP));
	    m_statusPatternMap.put(
	            new Integer(JobOperationConstant.TYPE_START_SKIP), operation);
	    
	    //[¨]
	    operation = new ArrayList<Integer>();
	    operation.add(new Integer(StatusConstant.TYPE_RUNNING));
	    m_statusPatternMap.put(
	            new Integer(JobOperationConstant.TYPE_STOP_AT_ONCE), operation);
	    
	    //[]
	    operation = new ArrayList<Integer>();
	    operation.add(new Integer(StatusConstant.TYPE_RUNNING));
	    m_statusPatternMap.put(
	            new Integer(JobOperationConstant.TYPE_STOP_SUSPEND), operation);
	    
	    //[α]
	    operation = new ArrayList<Integer>();
	    operation.add(new Integer(StatusConstant.TYPE_WAIT));
	    m_statusPatternMap.put(
	            new Integer(JobOperationConstant.TYPE_STOP_WAIT), operation);
	    
	    //[å]
	    operation = new ArrayList<Integer>();
	    operation.add(new Integer(StatusConstant.TYPE_WAIT));
	    m_statusPatternMap.put(
	            new Integer(JobOperationConstant.TYPE_STOP_SKIP), operation);
	    
	    //[]
	    operation = new ArrayList<Integer>();
	    operation.add(new Integer(StatusConstant.TYPE_END));
	    operation.add(new Integer(StatusConstant.TYPE_MODIFIED));
	    operation.add(new Integer(StatusConstant.TYPE_STOP));
	    operation.add(new Integer(StatusConstant.TYPE_ERROR));
	    m_statusPatternMap.put(
	            new Integer(JobOperationConstant.TYPE_STOP_MAINTENANCE), operation);
	    
	    
		// Υ֥Υѥϥåݻ

	    //[¨]
	    operation = new ArrayList<Integer>();
	    operation.add(new Integer(TYPE_NODE));
	    operation.add(new Integer(TYPE_JOB));
	    operation.add(new Integer(TYPE_JOBNET));
	    m_jobPatternMap.put(
	            new Integer(JobOperationConstant.TYPE_START_AT_ONCE), operation);
	    
	    //[ǲ]
	    operation = new ArrayList<Integer>();
	    operation.add(new Integer(TYPE_JOB));
	    operation.add(new Integer(TYPE_JOBNET));
	    m_jobPatternMap.put(
	            new Integer(JobOperationConstant.TYPE_START_SUSPEND), operation);
	    
	    //[α]
	    operation = new ArrayList<Integer>();
	    operation.add(new Integer(TYPE_JOB));
	    operation.add(new Integer(TYPE_JOBNET));
	    m_jobPatternMap.put(
	            new Integer(JobOperationConstant.TYPE_START_WAIT), operation);
	    
	    //[åײ]
	    operation = new ArrayList<Integer>();
	    operation.add(new Integer(TYPE_JOB));
	    operation.add(new Integer(TYPE_JOBNET));
	    m_jobPatternMap.put(
	            new Integer(JobOperationConstant.TYPE_START_SKIP), operation);

	    //[¨]
	    operation = new ArrayList<Integer>();
	    operation.add(new Integer(TYPE_NODE));
	    operation.add(new Integer(TYPE_JOB));
	    operation.add(new Integer(TYPE_JOBNET));
	    m_jobPatternMap.put(
	            new Integer(JobOperationConstant.TYPE_STOP_AT_ONCE), operation);
	    
	    //[]
	    operation = new ArrayList<Integer>();
	    operation.add(new Integer(TYPE_JOB));
	    operation.add(new Integer(TYPE_JOBNET));
	    m_jobPatternMap.put(
	            new Integer(JobOperationConstant.TYPE_STOP_SUSPEND), operation);
	    
	    //[α]
	    operation = new ArrayList<Integer>();
	    operation.add(new Integer(TYPE_JOB));
	    operation.add(new Integer(TYPE_JOBNET));
	    m_jobPatternMap.put(
	            new Integer(JobOperationConstant.TYPE_STOP_WAIT), operation);
	    
	    //[å]
	    operation = new ArrayList<Integer>();
	    operation.add(new Integer(TYPE_JOB));
	    operation.add(new Integer(TYPE_JOBNET));
	    m_jobPatternMap.put(
	            new Integer(JobOperationConstant.TYPE_STOP_SKIP), operation);
	    
	    //[]
	    operation = new ArrayList<Integer>();
	    operation.add(new Integer(TYPE_NODE));
	    operation.add(new Integer(TYPE_JOB));
	    operation.add(new Integer(TYPE_JOBNET));
	    m_jobPatternMap.put(
	            new Integer(JobOperationConstant.TYPE_STOP_MAINTENANCE), operation);
	}
    
	/**
	 * β/ԲĤѥƤϤơȽꤹ
	 * 
	 * @param operation
	 * @param jobType
	 * @param status
	 * @return
	 */
	public static boolean judgment(int operation, int jobType, int status) {
        Integer jobOperation = new Integer(operation);
	    boolean jobCheck = false;
	    boolean statusCheck = false;
	    
	    //֥פǥå
        ArrayList list = (ArrayList)m_jobPatternMap.get(jobOperation);
        if(list != null){
	        for(int i = 0; i < list.size(); i++){
	            if(((Integer)list.get(i)).intValue() == jobType){
	                jobCheck = true;
	                break;
	            }
	        }
        }

	    //ơǥå
        list = (ArrayList)m_statusPatternMap.get(jobOperation);
        if(list != null){
	        for(int i = 0; i < list.size(); i++){
	            if(((Integer)list.get(i)).intValue() == status){
	                statusCheck = true;
	                break;
	            }
	        }
        }
        
        if(jobCheck && statusCheck){
            return true;
        }
        else{
            return false;
        }
    }
}
