/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.factory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;

import com.clustercontrol.bean.JobConstant;
import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyConstant;
import com.clustercontrol.jobmanagement.bean.JobOperationConstant;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobPK;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionNodeLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionNodePK;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionNodeUtil;
import com.clustercontrol.util.Messages;

/**
 * ѥץѥƥ饹
 *
 * @version 2.0.0
 * @since 1.0.0
 */
public class JobOperationProperty {
    public static final String SESSION = "session";
    public static final String JOB = "job";
    public static final String FACILITY = "facility";
    public static final String CONTROL = "control";
    public static final String END_VALUE = "endValue";
    
	/**
	 * ѥץѥƥ֤ޤ
	 * 
	 * @param local
	 * @return ѥץѥƥ
	 */
	public Property getStartProperty(String sessionId, String jobId, String facilityId, Locale locale) {
	    //åID
		Property session =
			new Property(SESSION, Messages.getString("session.id", locale), PropertyConstant.EDITOR_TEXT);
	    //ID
		Property job =
			new Property(JOB, Messages.getString("job.id", locale), PropertyConstant.EDITOR_TEXT);
	    //եƥID
		Property facility =
			new Property(FACILITY, Messages.getString("facility.id", locale), PropertyConstant.EDITOR_TEXT);
		//
		Property control =
			new Property(CONTROL, Messages.getString("control", locale), PropertyConstant.EDITOR_SELECT);
        
	    int status = 0;
	    int jobType = 0;
	    
	    try {
            if(facilityId != null && facilityId.length() > 0){
                //åIDȥID顢å󥸥֤
                JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(
                            new JobSessionJobPK(sessionId, jobId));
                
                //֥פ
                if(sessionJob.getJobInfo().getJob_type().intValue() == JobConstant.TYPE_FILEJOB){
                	jobId = jobId + "_" + facilityId;
                	facilityId = null;
                	
                	//åIDȥID顢å󥸥֤
                    JobSessionJobLocal childSessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(
                            new JobSessionJobPK(sessionId, jobId));
	                
	                //ơ
	                status = childSessionJob.getStatus().intValue();
	                
	                //֥פ
	                jobType = JobOperationJudgment.TYPE_JOBNET;
                }
                else{
	                //åIDȥID顢å󥸥֤
	                JobSessionNodeLocal sessionNode = 
	                    JobSessionNodeUtil.getLocalHome().findByPrimaryKey(
	                            new JobSessionNodePK(sessionId, jobId, facilityId));
	                
	                //ơ
	                status = sessionNode.getStatus().intValue();
	                
	                //֥פ
	                jobType = JobOperationJudgment.TYPE_NODE;
                }
            }
            else{
                //åIDȥID顢å󥸥֤
                JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(
                            new JobSessionJobPK(sessionId, jobId));
                
                //ơ
                status = sessionJob.getStatus().intValue();
                
                //֥פ
                if(sessionJob.getJobInfo().getJob_type().intValue() == JobConstant.TYPE_JOB){
                    jobType = JobOperationJudgment.TYPE_JOB;
                }
                else{
                    jobType = JobOperationJudgment.TYPE_JOBNET;
                }
            }
        } catch (Exception e) {

        }
        
        ArrayList<String> values = new ArrayList<String>();
		if(JobOperationJudgment.judgment(JobOperationConstant.TYPE_START_AT_ONCE, jobType, status)){
		    values.add(JobOperationConstant.STRING_START_AT_ONCE);
		}
		if(JobOperationJudgment.judgment(JobOperationConstant.TYPE_START_SUSPEND, jobType, status)){
		    values.add(JobOperationConstant.STRING_START_SUSPEND);
		}
		if(JobOperationJudgment.judgment(JobOperationConstant.TYPE_START_WAIT, jobType, status)){
		    values.add(JobOperationConstant.STRING_START_WAIT);
		}
		if(JobOperationJudgment.judgment(JobOperationConstant.TYPE_START_SKIP, jobType, status)){
		    values.add(JobOperationConstant.STRING_START_SKIP);
		}
		
		//ͤ
		Object controlValues[][] = {values.toArray(), values.toArray()};
		
		control.setSelectValues(controlValues);
		if(values.size() >= 1){
		    control.setValue(values.get(0));
		}
		else{
		    control.setValue("");
		}
		
		session.setValue(sessionId);
		job.setValue(jobId);
		if(facilityId != null && facilityId.length() > 0){
		    facility.setValue(facilityId);
		}
		else{
		    facility.setValue("");
		}
		
		//ѹβ/ԲĤ
		session.setModify(PropertyConstant.MODIFY_NG);
		job.setModify(PropertyConstant.MODIFY_NG);
		facility.setModify(PropertyConstant.MODIFY_NG);
		control.setModify(PropertyConstant.MODIFY_OK);

		Property property = new Property(null, null, "");
		
		// ɽĥ꡼
		property.removeChildren();
		property.addChildren(session);
		property.addChildren(job);
		if(facilityId != null && facilityId.length() > 0){
		    property.addChildren(facility);
		}
		property.addChildren(control);
		
		return property;
	}
	
	/**
	 * ѥץѥƥ֤ޤ
	 * 
	 * @param local
	 * @return ѥץѥƥ
	 */
	@SuppressWarnings("unchecked")
	public Property getStopProperty(String sessionId, String jobId, String facilityId, Locale locale) {
	    //åID
		Property session =
			new Property(SESSION, Messages.getString("session.id", locale), PropertyConstant.EDITOR_TEXT);
	    //ID
		Property job =
			new Property(JOB, Messages.getString("job.id", locale), PropertyConstant.EDITOR_TEXT);
	    //եƥID
		Property facility =
			new Property(FACILITY, Messages.getString("facility.id", locale), PropertyConstant.EDITOR_TEXT);
		//
		Property control =
			new Property(CONTROL, Messages.getString("control", locale), PropertyConstant.EDITOR_SELECT);
	    //λ
		Property endValue =
			new Property(END_VALUE, Messages.getString("end.value", locale), PropertyConstant.EDITOR_NUM);
		
	    ArrayList endList = new ArrayList();
	    endList.add(endValue);
	    
	    HashMap skipEndMap = new HashMap();
	    skipEndMap.put("value", JobOperationConstant.STRING_STOP_SKIP);
	    skipEndMap.put("property", endList);
	    
	    HashMap mainteEndMap = new HashMap();
	    mainteEndMap.put("value", JobOperationConstant.STRING_STOP_MAINTENANCE);
	    mainteEndMap.put("property", endList);
	    
	    int status = 0;
	    int jobType = 0;
	    
	    try {
            if(facilityId != null && facilityId.length() > 0){
                //åIDȥID顢å󥸥֤
                JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(
                            new JobSessionJobPK(sessionId, jobId));
                
                //֥פ
                if(sessionJob.getJobInfo().getJob_type().intValue() == JobConstant.TYPE_FILEJOB){
                	jobId = jobId + "_" + facilityId;
                	facilityId = null;
                	
                	//åIDȥID顢å󥸥֤
                    JobSessionJobLocal childSessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(
                            new JobSessionJobPK(sessionId, jobId));
	                
	                //ơ
	                status = childSessionJob.getStatus().intValue();
	                
	                //֥פ
	                jobType = JobOperationJudgment.TYPE_JOBNET;
                }
                else{
	                //åIDȥID顢å󥸥֤
	                JobSessionNodeLocal sessionNode = 
	                    JobSessionNodeUtil.getLocalHome().findByPrimaryKey(
	                            new JobSessionNodePK(sessionId, jobId, facilityId));
	                
	                //ơ
	                status = sessionNode.getStatus().intValue();
	                
	                //֥פ
	                jobType = JobOperationJudgment.TYPE_NODE;
                }
            }
            else{
                //åIDȥID顢å󥸥֤
                JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(
                            new JobSessionJobPK(sessionId, jobId));
                
                //ơ
                status = sessionJob.getStatus().intValue();
                
                //֥פ
                if(sessionJob.getJobInfo().getJob_type().intValue() == JobConstant.TYPE_JOB){
                    jobType = JobOperationJudgment.TYPE_JOB;
                }
                else{
                    jobType = JobOperationJudgment.TYPE_JOBNET;
                }
            }
        } catch (Exception e) {

        }
        
        ArrayList<String> values1 = new ArrayList<String>();
        ArrayList values2 = new ArrayList();
		if(JobOperationJudgment.judgment(JobOperationConstant.TYPE_STOP_AT_ONCE, jobType, status)){
		    values1.add(JobOperationConstant.STRING_STOP_AT_ONCE);
		    values2.add(JobOperationConstant.STRING_STOP_AT_ONCE);
		}
		if(JobOperationJudgment.judgment(JobOperationConstant.TYPE_STOP_SUSPEND, jobType, status)){
		    values1.add(JobOperationConstant.STRING_STOP_SUSPEND);
		    values2.add(JobOperationConstant.STRING_STOP_SUSPEND);
		}
		if(JobOperationJudgment.judgment(JobOperationConstant.TYPE_STOP_WAIT, jobType, status)){
		    values1.add(JobOperationConstant.STRING_STOP_WAIT);
		    values2.add(JobOperationConstant.STRING_STOP_WAIT);
		}
		if(JobOperationJudgment.judgment(JobOperationConstant.TYPE_STOP_SKIP, jobType, status)){
		    values1.add(JobOperationConstant.STRING_STOP_SKIP);
		    values2.add(skipEndMap);
		}
		if(JobOperationJudgment.judgment(JobOperationConstant.TYPE_STOP_MAINTENANCE, jobType, status)){
		    values1.add(JobOperationConstant.STRING_STOP_MAINTENANCE);
		    values2.add(mainteEndMap);
		}
		
		//ͤ
		Object controlValues[][] = {values1.toArray(), values2.toArray()};
		
		control.setSelectValues(controlValues);
		if(values1.size() >= 1){
		    control.setValue(values1.get(0));
		}
		else{
		    control.setValue("");
		}
		
		endValue.setValue("");
		
		session.setValue(sessionId);
		job.setValue(jobId);
		if(facilityId != null && facilityId.length() > 0){
		    facility.setValue(facilityId);
		}
		else{
		    facility.setValue("");
		}
		
		//ѹβ/ԲĤ
		session.setModify(PropertyConstant.MODIFY_NG);
		job.setModify(PropertyConstant.MODIFY_NG);
		facility.setModify(PropertyConstant.MODIFY_NG);
		control.setModify(PropertyConstant.MODIFY_OK);
		endValue.setModify(PropertyConstant.MODIFY_OK);

		Property property = new Property(null, null, "");
		
		// ɽĥ꡼
		property.removeChildren();
		property.addChildren(session);
		property.addChildren(job);
		if(facilityId != null && facilityId.length() > 0){
		    property.addChildren(facility);
		}
		property.addChildren(control);
		
		if(JobOperationConstant.STRING_STOP_SKIP.compareTo((String)control.getValue()) == 0 || 
		        JobOperationConstant.STRING_STOP_MAINTENANCE.compareTo((String)control.getValue()) == 0){
		    control.addChildren(endValue);
		}
		
		return property;
	}
}
