/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.factory;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.StatusConstant;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobPK;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobUtil;

/**
 * å׽饹
 *
 * @version 2.1.0
 * @since 2.1.0
 */
public class OperateSkipOfJob extends OperationJob {
	protected static Log m_log = LogFactory.getLog( OperateSkipOfJob.class );

	public OperateSkipOfJob(){
		super();
	}
	
	/**
	 * ֥åײʳ[åײ]
	 * 
	 * @param sessionId
	 * @param jobId
	 * @throws FinderException
	 * @throws NamingException
	 */
	public void releaseSkipJob(String sessionId, String jobId) throws FinderException, NamingException {
		m_log.debug("releaseSkipJob() : sessionId=" + sessionId + ", jobId=" + jobId);
		
		//åIDȥID顢å󥸥֤
		JobSessionJobLocal sessionJob = 
			JobSessionJobUtil.getLocalHome().findByPrimaryKey(
					new JobSessionJobPK(sessionId, jobId));
		
		if(sessionJob != null){
			//ơåפξ
			if(sessionJob.getStatus().intValue() == StatusConstant.TYPE_SKIP){
				//ơԵˤ
				sessionJob.setStatus(new Integer(StatusConstant.TYPE_WAIT));
				//λͤ򥯥ꥢ
				sessionJob.setEnd_value(null);
			}
		}
	}
	
	/**
	 * ֥åס[å]
	 * 
	 * @param sessionId
	 * @param jobId
	 * @param endStatus
	 * @param endValue
	 * @throws FinderException
	 * @throws NamingException
	 */
	public void skipJob(
			String sessionId, 
			String jobId, 
			Integer endValue) throws FinderException, NamingException {
		
		m_log.debug("skipJob() : sessionId=" + sessionId + ", jobId=" + jobId + ", endValue=" + endValue);
		
		//åIDȥID顢å󥸥֤
		JobSessionJobLocal sessionJob = 
			JobSessionJobUtil.getLocalHome().findByPrimaryKey(
					new JobSessionJobPK(sessionId, jobId));
		
		if(sessionJob != null){
			//ơԵξ硢ơ򥹥åפˤ
			if(sessionJob.getStatus().intValue() == StatusConstant.TYPE_WAIT){
				sessionJob.setStatus(new Integer(StatusConstant.TYPE_SKIP));
				//λͤ
				sessionJob.setEnd_value(endValue);
			}
		}
	}
}
