/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.factory;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;

import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobDetail;
import org.quartz.SchedulerException;
import org.quartz.jobs.ee.ejb.EJBInvokerJob;

import com.clustercontrol.bean.Schedule;
import com.clustercontrol.jobmanagement.bean.QuartzConstant;
import com.clustercontrol.jobmanagement.util.QuartzUtil;
import com.clustercontrol.quartzmanager.ejb.session.QuartzManager;

/**
 * 塼븡饹
 *
 * @version 1.0.0
 * @since 1.0.0
 */
public class SelectSchedule {
    protected static Log m_log = LogFactory.getLog( SelectSchedule.class );
    
	/**
	 * 塼
	 * 
     * @return
     * @throws NamingException
     * @throws SchedulerException
     */
    @SuppressWarnings("unchecked")
	public ArrayList getScheduleList() throws NamingException, SchedulerException {
        m_log.debug("getScheduleList()");
        
        ArrayList list = new ArrayList();
        
        //QuartzScheduleråå
		QuartzManager manager = QuartzUtil.getQuartzManager();
		
        //̾ꥹȼ
        String[] jobs = null;
		try {
			jobs = manager.getJobs(QuartzConstant.GROUP_NAME);
		} catch (RemoteException e) {
		}
        for(int i = 0; i < jobs.length; i++){
            //(JobDetail)
            JobDetail job = null;
			try {
				job = manager.getJobDetail(jobs[i], QuartzConstant.GROUP_NAME);
			} catch (RemoteException e) {
			}

            ArrayList info = new ArrayList();
            //塼ID
            info.add(job.getName());
            //塼̾
            info.add(job.getDescription());
            //ID
            Object[] jdArgs = (Object[])job.getJobDataMap().get(EJBInvokerJob.EJB_ARGS_KEY);
            info.add((String)jdArgs[0]);
            //̾
            String jobName = (String)job.getJobDataMap().get(QuartzConstant.JOB_NAME_KEY);
            info.add(jobName);
            //ID
            if(jdArgs.length > 1){
            	info.add((String)jdArgs[1]);
            }
            else{
            	info.add("");
            }
            //塼
            Schedule schedule = (Schedule)job.getJobDataMap().get(QuartzConstant.SCHEDULE_KEY);
            info.add(schedule);
            //ͭ/̵
            Integer valid = (Integer)job.getJobDataMap().get(QuartzConstant.VALID_KEY);
            info.add(valid);
            //ϿԤ
            String createUser = (String)job.getJobDataMap().get(QuartzConstant.CREATE_USER_KEY);
            info.add(createUser);
            //Ͽ
            Date createDate = (Date)job.getJobDataMap().get(QuartzConstant.CREATE_DATE_KEY);
            info.add(createDate);
            //Ԥ
            String upadteUser = (String)job.getJobDataMap().get(QuartzConstant.UPDATE_USER_KEY);
            info.add(upadteUser);
            //
            Date upadteDate = (Date)job.getJobDataMap().get(QuartzConstant.UPDATE_DATE_KEY);
            info.add(upadteDate);

            
            list.add(info);
        }
	    return list;
    }
}
