/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.action;

import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

import com.clustercontrol.jobmanagement.bean.JobInfo;
import com.clustercontrol.jobmanagement.bean.JobTreeItem;
import com.clustercontrol.jobmanagement.composite.JobTreeComposite;
import com.clustercontrol.jobmanagement.view.JobListView;

/**
 * ֳؾ饹
 * 
 * Ф饸ֳؾ
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class GetJobTreeOneLevel {

    /**
     * ֳؾ
     * 
     * @return ֳؾ
     * @since 1.0.0
     */
    public JobTreeItem getJobTreeOneLevel(String parentJobId, String jobId) {
        //ƥ֥ڡ
        IWorkbenchPage page = PlatformUI.getWorkbench()
                .getActiveWorkbenchWindow().getActivePage();
        IViewPart viewPart = page.findView(JobListView.ID);
        JobListView view = (JobListView) viewPart.getAdapter(JobListView.class);
        JobTreeComposite composite = view.getJobTreeComposite();
        JobTreeItem tree = (JobTreeItem) composite.getTreeViewer().getInput();
        JobTreeItem top = tree.getChildren(0);
        JobTreeItem item = findJobTreeItem(parentJobId, tree);

        JobTreeItem treeitem = new JobTreeItem(null,
                copyJobInfo(tree.getData()));
        JobTreeItem topItem = new JobTreeItem(treeitem, copyJobInfo(top
                .getData()));

        for (int i = 0; i < item.getChildren().length; i++) {
            JobTreeItem child = item.getChildren(i);
            if (jobId.compareTo(child.getData().getId()) != 0) {
                @SuppressWarnings("unused")
                JobTreeItem childItem = new JobTreeItem(topItem,
                        copyJobInfo(child.getData()));
            }
        }

        return treeitem;
    }

    /**
     * JobInfoԡ
     * 
     * @param orgInfo
     * @return
     */
    protected JobInfo copyJobInfo(JobInfo orgInfo) {

        JobInfo info = new JobInfo(orgInfo.getId(), orgInfo.getName(), orgInfo
                .getType());

        return info;
    }

    /**
     * JobTreeItem
     * 
     * @param jobId
     * @param item
     * @return
     */
    protected JobTreeItem findJobTreeItem(String jobId, JobTreeItem item) {
        JobTreeItem findItem = null;

        if (item.getData().getId().compareTo(jobId) == 0) {
            return item;
        }

        for (int i = 0; i < item.getChildren().length; i++) {
            JobTreeItem childItem = item.getChildren(i);
            findItem = findJobTreeItem(jobId, childItem);
            if (findItem != null) {
                return findItem;
            }
        }

        return null;
    }
}