/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.action;

import java.util.ArrayList;
import java.util.HashMap;

import com.clustercontrol.bean.EndStatusConstant;
import com.clustercontrol.bean.JudgmentObjectConstant;
import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyConstant;
import com.clustercontrol.jobmanagement.composite.JobPropertyDefine;
import com.clustercontrol.util.Messages;

/**
 * Ԥѥץѥƥ饹
 * 
 * @version 2.1.0
 * @since 1.0.0
 */
public class WaitRuleProperty {
    /** Ƚо */
    public static final String ID_JUDGMENT_OBJECT = "judgmentObject";

    /** ID */
    public static final String ID_JOB_ID = "jobId";

    /** ͡ʽλ֡ */
    public static final String ID_CONDITION_END_STATUS = "conditionEndStatus";

    /** ͡ʽλ͡ */
    public static final String ID_CONDITION_END_VALUE = "conditionEndValue";
    
    /** ϻ */
    public static final String ID_TIME = "time";

    /**
     * Ԥѥץѥƥ֤ޤ
     * 
     * @param local
     * @return Ԥѥץѥƥ
     */
    @SuppressWarnings("unchecked")
	public Property getProperty(String parentJobId, String jobId, int type) {
        //ץѥƥ
        Property judgmentObject = new Property(ID_JUDGMENT_OBJECT, Messages
                .getString("name"), PropertyConstant.EDITOR_SELECT);
        Property job = new Property(ID_JOB_ID, Messages.getString("job.id"),
                PropertyConstant.EDITOR_JOB);
        Property conditionEndStatus = new Property(ID_CONDITION_END_STATUS, Messages
                .getString("value"), PropertyConstant.EDITOR_SELECT);
        Property conditionEndValue = new Property(ID_CONDITION_END_VALUE, Messages
                .getString("value"), PropertyConstant.EDITOR_NUM);
        Property time = new Property(ID_TIME, Messages
                .getString("wait.rule.time.example"),
                PropertyConstant.EDITOR_TIME);

        //JobPropertyDefine饹ClusterControlǤƤʤ
        JobPropertyDefine define = new JobPropertyDefine(parentJobId, jobId);
        job.setDefine(define);

        //ֽλ
        ArrayList jobEndStatusPropertyList = new ArrayList();
        jobEndStatusPropertyList.add(job);
        jobEndStatusPropertyList.add(conditionEndStatus);

        HashMap jobEndStatusMap = new HashMap();
        jobEndStatusMap.put("value", JudgmentObjectConstant.STRING_JOB_END_STAUS);
        jobEndStatusMap.put("property", jobEndStatusPropertyList);

        //ֽλ
        ArrayList jobEndValuePropertyList = new ArrayList();
        jobEndValuePropertyList.add(job);
        jobEndValuePropertyList.add(conditionEndValue);
        
        HashMap jobEndValueMap = new HashMap();
        jobEndValueMap.put("value", JudgmentObjectConstant.STRING_JOB_END_VALUE);
        jobEndValueMap.put("property", jobEndValuePropertyList);
        
        //
        ArrayList timePropertyList = new ArrayList();
        timePropertyList.add(time);

        HashMap timeMap = new HashMap();
        timeMap.put("value", JudgmentObjectConstant.STRING_TIME);
        timeMap.put("property", timePropertyList);

        //Ƚоݥܥܥå
        Object judgmentObjectValues[][] = {
                { JudgmentObjectConstant.STRING_JOB_END_STAUS,
                	JudgmentObjectConstant.STRING_JOB_END_VALUE,
                	JudgmentObjectConstant.STRING_TIME },
                { jobEndStatusMap, jobEndValueMap, timeMap } };

        Object conditionEndStatuss[][] = {
                { EndStatusConstant.STRING_NORMAL,
                        EndStatusConstant.STRING_WARNING,
                        EndStatusConstant.STRING_ABNORMAL },
                { EndStatusConstant.STRING_NORMAL,
                        EndStatusConstant.STRING_WARNING,
                        EndStatusConstant.STRING_ABNORMAL } };

        judgmentObject.setSelectValues(judgmentObjectValues);
        conditionEndStatus.setSelectValues(conditionEndStatuss);

        //ͤ
        judgmentObject.setValue("");
        job.setValue("");
        conditionEndStatus.setValue("");
        time.setValue("");

        //ѹβ/ԲĤ
        judgmentObject.setModify(PropertyConstant.MODIFY_OK);
        job.setModify(PropertyConstant.MODIFY_OK);
        conditionEndStatus.setModify(PropertyConstant.MODIFY_OK);
        conditionEndValue.setModify(PropertyConstant.MODIFY_OK);
        time.setModify(PropertyConstant.MODIFY_OK);

        Property property = new Property(null, null, null);

        if (type == JudgmentObjectConstant.TYPE_JOB_END_STAUS) {
            judgmentObject.setValue(JudgmentObjectConstant.STRING_JOB_END_STAUS);

            // ɽĥ꡼
            property.removeChildren();
            property.addChildren(judgmentObject);

            // Ƚоݥĥ꡼
            judgmentObject.removeChildren();
            judgmentObject.addChildren(job);
            judgmentObject.addChildren(conditionEndStatus);
        }
        else if (type == JudgmentObjectConstant.TYPE_JOB_END_VALUE) {
            judgmentObject.setValue(JudgmentObjectConstant.STRING_JOB_END_VALUE);

            // ɽĥ꡼
            property.removeChildren();
            property.addChildren(judgmentObject);

            // Ƚоݥĥ꡼
            judgmentObject.removeChildren();
            judgmentObject.addChildren(job);
            judgmentObject.addChildren(conditionEndValue);
        }
        else {
            judgmentObject.setValue(JudgmentObjectConstant.STRING_TIME);

            // ɽĥ꡼
            property.removeChildren();
            property.addChildren(judgmentObject);

            // Ƚоݥĥ꡼
            judgmentObject.removeChildren();
            judgmentObject.addChildren(time);
        }

        return property;
    }
}