/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.composite;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import com.clustercontrol.bean.EndStatusConstant;
import com.clustercontrol.bean.FacilityConstant;
import com.clustercontrol.bean.FacilityPath;
import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.bean.ProcessingMethodConstant;
import com.clustercontrol.bean.SizeConstant;
import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.composite.NumberVerifyListener;
import com.clustercontrol.dialog.ScopeTreeDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.jobmanagement.bean.JobCommandInfo;
import com.clustercontrol.jobmanagement.bean.SystemParameterConstant;
import com.clustercontrol.ui.ClusterControlUIPlugin;
import com.clustercontrol.util.Messages;

/**
 * ¹ƥݥåȥ饹
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class CommandComposite extends Composite {
    protected Text m_scope = null;

    protected Text m_startCommand = null;

    protected Text m_stopCommand = null;

    protected Text m_user = null;
    
    protected Button m_scopeJobParam = null;
    
    protected Button m_scopeFixedValue = null;

    protected Button m_scopeSelect = null;

    protected Button m_allNode = null;

    protected Button m_retry = null;

    protected Button m_errorCondition = null;

    protected Text m_errorEndValue = null;

    protected Group m_errorEndConditionGroup = null;

    protected String m_facilityId = null;

    protected String m_facilityPath = null;

    protected JobCommandInfo m_execute = null;

    protected Shell m_shell = null;

    /**
     * 󥹥ȥ饯
     * 
     * @param parent
     * @param style
     * @since 1.0.0
     */
    public CommandComposite(Composite parent, int style) {
        super(parent, style);
        initialize();
        m_shell = this.getShell();
    }

    /**
     * 
     * 
     * @since 1.0.0
     */
    private void initialize() {
        RowLayout layout = new RowLayout();
        layout.type = SWT.VERTICAL;
        layout.spacing = 10;
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.fill = true;
        this.setLayout(layout);

        Composite composite = null;
        RowLayout rowLayout = null;
        Label label = null;

        Group group = new Group(this, SWT.NONE);
        group.setText(Messages.getString("scope"));
        rowLayout = new RowLayout();
        rowLayout.type = SWT.VERTICAL;
        rowLayout.marginWidth = 10;
        rowLayout.marginHeight = 10;
        group.setLayout(rowLayout);
        
        composite = new Composite(group, SWT.NONE);
        rowLayout = new RowLayout();
        rowLayout.type = SWT.HORIZONTAL;
        rowLayout.spacing = 10;
        composite.setLayout(rowLayout);
        m_scopeJobParam = new Button(composite, SWT.RADIO);
        m_scopeJobParam.setText(Messages.getString("job.parameter") + " : ");
        m_scopeJobParam.setLayoutData(
        		new RowData(100, SizeConstant.SIZE_BUTTON_HEIGHT));
        m_scopeJobParam.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent e) {
				Button check = (Button) e.getSource();
				if (check.getSelection()) {
					m_scopeFixedValue.setSelection(false);
					m_scopeSelect.setEnabled(false);
				}
			}
			
			public void widgetDefaultSelected(SelectionEvent e) {
				
			}
		});
        label = new Label(composite, SWT.LEFT);
        label.setText(SystemParameterConstant.HEADER + 
        		SystemParameterConstant.FACILITY_ID + 
        		SystemParameterConstant.FOOTER);
        label.setLayoutData(
        		new RowData(100, SizeConstant.SIZE_LABEL_HEIGHT));
        
        composite = new Composite(group, SWT.NONE);
        rowLayout = new RowLayout();
        rowLayout.type = SWT.HORIZONTAL;
        rowLayout.spacing = 10;
        composite.setLayout(rowLayout);

        m_scopeFixedValue = new Button(composite, SWT.RADIO);
        m_scopeFixedValue.setText(Messages.getString("fixed.value") + " : ");
        m_scopeFixedValue.setLayoutData(new RowData(100,
                SizeConstant.SIZE_BUTTON_HEIGHT));
        m_scopeFixedValue.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent e) {
				Button check = (Button) e.getSource();
				if (check.getSelection()) {
					m_scopeJobParam.setSelection(false);
					m_scopeSelect.setEnabled(true);
				}
			}
			
			public void widgetDefaultSelected(SelectionEvent e) {
				
			}
		});
        m_scope = new Text(composite, SWT.BORDER | SWT.READ_ONLY);
        m_scope.setLayoutData(new RowData(200, SizeConstant.SIZE_TEXT_HEIGHT));
        m_scope.setText("");

        m_scopeSelect = new Button(composite, SWT.NONE);
        m_scopeSelect.setText(Messages.getString("refer"));
        m_scopeSelect.setLayoutData(new RowData(80,
                SizeConstant.SIZE_BUTTON_HEIGHT));
        m_scopeSelect.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent e) {
                ScopeTreeDialog dialog = new ScopeTreeDialog(m_shell);
                if (dialog.open() == IDialogConstants.OK_ID) {
                    FacilityTreeItem selectItem = dialog.getSelectItem();
                    if (selectItem.getData().getType() == FacilityConstant.TYPE_COMPOSITE) {
                        m_facilityPath = "";
                        m_facilityId = "";
                    } else {
                        FacilityPath path = new FacilityPath(
                                ClusterControlUIPlugin.getDefault()
                                        .getSeparator());
                        m_facilityPath = path.getPath(selectItem);
                        m_facilityId = selectItem.getData().getFacilityId();
                    }

                    m_scope.setText(m_facilityPath);
                }
            }
        });

        group = new Group(this, SWT.NONE);
        group.setText(Messages.getString("scope.process"));
        rowLayout = new RowLayout();
        rowLayout.type = SWT.VERTICAL;
        rowLayout.marginWidth = 10;
        rowLayout.marginHeight = 10;
        group.setLayout(rowLayout);

        m_allNode = new Button(group, SWT.RADIO);
        m_allNode.setText(Messages.getString("scope.process.all.nodes"));
        m_allNode.setLayoutData(
        		new RowData(350,SizeConstant.SIZE_BUTTON_HEIGHT));
        m_retry = new Button(group, SWT.RADIO);
        m_retry.setText(Messages.getString("scope.process.retry.nodes"));
        m_retry.setLayoutData(
        		new RowData(350, SizeConstant.SIZE_BUTTON_HEIGHT));

        composite = new Composite(this, SWT.NONE);
        rowLayout = new RowLayout();
        rowLayout.type = SWT.HORIZONTAL;
        rowLayout.spacing = 10;
        composite.setLayout(rowLayout);

        label = new Label(composite, SWT.NONE);
        label.setText(Messages.getString("start.command") + " : ");
        label.setLayoutData(new RowData(100,
                SizeConstant.SIZE_LABEL_HEIGHT));

        m_startCommand = new Text(composite, SWT.BORDER);
        m_startCommand.setLayoutData(new RowData(200,
                SizeConstant.SIZE_TEXT_HEIGHT));

        composite = new Composite(this, SWT.NONE);
        rowLayout = new RowLayout();
        rowLayout.type = SWT.HORIZONTAL;
        rowLayout.spacing = 10;
        composite.setLayout(rowLayout);

        label = new Label(composite, SWT.NONE);
        label.setText(Messages.getString("stop.command") + " : ");
        label.setLayoutData(new RowData(100,
                SizeConstant.SIZE_LABEL_HEIGHT));

        m_stopCommand = new Text(composite, SWT.BORDER);
        m_stopCommand.setLayoutData(new RowData(200,
                SizeConstant.SIZE_TEXT_HEIGHT));

        composite = new Composite(this, SWT.NONE);
        rowLayout = new RowLayout();
        rowLayout.type = SWT.HORIZONTAL;
        rowLayout.spacing = 10;
        composite.setLayout(rowLayout);

        label = new Label(composite, SWT.NONE);
        label.setText(Messages.getString("effective.user") + " : ");
        label.setLayoutData(new RowData(100, SizeConstant.SIZE_LABEL_HEIGHT));

        m_user = new Text(composite, SWT.BORDER);
        m_user.setLayoutData(new RowData(200, SizeConstant.SIZE_TEXT_HEIGHT));

        //顼λ
        composite = new Composite(this, SWT.NONE);
        rowLayout = new RowLayout();
        rowLayout.type = SWT.VERTICAL;
        composite.setLayout(rowLayout);

        m_errorCondition = new Button(composite, SWT.CHECK);
        m_errorCondition.setText(Messages.getString("command.error.ended"));
        m_errorCondition.setLayoutData(new RowData(220,
                SizeConstant.SIZE_BUTTON_HEIGHT));
        m_errorCondition.addSelectionListener(new SelectionListener() {
            public void widgetSelected(SelectionEvent e) {
                Button check = (Button) e.getSource();
                if (check.getSelection()) {
                    m_errorEndConditionGroup.setEnabled(true);
                    m_errorEndValue.setEnabled(true);
                } else {
                    m_errorEndConditionGroup.setEnabled(false);
                    m_errorEndValue.setEnabled(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {

            }
        });

        m_errorEndConditionGroup = new Group(this, SWT.NONE);
        rowLayout = new RowLayout();
        rowLayout.type = SWT.VERTICAL;
        rowLayout.marginWidth = 10;
        rowLayout.marginHeight = 10;
        rowLayout.spacing = 10;
        m_errorEndConditionGroup.setLayout(rowLayout);

        composite = new Composite(m_errorEndConditionGroup, SWT.NONE);
        rowLayout = new RowLayout();
        rowLayout.type = SWT.HORIZONTAL;
        rowLayout.spacing = 10;
        composite.setLayout(rowLayout);
        Label skipEndValueTitle = new Label(composite, SWT.LEFT);
        skipEndValueTitle.setText(Messages.getString("end.value") + " : ");
        skipEndValueTitle.setLayoutData(new RowData(80,
                SizeConstant.SIZE_LABEL_HEIGHT));
        m_errorEndValue = new Text(composite, SWT.BORDER);
        m_errorEndValue.setLayoutData(new RowData(100,
                SizeConstant.SIZE_TEXT_HEIGHT));
        m_errorEndValue.addVerifyListener(new NumberVerifyListener());
    }

    /**
     * ޥɾȿ
     *  
     */
    public void reflectCommandInfo() {
        if (m_execute instanceof JobCommandInfo) {
            //
            m_facilityPath = m_execute.getScope();
            m_facilityId = m_execute.getFacilityID();
            if(m_facilityId.equals(SystemParameterConstant.HEADER + 
            		SystemParameterConstant.FACILITY_ID + 
            		SystemParameterConstant.FOOTER)){
            	//եƥIDѿξ
            	m_facilityId = "";
            	m_facilityPath = "";
            	m_scope.setText(m_facilityPath);
            	m_scopeJobParam.setSelection(true);
            	m_scopeFixedValue.setSelection(false);
            }
            else{
	            if (m_facilityPath != null && m_facilityPath.length() > 0) {
	                m_scope.setText(m_facilityPath);
	            }
            	m_scopeJobParam.setSelection(false);
            	m_scopeFixedValue.setSelection(true);
            }
            //ˡ
            if (m_execute.getProcessingMethod() == ProcessingMethodConstant.TYPE_ALL_NODE) {
                m_allNode.setSelection(true);
            } else {
                m_retry.setSelection(true);
            }
            //ưޥ
            if (m_execute.getStartCommand() != null
                    && m_execute.getStartCommand().length() > 0) {
                m_startCommand.setText(m_execute.getStartCommand());
            }
            //ߥޥ
            if (m_execute.getStopCommand() != null
                    && m_execute.getStopCommand().length() > 0) {
                m_stopCommand.setText(m_execute.getStopCommand());
            }
            //桼
            if (m_execute.getUser() != null && m_execute.getUser().length() > 0) {
                m_user.setText(m_execute.getUser());
            }

            //顼λ
            m_errorCondition.setSelection(YesNoConstant.typeToBoolean(m_execute
                    .getErrorEndFlg()));

            //顼λ
            m_errorEndValue.setText(String
                    .valueOf(m_execute.getErrorEndValue()));
        } else {
        	m_scopeJobParam.setSelection(false);
        	m_scopeFixedValue.setSelection(true);
            m_scope.setText("");
            m_allNode.setSelection(true);
            m_startCommand.setText("");
            m_stopCommand.setText("");
            m_user.setText("");
            m_errorCondition.setSelection(false);
            m_errorEndValue.setText(String
                    .valueOf(EndStatusConstant.INITIAL_VALUE_NORMAL));

        }

        //
        if (m_scopeJobParam.getSelection()) {
			m_scopeSelect.setEnabled(false);
        } else {
			m_scopeSelect.setEnabled(true);
        }
        
        //å
        if (m_errorCondition.getSelection()) {
            m_errorEndConditionGroup.setEnabled(true);
            m_errorEndValue.setEnabled(true);
        } else {
            m_errorEndConditionGroup.setEnabled(false);
            m_errorEndValue.setEnabled(false);
        }
    }

    /**
     * ޥɾ
     * 
     * @param m_endStatus
     */
    public void setCommandInfo(JobCommandInfo execute) {
        m_execute = execute;
    }

    /**
     * ޥɾ
     * 
     * @return
     */
    public JobCommandInfo getCommandInfo() {
        return m_execute;
    }

    /**
     * ޥɾ
     * 
     * @return
     */
    public ValidateResult createCommandInfo() {
        ValidateResult result = null;

        //¹ƾ󥯥饹Υ󥹥󥹤
        m_execute = new JobCommandInfo();

        //׼
        if(m_scopeJobParam.getSelection()){
        	//ѿξ
        	m_execute.setFacilityID(SystemParameterConstant.HEADER + 
            		SystemParameterConstant.FACILITY_ID + 
            		SystemParameterConstant.FOOTER);
        	m_execute.setScope("");
        }
        else{
	        //ͤξ
	        if (m_facilityId != null && m_facilityId.length() > 0){
	            m_execute.setFacilityID(m_facilityId);
	            m_execute.setScope(m_facilityPath);
	        } else {
	            result = new ValidateResult();
	            result.setValid(false);
	            result.setID(Messages.getString("message.hinemos.1"));
	            result.setMessage(Messages.getString("message.hinemos.3"));
	            return result;
	        }
        }

        //ˡ
        if (m_allNode.getSelection()) {
            m_execute
                    .setProcessingMethod(ProcessingMethodConstant.TYPE_ALL_NODE);
        } else {
            m_execute.setProcessingMethod(ProcessingMethodConstant.TYPE_RETRY);
        }

        //ưޥɼ
        if (m_startCommand.getText().length() > 0) {
            m_execute.setStartCommand(m_startCommand.getText());
        } else {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString("message.hinemos.1"));
            result.setMessage(Messages.getString("message.job.3"));
            return result;
        }

        //ߥޥɼ
        if (m_stopCommand.getText().length() > 0) {
            m_execute.setStopCommand(m_stopCommand.getText());
        } else {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString("message.hinemos.1"));
            result.setMessage(Messages.getString("message.job.4"));
            return result;
        }

        //桼
        if (m_user.getText().length() > 0) {
            m_execute.setUser(m_user.getText());
        } else {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString("message.hinemos.1"));
            result.setMessage(Messages.getString("message.job.5"));
            return result;
        }

        //顼λ
        m_execute.setErrorEndFlg(YesNoConstant.booleanToType(m_errorCondition
                .getSelection()));

        //顼λͼ
        try {
            m_execute.setErrorEndValue(Integer.parseInt(m_errorEndValue
                    .getText()));
        } catch (NumberFormatException e) {
            if (m_execute.getErrorEndValue() == YesNoConstant.TYPE_YES) {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString("message.hinemos.1"));
                result.setMessage(Messages.getString("message.job.21"));
                return result;
            }
        }

        return null;
    }
}