/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.composite;

import java.util.ArrayList;

import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableTreeViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;

import com.clustercontrol.bean.CommonTableTreeItem;
import com.clustercontrol.composite.CommonTableTreeViewer;
import com.clustercontrol.jobmanagement.action.GetJobDetail;
import com.clustercontrol.jobmanagement.action.GetJobDetailTableDefine;
import com.clustercontrol.jobmanagement.bean.JobDetailTableDefine;
import com.clustercontrol.jobmanagement.composite.action.JobDetailSelectionChangedListener;
import com.clustercontrol.jobmanagement.composite.action.SessionJonDoubleClickListener;
import com.clustercontrol.util.Messages;

/**
 * ־ܺ٥ݥåȥ饹
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class DetailComposite extends Composite {
    protected CommonTableTreeViewer m_viewer = null;

    protected String m_sessionId = null;

    protected String m_jobId = null;

    protected Label m_sessionIdLabel = null;

    /**
     * 󥹥ȥ饯
     * 
     * @param parent
     * @param style
     * @since 1.0.0
     */
    public DetailComposite(Composite parent, int style) {
        super(parent, style);
        initialize();
    }

    /**
     * 
     * 
     * @since 1.0.0
     */
	private void initialize() {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout(layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;

        //åID٥
        m_sessionIdLabel = new Label(this, SWT.LEFT);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        m_sessionIdLabel.setLayoutData(gridData);

        //־ܺ٥ơ֥
        TableTree tree = new TableTree(this, SWT.H_SCROLL | SWT.V_SCROLL
                | SWT.FULL_SELECTION | SWT.SINGLE);

        Table table = tree.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);

        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        tree.setLayoutData(gridData);

        m_viewer = new CommonTableTreeViewer(tree);
        m_viewer.createTableColumn(GetJobDetailTableDefine.get(),
                JobDetailTableDefine.SORT_COLUMN_INDEX,
                JobDetailTableDefine.SORT_ORDER);

        m_viewer.addSelectionChangedListener(
        		new JobDetailSelectionChangedListener(this));
        
        m_viewer.addDoubleClickListener(
        		new SessionJonDoubleClickListener(this));

        update(null);
    }

    /**
     * 
     * 
     * @since 1.0.0
     */
    public void update(String sessionId) {
        //־ܺپ
        GetJobDetail getJobDetail = new GetJobDetail();
        CommonTableTreeItem item = null;
        if (sessionId != null && sessionId.length() > 0) {
            item = getJobDetail.getJobDetail(sessionId);
        }
        m_viewer.setInput(item);
        m_viewer.expandAll();

        if (m_sessionId != null && m_sessionId.length() > 0
                && sessionId != null && sessionId.length() > 0
                && m_sessionId.compareTo(sessionId) == 0) {
            selectDetail(item);
        } else {
            setJobId(null);
        }

        m_sessionId = sessionId;

        //åIDɽ
        if (m_sessionId != null) {
            m_sessionIdLabel.setText(Messages.getString("session.id") + " : "
                    + m_sessionId);
        } else {
            m_sessionIdLabel.setText(Messages.getString("session.id") + " : ");
        }
    }

    /**
     * 
     * 
     * @param jobDetailInfo
     *            ־ܺپ
     * @since 1.0.0
     */
    public void selectDetail(CommonTableTreeItem item) {
        if (getJobId() != null && getJobId().length() > 0) {
            if (m_viewer.getSelection().isEmpty()) {
                boolean select = false;
                ArrayList list = item.getData();
                if (list instanceof ArrayList) {
                    String jobId = (String) list
                            .get(JobDetailTableDefine.JOB_ID);
                    if (getJobId().compareTo(jobId) == 0) {
                        select = true;
                    }
                }

                if (select) {
                    m_viewer.setSelection(new StructuredSelection(item), true);
                } else {
                    for (int i = 0; i < item.getChildren().length; i++) {
                        CommonTableTreeItem children = item.getChildren()[i];
                        selectDetail(children);
                    }
                }
            }
        }
    }

    /**
     * ΥݥåȤѤơ֥ĥ꡼ӥ塼֤ޤ
     * 
     * @return ơ֥ĥ꡼ӥ塼
     */
    public TableTreeViewer getTableTreeViewer() {
        return m_viewer;
    }

    /**
     * ΥݥåȤѤơ֥֤ޤ
     * 
     * @return ơ֥
     */
	public Table getTable() {
        return m_viewer.getTableTree().getTable();
    }

    /**
     * ΥݥåȤѤơ֥ĥ꡼֤ޤ
     * 
     * @return ơ֥ĥ꡼
     */
	public TableTree getTableTree() {
        return m_viewer.getTableTree();
    }

    /**
     * @return Returns the sessionId.
     */
    public String getSessionId() {
        return m_sessionId;
    }

    /**
     * @param sessionId
     *            The sessionId to set.
     */
    public void setSessionId(String sessionId) {
        m_sessionId = sessionId;
    }

    /**
     * @return Returns the jobId.
     */
    public String getJobId() {
        return m_jobId;
    }

    /**
     * @param jobId
     *            The jobId to set.
     */
    public void setJobId(String jobId) {
        m_jobId = jobId;
    }
}