/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.composite;

import java.util.ArrayList;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

import com.clustercontrol.bean.EndStatusColorConstant;
import com.clustercontrol.bean.EndStatusConstant;
import com.clustercontrol.bean.SizeConstant;
import com.clustercontrol.composite.NumberVerifyListener;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.jobmanagement.bean.JobEndStatusInfo;
import com.clustercontrol.util.Messages;

/**
 * λ֥ݥåȥ饹
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class EndStatusComposite extends Composite {
    protected Text m_normalValue = null;

    protected Text m_normalStartRange = null;

    protected Text m_normalEndRange = null;

    protected Text m_warningValue = null;

    protected Text m_warningStartRange = null;

    protected Text m_warningEndRange = null;

    protected Text m_abnormalValue = null;

    protected ArrayList m_end = null;

    /**
     * 󥹥ȥ饯
     * 
     * @param parent
     * @param style
     * @since 1.0.0
     */
    public EndStatusComposite(Composite parent, int style) {
        super(parent, style);
        initialize();
    }

    /**
     * 
     * 
     * @since 1.0.0
     */
    private void initialize() {
        RowLayout layout = new RowLayout();
        layout.type = SWT.VERTICAL;
        layout.spacing = 10;
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.fill = true;
        this.setLayout(layout);

        Composite composite = null;
        RowLayout rowLayout = null;

        composite = new Composite(this, SWT.NONE);
        rowLayout = new RowLayout();
        rowLayout.type = SWT.HORIZONTAL;
        rowLayout.spacing = 10;
        composite.setLayout(rowLayout);

        Label dummy1 = new Label(composite, SWT.NONE);
        dummy1.setLayoutData(new RowData(40, SizeConstant.SIZE_LABEL_HEIGHT));

        Label endValueTitle = new Label(composite, SWT.CENTER);
        endValueTitle.setText(Messages.getString("end.value"));
        endValueTitle.setLayoutData(new RowData(100,
                SizeConstant.SIZE_LABEL_HEIGHT));

        Label rangeTitle = new Label(composite, SWT.CENTER);
        rangeTitle.setText(Messages.getString("range.end.value"));
        rangeTitle.setLayoutData(new RowData(240,
                SizeConstant.SIZE_LABEL_HEIGHT));

        //
        composite = new Composite(this, SWT.NONE);
        rowLayout = new RowLayout();
        rowLayout.type = SWT.HORIZONTAL;
        rowLayout.spacing = 10;
        composite.setLayout(rowLayout);

        Label normalTitle = new Label(composite, SWT.CENTER);
        normalTitle.setText(EndStatusConstant.STRING_NORMAL + " : ");
        normalTitle.setLayoutData(new RowData(40,
                SizeConstant.SIZE_LABEL_HEIGHT));
        normalTitle.setBackground(EndStatusColorConstant.COLOR_NORMAL);

        m_normalValue = new Text(composite, SWT.BORDER);
        m_normalValue.setLayoutData(new RowData(100,
                SizeConstant.SIZE_TEXT_HEIGHT));
        m_normalValue.addVerifyListener(new NumberVerifyListener());

        m_normalStartRange = new Text(composite, SWT.BORDER);
        m_normalStartRange.setText("");
        m_normalStartRange.setLayoutData(new RowData(100,
                SizeConstant.SIZE_TEXT_HEIGHT));
        m_normalStartRange.addVerifyListener(new NumberVerifyListener());

        Label normalTo = new Label(composite, SWT.CENTER);
        normalTo.setText("");
        normalTo.setLayoutData(new RowData(20, SizeConstant.SIZE_LABEL_HEIGHT));

        m_normalEndRange = new Text(composite, SWT.BORDER);
        m_normalEndRange.setText("");
        m_normalEndRange.setLayoutData(new RowData(100,
                SizeConstant.SIZE_TEXT_HEIGHT));
        m_normalEndRange.addVerifyListener(new NumberVerifyListener());

        //ٹ
        composite = new Composite(this, SWT.NONE);
        rowLayout = new RowLayout();
        rowLayout.type = SWT.HORIZONTAL;
        rowLayout.spacing = 10;
        composite.setLayout(rowLayout);

        Label warningTitle = new Label(composite, SWT.CENTER);
        warningTitle.setText(EndStatusConstant.STRING_WARNING + " : ");
        warningTitle.setLayoutData(new RowData(40,
                SizeConstant.SIZE_LABEL_HEIGHT));
        warningTitle.setBackground(EndStatusColorConstant.COLOR_WARNING);

        m_warningValue = new Text(composite, SWT.BORDER);
        m_warningValue.setLayoutData(new RowData(100,
                SizeConstant.SIZE_TEXT_HEIGHT));
        m_warningValue.addVerifyListener(new NumberVerifyListener());

        m_warningStartRange = new Text(composite, SWT.BORDER);
        m_warningStartRange.setText("");
        m_warningStartRange.setLayoutData(new RowData(100,
                SizeConstant.SIZE_TEXT_HEIGHT));
        m_warningStartRange.addVerifyListener(new NumberVerifyListener());

        Label warningTo = new Label(composite, SWT.CENTER);
        warningTo.setText("");
        warningTo
                .setLayoutData(new RowData(20, SizeConstant.SIZE_LABEL_HEIGHT));

        m_warningEndRange = new Text(composite, SWT.BORDER);
        m_warningEndRange.setText("");
        m_warningEndRange.setLayoutData(new RowData(100,
                SizeConstant.SIZE_TEXT_HEIGHT));
        m_warningEndRange.addVerifyListener(new NumberVerifyListener());

        //۾
        composite = new Composite(this, SWT.NONE);
        rowLayout = new RowLayout();
        rowLayout.type = SWT.HORIZONTAL;
        rowLayout.spacing = 10;
        composite.setLayout(rowLayout);

        Label abnormalTitle = new Label(composite, SWT.CENTER);
        abnormalTitle.setText(EndStatusConstant.STRING_ABNORMAL + " : ");
        abnormalTitle.setLayoutData(new RowData(40,
                SizeConstant.SIZE_LABEL_HEIGHT));
        abnormalTitle.setBackground(EndStatusColorConstant.COLOR_ABNORMAL);

        m_abnormalValue = new Text(composite, SWT.BORDER);
        m_abnormalValue.setLayoutData(new RowData(100,
                SizeConstant.SIZE_TEXT_HEIGHT));
        m_abnormalValue.addVerifyListener(new NumberVerifyListener());

        Label abnormalMessage = new Label(composite, SWT.CENTER);
        abnormalMessage.setText(Messages.getString("other"));
        abnormalMessage.setLayoutData(new RowData(240,
                SizeConstant.SIZE_LABEL_HEIGHT));
    }

    /**
     * λȿ
     *  
     */
    public void reflectEndInfo() {
        if (m_end instanceof ArrayList) {
            JobEndStatusInfo infoNormal = null;
            JobEndStatusInfo infoWarning = null;
            JobEndStatusInfo infoAbnormal = null;

            for (int i = 0; i < m_end.size(); i++) {
                if (((JobEndStatusInfo) m_end.get(i)).getType() == EndStatusConstant.TYPE_NORMAL) {
                    infoNormal = (JobEndStatusInfo) m_end.get(i);
                } else if (((JobEndStatusInfo) m_end.get(i)).getType() == EndStatusConstant.TYPE_WARNING) {
                    infoWarning = (JobEndStatusInfo) m_end.get(i);
                } else if (((JobEndStatusInfo) m_end.get(i)).getType() == EndStatusConstant.TYPE_ABNORMAL) {
                    infoAbnormal = (JobEndStatusInfo) m_end.get(i);
                }
            }

            //
            if (infoNormal instanceof JobEndStatusInfo) {
                //λ
                m_normalValue.setText(String.valueOf(infoNormal.getValue()));
                //λϰϤγ
                m_normalStartRange.setText(String.valueOf(infoNormal
                        .getStartRangeValue()));
                //λϰϤνλ
                m_normalEndRange.setText(String.valueOf(infoNormal
                        .getEndRangeValue()));
            }

            //ٹ
            if (infoWarning instanceof JobEndStatusInfo) {
                //λ
                m_warningValue.setText(String.valueOf(infoWarning.getValue()));
                //λϰϤγ
                m_warningStartRange.setText(String.valueOf(infoWarning
                        .getStartRangeValue()));
                //λϰϤνλ
                m_warningEndRange.setText(String.valueOf(infoWarning
                        .getEndRangeValue()));
            }

            //۾
            if (infoAbnormal instanceof JobEndStatusInfo) {
                //λ
                m_abnormalValue
                        .setText(String.valueOf(infoAbnormal.getValue()));
            }
        } else {
            m_normalValue.setText(String
                    .valueOf(EndStatusConstant.INITIAL_VALUE_NORMAL));
            m_normalStartRange.setText("");
            m_normalEndRange.setText("");
            m_warningValue.setText(String
                    .valueOf(EndStatusConstant.INITIAL_VALUE_WARNING));
            m_warningStartRange.setText("");
            m_warningEndRange.setText("");
            m_abnormalValue.setText(String
                    .valueOf(EndStatusConstant.INITIAL_VALUE_ABNORMAL));
        }
    }

    /**
     * λ
     * 
     * @param m_endStatus
     */
    public void setEndInfo(ArrayList end) {
        m_end = end;
    }

    /**
     * λ
     * 
     * @return
     */
    public ArrayList getEndInfo() {
        return m_end;
    }

    /**
     * λ
     * 
     * @return
     */
    @SuppressWarnings("unchecked")
	public ValidateResult createEndInfo() {
        ValidateResult result = null;

        JobEndStatusInfo infoNormal = null;
        JobEndStatusInfo infoWarning = null;
        JobEndStatusInfo infoAbnormal = null;

        //λ󥯥饹Υ󥹥󥹤
        m_end = new ArrayList();
        infoNormal = new JobEndStatusInfo();
        infoNormal.setType(EndStatusConstant.TYPE_NORMAL);
        m_end.add(infoNormal);
        infoWarning = new JobEndStatusInfo();
        infoWarning.setType(EndStatusConstant.TYPE_WARNING);
        m_end.add(infoWarning);
        infoAbnormal = new JobEndStatusInfo();
        infoAbnormal.setType(EndStatusConstant.TYPE_ABNORMAL);
        m_end.add(infoAbnormal);

        try {
            //νλͼ
            infoNormal.setValue(Integer.parseInt(m_normalValue.getText()));
        } catch (NumberFormatException e) {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString("message.hinemos.1"));
            result.setMessage(Messages.getString("message.job.7"));
            return result;
        }
        try {
            //νλϰϤγͼ
            infoNormal.setStartRangeValue(Integer.parseInt(m_normalStartRange
                    .getText()));
        } catch (NumberFormatException e) {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString("message.hinemos.1"));
            result.setMessage(Messages.getString("message.job.8"));
            return result;
        }
        try {
            //νλϰϤνλͼ
            infoNormal.setEndRangeValue(Integer.parseInt(m_normalEndRange
                    .getText()));
        } catch (NumberFormatException e) {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString("message.hinemos.1"));
            result.setMessage(Messages.getString("message.job.9"));
            return result;
        }

        try {
            //ٹνλͼ
            infoWarning.setValue(Integer.parseInt(m_warningValue.getText()));
        } catch (NumberFormatException e) {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString("message.hinemos.1"));
            result.setMessage(Messages.getString("message.job.10"));
            return result;
        }
        try {
            //ٹνλϰϤγͼ
            infoWarning.setStartRangeValue(Integer.parseInt(m_warningStartRange
                    .getText()));
        } catch (NumberFormatException e) {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString("message.hinemos.1"));
            result.setMessage(Messages.getString("message.job.11"));
            return result;
        }
        try {
            //ٹνλϰϤνλͼ
            infoWarning.setEndRangeValue(Integer.parseInt(m_warningEndRange
                    .getText()));
        } catch (NumberFormatException e) {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString("message.hinemos.1"));
            result.setMessage(Messages.getString("message.job.12"));
            return result;
        }

        try {
            //۾νλͼ
            infoAbnormal.setValue(Integer.parseInt(m_abnormalValue.getText()));
        } catch (NumberFormatException e) {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString("message.hinemos.1"));
            result.setMessage(Messages.getString("message.job.13"));
            return result;
        }

        //νλϰϥå
        if (infoNormal.getStartRangeValue() > infoNormal.getEndRangeValue()) {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString("message.hinemos.1"));
            result.setMessage(Messages.getString("message.job.14"));
            return result;
        }

        //ٹνλϰϥå
        if (infoWarning.getStartRangeValue() > infoWarning.getEndRangeValue()) {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString("message.hinemos.1"));
            result.setMessage(Messages.getString("message.job.15"));
            return result;
        }

        return null;
    }
}