/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.composite;

import java.util.ArrayList;

import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;

import com.clustercontrol.composite.CommonTableViewer;
import com.clustercontrol.jobmanagement.action.GetJobList;
import com.clustercontrol.jobmanagement.action.GetJobTableDefine;
import com.clustercontrol.jobmanagement.bean.JobTableDefine;
import com.clustercontrol.jobmanagement.bean.JobTreeItem;
import com.clustercontrol.util.Messages;

/**
 * Ͽݥåȥ饹
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class JobListComposite extends Composite {
    protected CommonTableViewer m_viewer = null;

    protected Label m_path = null;

    protected JobTreeItem m_jobTreeItem = null;

    protected JobTreeItem m_selectJobTreeItem = null;

    /**
     * 󥹥ȥ饯
     * 
     * @param parent
     * @param style
     * @since 1.0.0
     */
    public JobListComposite(Composite parent, int style) {
        super(parent, style);
        initialize();
    }

    /**
     * 
     * 
     * @since 1.0.0
     */
    private void initialize() {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout(layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;

        m_path = new Label(this, SWT.LEFT);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        m_path.setLayoutData(gridData);

        Table table = new Table(this, SWT.H_SCROLL | SWT.V_SCROLL
                | SWT.FULL_SELECTION | SWT.SINGLE);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);

        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        table.setLayoutData(gridData);

        m_viewer = new CommonTableViewer(table);
        m_viewer.createTableColumn(GetJobTableDefine.get(),
                JobTableDefine.SORT_COLUMN_INDEX, JobTableDefine.SORT_ORDER);
    }

    /**
     * ΥݥåȤѤơ֥ӥ塼֤ޤ
     * 
     * @return ơ֥ӥ塼
     */
    public TableViewer getTableViewer() {
        return m_viewer;
    }

    /**
     * ΥݥåȤѤơ֥֤ޤ
     * 
     * @return ơ֥
     */
    public Table getTable() {
        return m_viewer.getTable();
    }

    /**
     * 
     * 
     * @since 1.0.0
     */
    public void update(JobTreeItem item) {
        if (item instanceof JobTreeItem) {
            m_path.setText(Messages.getString("job") + " : " + item.getPath());
        } else {
            m_path.setText(Messages.getString("job") + " : ");
        }

        m_jobTreeItem = item;
        m_selectJobTreeItem = null;

        ArrayList jobInfo = null;

        //ְ
        GetJobList getJobList = new GetJobList();
        jobInfo = getJobList.getJobList(item);

        m_viewer.setInput(jobInfo);
    }

    /**
     * @return Returns the selectJobTreeItem.
     */
    public JobTreeItem getSelectJobTreeItem() {
        return m_selectJobTreeItem;
    }

    /**
     * @param jobTreeItem
     *            The selectJobTreeItem to set.
     */
    public void setSelectJobTreeItem(JobTreeItem jobTreeItem) {
        m_selectJobTreeItem = jobTreeItem;
    }

    /**
     * @return Returns the jobTreeItem.
     */
    public JobTreeItem getJobTreeItem() {
        return m_jobTreeItem;
    }

    /**
     * @param jobTreeItem
     *            The jobTreeItem to set.
     */
    public void setJobTreeItem(JobTreeItem jobTreeItem) {
        m_jobTreeItem = jobTreeItem;
    }
}